/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.SaveDocumentBaseFunctionExecutor;
import com.oxygenxml.positron.core.tools.ToolsSessionManager;
import com.oxygenxml.positron.core.tools.internal.FilesValidator;
import com.oxygenxml.positron.core.tools.internal.exceptions.ValidationFailedException;
import com.oxygenxml.positron.core.util.MCPUtil;
import com.oxygenxml.positron.core.util.WSEditorUtils;
import com.oxygenxml.positron.utilities.exceptions.AccessDeniedException;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.parameters.SaveDocumentProperties;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import ro.sync.basic.io.IOUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;

public class SaveDocumentFunctionExecutor
extends SaveDocumentBaseFunctionExecutor {
    private static final String URL_OF_SAVED_DOCUMENT_PREFIX = "\nURL of saved document: ";

    @Override
    protected URL enrichURLWithConnectionData(URL url) {
        return url;
    }

    @Override
    protected URL getCurrentEditorLocation() {
        URL toRet = null;
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        WSEditor currentEditorAccess = pluginWorkspace.getCurrentEditorAccess(0);
        if (currentEditorAccess != null) {
            toRet = currentEditorAccess.getEditorLocation();
        }
        return toRet;
    }

    @Override
    protected void validateDocument(URL documentURL) throws ValidationFailedException {
        this.validateDocument(documentURL, null);
    }

    private void validateDocument(URL documentURL, String content) throws ValidationFailedException {
        FilesValidator validator = new FilesValidator();
        if (content != null && FilesValidator.allowsValidationWithCustomContent()) {
            HashMap<URL, String> documentsContentMap = new HashMap<URL, String>();
            documentsContentMap.put(documentURL, content);
            validator.validate(Arrays.asList(documentURL), url -> documentsContentMap.getOrDefault(url, ""));
        } else {
            validator.validate(Arrays.asList(documentURL));
        }
        if (validator.isValidationFailed()) {
            throw new ValidationFailedException("File was saved but the following validation problems occured: " + validator.generateValidationReport());
        }
    }

    @Override
    protected void createFileAncestorDirectories(URL urlToWriteTo) throws CannotExecuteFunctionException {
        if (!WSEditorUtils.isNewDocument(urlToWriteTo)) {
            super.createFileAncestorDirectories(urlToWriteTo);
        }
    }

    @Override
    protected String saveDocument(URL urlToWriteTo, SaveDocumentProperties properties) throws IOException, ValidationFailedException {
        WSEditor editor = WSEditorUtils.getEditor(urlToWriteTo);
        if (WSEditorUtils.isNewDocument(editor)) {
            String previousContent = IOUtil.read((Reader)editor.createContentReader()).toString();
            editor.reloadContent((Reader)new StringReader(properties.content), false);
            ToolsSessionManager toolsSessionManager = ToolsSessionManager.getInstance();
            if (toolsSessionManager.isToolsDocumentsChangesSupportAvailable()) {
                toolsSessionManager.getToolsDocumentsChangesManager().storeChange(this.toolId, urlToWriteTo, properties.content, previousContent);
            }
            return "Content successfully saved and validated";
        }
        String previousContent = this.getDocumentContent(urlToWriteTo);
        return this.doSaveDocument(urlToWriteTo, properties, false, previousContent);
    }

    private String doSaveDocument(URL urlToWriteTo, SaveDocumentProperties properties, boolean wasUntitled, String previousContent) throws IOException, ValidationFailedException {
        ToolsSessionManager toolsSessionManager = ToolsSessionManager.getInstance();
        try {
            Object saveResult = super.saveDocument(urlToWriteTo, properties);
            if (wasUntitled) {
                saveResult = (String)saveResult + URL_OF_SAVED_DOCUMENT_PREFIX + urlToWriteTo.toExternalForm();
            }
            if (saveResult != null && ((String)saveResult).startsWith("Content successfully saved and validated") && toolsSessionManager.isToolsDocumentsChangesSupportAvailable()) {
                toolsSessionManager.getToolsDocumentsChangesManager().storeChange(this.toolId, urlToWriteTo, properties.content, previousContent);
            }
            return saveResult;
        }
        catch (ValidationFailedException ex) {
            if (toolsSessionManager.isToolsDocumentsChangesSupportAvailable()) {
                toolsSessionManager.getToolsDocumentsChangesManager().storeChange(this.toolId, urlToWriteTo, properties.content, previousContent);
            }
            throw new ValidationFailedException(ex.getMessage() + URL_OF_SAVED_DOCUMENT_PREFIX + urlToWriteTo.toExternalForm());
        }
    }

    @Override
    protected String getDocumentContent(URL docURL) {
        this.saveEditorContentIfModified(docURL);
        return super.getDocumentContent(docURL);
    }

    @Override
    protected void checkAccessToLocation(URL url) throws AccessDeniedException {
        if (!WSEditorUtils.isNewDocument(url)) {
            FunctionsAndRAGHelperProvider.getProjectRAGHelper().checkDocumentAccessPermissions(url.toExternalForm(), false, true);
        }
    }

    @Override
    public boolean requireUserConfirmation() {
        return false;
    }

    private void saveEditorContentIfModified(URL url) {
        WSEditor editorAccess;
        PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
        if (pw != null && (editorAccess = pw.getEditorAccess(url, 0)) != null && editorAccess.isModified()) {
            editorAccess.save();
        }
    }

    @Override
    protected void openDocument(URL url, String newSavedContent) {
        PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
        if (pw != null) {
            WSEditor editorAccess = pw.getEditorAccess(url, 0);
            if (editorAccess != null && !editorAccess.isModified()) {
                this.reloadEditorContent(editorAccess, newSavedContent);
            }
            pw.open(url);
        }
    }

    protected void reloadEditorContent(WSEditor editorAccess, String newSavedContent) {
        WSEditorUtils.reloadEditorContent(editorAccess, newSavedContent);
    }

    @Override
    protected void writeToURL(String content, URL urlToWriteTo, String javaEncoding) throws IOException {
        boolean mcpHandled = MCPUtil.handleSaveContent(urlToWriteTo, content);
        if (!mcpHandled) {
            super.writeToURL(content, urlToWriteTo, javaEncoding);
        }
    }
}

