/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.actions.validation.AutoValidationManager;
import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.FunctionExecutorUtils;
import com.oxygenxml.positron.core.tools.internal.exceptions.ValidationFailedException;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.core.util.ContextExtractorUtil;
import com.oxygenxml.positron.core.util.MCPUtil;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.exceptions.AccessDeniedException;
import com.oxygenxml.positron.utilities.exceptions.InvalidParamException;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.SaveDocumentFunctionSignature;
import com.oxygenxml.positron.utilities.functions.parameters.SaveDocumentProperties;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.basic.xml.encoding.EncodingDetectorInterface;
import ro.sync.xml.encoding.EncodingDetector;

public abstract class SaveDocumentBaseFunctionExecutor
implements FunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(SaveDocumentBaseFunctionExecutor.class);
    protected static final String URL_PARAM_MISSING = "The 'url' parameter is missing. Please provide a valid URL and try again to proceed.";
    protected static final String CONTENT_PARAM_MISSING = "The 'content' parameter is missing. Please provide the content and try again to proceed.";
    protected static final String DIRECTORY_OF_RESOURCE_COULD_NOT_BE_CREATED = "The directory of the resource could not be created";
    protected static final String RESOURCE_SUCCESSFULLY_CREATED = "Content successfully saved and validated";
    private static final String COULD_NOT_SAVE_CHANGES_TO_RESOURCE_ERROR = "Could not save changes to resource";
    protected String toolId = null;
    private SaveDocumentFunctionSignature functionDef = new SaveDocumentFunctionSignature(){

        public String getDescription() {
            return MCPUtil.enrichSaveToolDescription(super.getDescription());
        }
    };

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        if (log.isDebugEnabled()) {
            log.debug("Create file: " + arguments);
        }
        this.toolId = toolId;
        SaveDocumentProperties fileProperties = (SaveDocumentProperties)arguments;
        try {
            this.checkArgs(fileProperties);
        }
        catch (InvalidParamException ex) {
            return ex.getMessage();
        }
        URL urlToWriteTo = this.convertToURL(fileProperties.url);
        if (urlToWriteTo == null) {
            throw new CannotExecuteFunctionException("Could not convert to URL " + fileProperties.url, true);
        }
        this.checkURLNotDirectoryPath(urlToWriteTo);
        this.createFileAncestorDirectories(urlToWriteTo);
        urlToWriteTo = this.enrichURLWithConnectionData(urlToWriteTo);
        try {
            this.checkAccessToLocation(urlToWriteTo);
            String saveStatus = this.saveDocument(urlToWriteTo, fileProperties);
            return saveStatus;
        }
        catch (IOException e) {
            log.error("Could not write content to file: {} because :{}", new Object[]{URLUtil.clearUserInfo((URL)urlToWriteTo), e.getMessage(), e});
            return "Could not save changes to resource: " + e.getMessage();
        }
        catch (ValidationFailedException | AccessDeniedException ex) {
            return ex.getMessage();
        }
    }

    protected URL convertToURL(String url) {
        return FunctionExecutorUtils.convertToURL(url, this::getCurrentEditorLocation);
    }

    private void checkURLNotDirectoryPath(URL urlToWriteTo) throws CannotExecuteFunctionException {
        if (urlToWriteTo != null && urlToWriteTo.toExternalForm().endsWith("/")) {
            CannotExecuteFunctionException cannotExecuteFunctionException = new CannotExecuteFunctionException("Invalid attempt to save file content to an URL directory location: " + URLUtil.clearUserInfo((URL)urlToWriteTo));
            cannotExecuteFunctionException.setFatal(false);
            throw cannotExecuteFunctionException;
        }
    }

    protected String saveDocument(URL urlToWriteTo, SaveDocumentProperties properties) throws IOException, ValidationFailedException {
        EncodingDetectorInterface encodingDetector = EncodingDetector.getInstance();
        String javaEncoding = encodingDetector.getJavaEncoding((Reader)new StringReader(properties.content), false, new ArrayList());
        String content = TextUtils.handleInvalidCharacters(properties.content, TextUtils.getContentType(properties.url));
        this.writeToURL(content, urlToWriteTo, javaEncoding);
        this.openDocument(urlToWriteTo, content);
        if (AutoValidationManager.isAutoValidationOnInsertionEnabled() && properties.validate) {
            this.validateDocument(urlToWriteTo);
        }
        return RESOURCE_SUCCESSFULLY_CREATED;
    }

    protected void writeToURL(String content, URL urlToWriteTo, String javaEncoding) throws IOException {
        OutputStream outputStreamFromURL = URLUtil.openOutputStream((URL)urlToWriteTo);
        try (OutputStreamWriter writerWithEncoding = new OutputStreamWriter(outputStreamFromURL, javaEncoding != null ? javaEncoding : StandardCharsets.UTF_8.name());){
            writerWithEncoding.write(content);
        }
    }

    protected String getDocumentContent(URL docURL) {
        try {
            return ContextExtractorUtil.readDocumentContent(this.enrichURLWithConnectionData(docURL));
        }
        catch (IOException e) {
            return null;
        }
    }

    private void checkArgs(SaveDocumentProperties arguments) throws InvalidParamException {
        if (arguments.url == null) {
            throw new InvalidParamException(URL_PARAM_MISSING);
        }
        if (arguments.content == null) {
            throw new InvalidParamException(CONTENT_PARAM_MISSING);
        }
    }

    protected abstract URL getCurrentEditorLocation();

    protected abstract URL enrichURLWithConnectionData(URL var1);

    protected abstract void checkAccessToLocation(URL var1) throws AccessDeniedException;

    protected void createFileAncestorDirectories(URL urlToWriteTo) throws CannotExecuteFunctionException {
        boolean dirsCreated;
        File canonicalFile;
        File parentDir;
        if ("file".equalsIgnoreCase(urlToWriteTo.getProtocol()) && (parentDir = (canonicalFile = URLUtil.getCanonicalFileFromFileUrl((URL)urlToWriteTo)).getParentFile()) != null && !parentDir.exists() && !(dirsCreated = parentDir.mkdirs())) {
            CannotExecuteFunctionException cannotExecuteFunctionException = new CannotExecuteFunctionException(DIRECTORY_OF_RESOURCE_COULD_NOT_BE_CREATED);
            cannotExecuteFunctionException.setFatal(true);
            throw cannotExecuteFunctionException;
        }
    }

    protected abstract void validateDocument(URL var1) throws ValidationFailedException;

    protected abstract void openDocument(URL var1, String var2);

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ONLY_LAST_CALL;
    }
}

