/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.SaveDocumentFunctionExecutor;
import com.oxygenxml.positron.core.util.MCPUtil;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.InvokeXMLRefactorXSLTScriptFunctionSignature;
import com.oxygenxml.positron.utilities.functions.XMLRefactoringHelperProvider;
import com.oxygenxml.positron.utilities.functions.parameters.InvokeXMLRefactorXSLTScriptParams;
import com.oxygenxml.positron.utilities.functions.parameters.SaveDocumentProperties;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeXMLRefactorXSLTScriptFunctionExecutor
extends SaveDocumentFunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(InvokeXMLRefactorXSLTScriptFunctionExecutor.class);
    private InvokeXMLRefactorXSLTScriptFunctionSignature functionDef = new InvokeXMLRefactorXSLTScriptFunctionSignature(){

        public String getDescription() {
            return MCPUtil.enrichSaveToolDescription(super.getDescription());
        }
    };

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        if (log.isDebugEnabled()) {
            log.debug("Invoke AI action: " + arguments);
        }
        Object toRet = null;
        InvokeXMLRefactorXSLTScriptParams params = (InvokeXMLRefactorXSLTScriptParams)arguments;
        if (params != null && params.url != null && params.xslt != null) {
            try {
                SaveDocumentProperties saveProps = new SaveDocumentProperties();
                saveProps.content = this.refactorWithXSLT(params);
                saveProps.url = params.url;
                saveProps.validate = true;
                toRet = super.execute(toolId, saveProps);
            }
            catch (IOException e) {
                toRet = e.getMessage();
            }
        } else if (params == null) {
            toRet = "No parameters specified.";
        } else if (params.xslt == null) {
            toRet = "No XSLT script specified.";
        } else if (params.url == null) {
            toRet = "No document URL specified.";
        }
        return toRet;
    }

    private String refactorWithXSLT(InvokeXMLRefactorXSLTScriptParams params) throws IOException, MalformedURLException {
        String[] result = new String[1];
        URL url = this.convertToURL(params.url);
        if (url == null) {
            throw new MalformedURLException("Could not convert to URL " + params.url);
        }
        XMLRefactoringHelperProvider.getXMLRefactoringHelper().invokeXMLRefactorOperation(Arrays.asList(url).iterator(), t -> params.content, (t, u) -> {
            result[0] = u;
        }, params.xslt);
        return result[0];
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }
}

