/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.InvokeCmdLineFunctionSignature;
import com.oxygenxml.positron.utilities.functions.parameters.InvokeCmdLineParams;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeCmdLineFunctionExecutor
implements FunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(InvokeCmdLineFunctionExecutor.class);
    private InvokeCmdLineFunctionSignature functionDef = new InvokeCmdLineFunctionSignature();

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        InvokeCmdLineParams params;
        if (log.isDebugEnabled()) {
            log.debug("List files in directory: " + arguments);
        }
        if ((params = (InvokeCmdLineParams)arguments) != null && params.commandLine != null) {
            log.debug("Command line: {}", (Object)params.commandLine);
            try {
                String result = FunctionsAndRAGHelperProvider.getProjectRAGHelper().invokeCommandLine(params.commandLine, params.timeoutSeconds);
                log.debug("Invoke cmd line result: {} ", (Object)result);
                return result;
            }
            catch (IOException e) {
                log.debug((Throwable)e);
                throw new CannotExecuteFunctionException(e.getMessage(), true);
            }
        }
        if (params == null) {
            throw new CannotExecuteFunctionException("No cmd line parameters were provided", true);
        }
        if (params.commandLine == null) {
            throw new CannotExecuteFunctionException("No command line was provided", true);
        }
        return null;
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ALL_CALLS;
    }
}

