/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.InvokeActionHelperProvider;
import com.oxygenxml.positron.utilities.functions.InvokeAgentFunctionSignature;
import com.oxygenxml.positron.utilities.functions.parameters.InvokeAgentParams;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeAgentFunctionExecutor
implements FunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(InvokeAgentFunctionExecutor.class);
    private InvokeAgentFunctionSignature functionDef = new InvokeAgentFunctionSignature();

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        if (log.isDebugEnabled()) {
            log.debug("Invoke AI agent: " + arguments);
        }
        Object toRet = null;
        InvokeAgentParams params = (InvokeAgentParams)arguments;
        if (params != null && params.agentId != null && params.content != null) {
            try {
                return InvokeActionHelperProvider.getInvokeActionHelper().invokeAgent(params.agentId, params.extraPromptContext, params.content, this.getParams());
            }
            catch (IOException e) {
                return e.getMessage();
            }
        }
        if (params == null) {
            return "No parameters specified.";
        }
        if (params.agentId == null) {
            return "No agent ID specified.";
        }
        if (params.content == null) {
            return "No content specified.";
        }
        return toRet;
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ALL_CALLS;
    }

    protected Map<String, Object> getParams() {
        return null;
    }
}

