/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.InvokeActionFunctionSignature;
import com.oxygenxml.positron.utilities.functions.InvokeActionHelperProvider;
import com.oxygenxml.positron.utilities.functions.parameters.InvokeActionParams;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeActionFunctionExecutor
implements FunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(InvokeActionFunctionExecutor.class);
    private InvokeActionFunctionSignature functionDef = new InvokeActionFunctionSignature();

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        if (log.isDebugEnabled()) {
            log.debug("Invoke AI action: " + arguments);
        }
        Object toRet = null;
        InvokeActionParams params = (InvokeActionParams)arguments;
        if (params != null && params.actionId != null && params.content != null) {
            try {
                return InvokeActionHelperProvider.getInvokeActionHelper().invokeAction(params.actionId, params.extraPromptContext, params.content, this.getParams());
            }
            catch (IOException e) {
                return e.getMessage();
            }
        }
        if (params == null) {
            return "No parameters specified.";
        }
        if (params.actionId == null) {
            return "No action ID specified.";
        }
        if (params.content == null) {
            return "No content specified.";
        }
        return toRet;
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ALL_CALLS;
    }

    protected Map<String, Object> getParams() {
        return null;
    }
}

