/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.tools.DocumentAccessFunctionExecutor;
import com.oxygenxml.positron.core.tools.GetTextAroundCaretFunctionExecutor;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.core.util.OutlineComponentsUtil;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.GetXSLComponentDetailsSignature;
import com.oxygenxml.positron.utilities.functions.IComponent;
import com.oxygenxml.positron.utilities.functions.IXSLComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetXSLComponentDetailsExecutor
extends DocumentAccessFunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(GetXSLComponentDetailsExecutor.class);
    private GetXSLComponentDetailsSignature getXSLComponentDetailsSignature = new GetXSLComponentDetailsSignature();

    @Override
    public Object execute(String toolId, Object arguments) {
        if (OutlineComponentsUtil.checkGetComponentsProviderAvailable()) {
            IXSLComponent ixslComponent = (IXSLComponent)arguments;
            this.fixUpComponent(ixslComponent);
            try {
                return OutlineComponentsUtil.findComponent((IComponent)ixslComponent);
            }
            catch (Exception e) {
                log.debug((Throwable)e);
            }
        }
        GetTextAroundCaretFunctionExecutor functionExecutor = new GetTextAroundCaretFunctionExecutor();
        functionExecutor.setDocumentContentExtractorSupplier(() -> this.getDocumentContentExtractor());
        return functionExecutor.execute(toolId, null);
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.getXSLComponentDetailsSignature;
    }

    private void fixUpComponent(IXSLComponent ixslComponent) {
        String mode;
        String match;
        String name;
        String type = ixslComponent.getType();
        if (type != null && (type.isEmpty() || type.equals("null"))) {
            ixslComponent.setType(null);
        }
        if ((name = ixslComponent.getName()) != null && (name.isEmpty() || name.equals("null"))) {
            ixslComponent.setName(null);
        }
        if ((match = ixslComponent.getMatch()) != null && (match.isEmpty() || match.equals("null") || match.equals("*"))) {
            ixslComponent.setMatch(null);
        }
        if ((mode = ixslComponent.getMode()) != null && (mode.isEmpty() || mode.equals("null"))) {
            ixslComponent.setMode(null);
        }
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ALL_CALLS;
    }
}

