/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.RAGFunctionExecutorUtil;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.GetRelatedWebHelpContentFunctionSignature;
import com.oxygenxml.positron.utilities.functions.RAGException;
import com.oxygenxml.positron.utilities.functions.parameters.SearchKeywords;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRelatedWebHelpContentFunctionExecutor
implements FunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(GetRelatedWebHelpContentFunctionExecutor.class);
    private GetRelatedWebHelpContentFunctionSignature functionDef = new GetRelatedWebHelpContentFunctionSignature();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        if (log.isDebugEnabled()) {
            log.debug("Get related project content: " + arguments);
        }
        String toRet = null;
        SearchKeywords kw = (SearchKeywords)arguments;
        if (kw == null) throw new CannotExecuteFunctionException("No webhelp search parameters specified");
        String keywords = kw.keywords;
        if (log.isDebugEnabled()) {
            log.debug("Keywords: " + keywords);
        }
        if (keywords == null) throw new CannotExecuteFunctionException("No keywords are specified");
        try {
            toRet = FunctionsAndRAGHelperProvider.getProjectRAGHelper().getRelatedWebHelpContent(null, keywords);
        }
        catch (RAGException e) {
            if (!log.isDebugEnabled()) throw RAGFunctionExecutorUtil.translateProjectRAGException(e);
            log.debug((Object)e, (Throwable)e);
            throw RAGFunctionExecutorUtil.translateProjectRAGException(e);
        }
        if (!log.isDebugEnabled()) return toRet;
        log.debug("Expand to: " + toRet);
        return toRet;
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ONLY_LAST_CALL;
    }
}

