/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.aiignore.AiIgnoreManager;
import com.oxygenxml.positron.core.aiignore.AiIgnoreManagerProvider;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.DocumentAccessFunctionExecutor;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.GetCurrentEditorFileLocationFunctionSignature;
import java.net.URL;
import java.text.MessageFormat;
import ro.sync.basic.util.URLUtil;

public class GetCurrentEditorFileLocationFunctionExecutor
extends DocumentAccessFunctionExecutor {
    private final GetCurrentEditorFileLocationFunctionSignature functionDef = new GetCurrentEditorFileLocationFunctionSignature();

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        URL editorLocation;
        Object toReturn = "No document is opened in the application main editor area.";
        DocumentContentInteractor documentContentExtractor = this.getDocumentContentExtractor();
        if (documentContentExtractor != null && (editorLocation = documentContentExtractor.getEditorLocation()) != null) {
            toReturn = URLUtil.clearUserInfo((URL)editorLocation);
            AiIgnoreManager aiIgnoreChecker = AiIgnoreManagerProvider.getAiIgnoreChecker();
            if (aiIgnoreChecker != null && aiIgnoreChecker.isIgnoredFromAiIgnoreFile(editorLocation)) {
                toReturn = MessageFormat.format(Translator.getInstance().getTranslation("Access_denied_to_File_is_not_AI_accessible"), toReturn);
            }
        }
        return toReturn;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ONLY_LAST_CALL;
    }
}

