/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.aiignore.OperationCancelledByAiIgnoreException;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.tools.DocumentAccessFunctionExecutor;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.exceptions.AccessDeniedException;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelper;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.GetCurrentDocumentContentFunctionSignature;
import com.oxygenxml.positron.utilities.functions.parameters.ContentParams;
import java.net.URL;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCurrentDocumentFunctionExecutor
extends DocumentAccessFunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(GetCurrentDocumentFunctionExecutor.class);
    private GetCurrentDocumentContentFunctionSignature getDocumentFunctionDef = new GetCurrentDocumentContentFunctionSignature();

    @Override
    public Object execute(String toolId, Object arguments) {
        String toRet = null;
        DocumentContentInteractor documentContentExtractor = this.getDocumentContentExtractor();
        if (documentContentExtractor == null) {
            toRet = "No document is opened in the application main editor area.";
        } else {
            URL editorLocation = documentContentExtractor.getEditorLocation();
            FunctionsAndRAGHelper projectRAGHelper = FunctionsAndRAGHelperProvider.getProjectRAGHelper();
            try {
                if (editorLocation != null) {
                    projectRAGHelper.checkDocumentAccessPermissions(editorLocation.toExternalForm(), true, false);
                }
                toRet = documentContentExtractor.getEntireDocumentContent(true).getUsableContent();
                ContentParams params = (ContentParams)arguments;
                toRet = TextUtils.changeContentToFitLineRanges(params, toRet);
            }
            catch (AccessDeniedException e) {
                toRet = e.getMessage();
            }
            catch (BadLocationException e) {
                log.error((Throwable)e);
            }
            catch (OperationCancelledByAiIgnoreException e) {
                log.error((Throwable)e);
            }
        }
        return toRet;
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.getDocumentFunctionDef;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ONLY_LAST_CALL;
    }
}

