/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.aiignore.OperationCancelledByAiIgnoreException;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.tools.DocumentAccessDeniedException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.GetContentForDocumentURLFunctionSignature;
import com.oxygenxml.positron.utilities.functions.parameters.ContentParams;
import com.oxygenxml.positron.utilities.functions.parameters.DocumentParams;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;

public class GetContentForDocumentURLFunctionExecutor
implements FunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(GetContentForDocumentURLFunctionExecutor.class);
    private static final String ERROR_RESPONSE = "ERROR: Could not obtain content from URL location: ";
    static final String NO_URL_ERROR = "The 'docUrl' parameter is missing. Please provide a valid URL and try again to proceed.";
    private GetContentForDocumentURLFunctionSignature functionDef = new GetContentForDocumentURLFunctionSignature();

    @Override
    public Object execute(String toolId, Object arguments) {
        if (log.isDebugEnabled()) {
            log.debug("Retrieve doc content " + arguments);
        }
        Object toRet = NO_URL_ERROR;
        DocumentParams docIdArg = (DocumentParams)arguments;
        if (docIdArg != null) {
            String docLocation = docIdArg.docURL;
            if (log.isDebugEnabled()) {
                log.debug("Doc URL " + docLocation);
            }
            if (docLocation != null) {
                try {
                    URL docUrl = URLUtil.convertToURL((String)docLocation);
                    if (docUrl == null) {
                        throw new MalformedURLException("Could not convert to URL: " + URLUtil.filterPasswords((String)docLocation));
                    }
                    this.checkURLNotDirectoryPath(docUrl);
                    this.checkDocumentLocation(docUrl);
                    DocumentContentInteractor documentContentExtractor = this.getDocumentContentExtractor();
                    if (documentContentExtractor != null && URLUtil.getEditorLocationKey((URL)docUrl, (boolean)true).equals(URLUtil.getEditorLocationKey((URL)documentContentExtractor.getEditorLocation(), (boolean)true))) {
                        toRet = TextUtils.changeContentToFitLineRanges((ContentParams)docIdArg, documentContentExtractor.getEntireDocumentContent(true).getUsableContent());
                    } else {
                        URL targetURL = this.enrichURLWithConnectionData(docUrl);
                        toRet = FunctionsAndRAGHelperProvider.getProjectRAGHelper().getDocumentContent(targetURL.toExternalForm(), (ContentParams)docIdArg);
                    }
                }
                catch (OperationCancelledByAiIgnoreException | DocumentAccessDeniedException | IOException | BadLocationException e) {
                    toRet = ERROR_RESPONSE + e.getMessage();
                }
                if (log.isDebugEnabled()) {
                    log.debug("Expanded to " + (String)toRet);
                }
            }
        }
        return toRet;
    }

    protected DocumentContentInteractor getDocumentContentExtractor() {
        return null;
    }

    private void checkURLNotDirectoryPath(URL urlToWriteTo) throws DocumentAccessDeniedException {
        if (urlToWriteTo != null && urlToWriteTo.toExternalForm().endsWith("/") && !urlToWriteTo.toExternalForm().startsWith("http")) {
            DocumentAccessDeniedException cannotExecuteFunctionException = new DocumentAccessDeniedException("Invalid attempt to retrieve file content from an URL directory location: " + URLUtil.clearUserInfo((URL)urlToWriteTo));
            throw cannotExecuteFunctionException;
        }
    }

    protected void checkDocumentLocation(URL documentLocation) throws DocumentAccessDeniedException {
    }

    protected URL enrichURLWithConnectionData(URL url) {
        return url;
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ONLY_LAST_CALL;
    }
}

