/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface FunctionExecutor {
    public ChatFunctionSignature getFunctionSignature();

    default public Object executeWithSerializedArguments(String toolId, String serializedArguments) throws CannotExecuteFunctionException {
        Object toRet = null;
        try {
            if (serializedArguments != null && serializedArguments.isEmpty()) {
                serializedArguments = "{}";
            }
            Object deserializeArguments = this.getFunctionSignature().deserializeArguments(serializedArguments);
            toRet = this.execute(toolId, deserializeArguments);
        }
        catch (JsonProcessingException e) {
            Logger logger = LoggerFactory.getLogger(FunctionExecutor.class);
            String errorMsg = "Cannot deserialize function arguments: " + e.getMessage();
            logger.debug(errorMsg, (Throwable)e);
            toRet = errorMsg;
        }
        return toRet;
    }

    public Object execute(String var1, Object var2) throws CannotExecuteFunctionException;

    default public boolean requireUserConfirmation() {
        return false;
    }

    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy();
}

