/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.utilities.functions.parameters.DocumentReplacement;
import com.oxygenxml.positron.utilities.functions.parameters.EditDocumentProperties;
import com.oxygenxml.positron.utilities.functions.parameters.SaveDocumentProperties;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EditDocumentFunctionExecutorUtilities {
    private static String checkParamsValid(EditDocumentProperties params) {
        String errorMessage = null;
        if (params == null) {
            errorMessage = "No parameters specified.";
        } else if (params.url == null) {
            errorMessage = "No document URL specified.";
        }
        return errorMessage;
    }

    private static String checkReplacementsValid(EditDocumentProperties params) {
        String errorMessage = null;
        if (params.replacements == null || params.replacements.length == 0) {
            errorMessage = "No document replacements specified.";
        }
        return errorMessage;
    }

    private static SaveDocumentProperties createSaveProps(EditDocumentProperties params, Function<URL, String> docContentProvider, Function<String, URL> urlConverter) throws IOException, CannotExecuteFunctionException {
        URL docURL = urlConverter.apply(params.url);
        if (docURL == null) {
            throw new MalformedURLException("Could not convert to URL " + params.url);
        }
        String currentContent = docContentProvider.apply(docURL);
        if (currentContent == null) {
            throw new IOException("Could not obtain initial document content.");
        }
        String replaced = currentContent;
        StringBuilder replacementProblems = new StringBuilder();
        for (int i = 0; i < params.replacements.length; ++i) {
            try {
                DocumentReplacement replacement = params.replacements[i];
                replaced = EditDocumentFunctionExecutorUtilities.replaceMatch(params, replaced, replacement);
                continue;
            }
            catch (IOException ex) {
                replacementProblems.append(ex.getMessage()).append("\n");
            }
        }
        if (replacementProblems.length() > 0) {
            throw new IOException("Aborted editing the document. Cannot perform the following replacements:\n" + replacementProblems.toString());
        }
        SaveDocumentProperties saveProps = new SaveDocumentProperties();
        saveProps.content = replaced;
        saveProps.url = docURL.toString();
        saveProps.validate = true;
        return saveProps;
    }

    private static String replaceMatch(EditDocumentProperties params, String currentContent, DocumentReplacement replacement) throws IOException {
        if (replacement.old_string_value == null) {
            throw new IOException("No string to be replaced was specified");
        }
        if (replacement.new_string_value == null) {
            throw new IOException("No string to replace with was specified");
        }
        String replaced = currentContent;
        replaced = currentContent.contains(replacement.old_string_value) ? EditDocumentFunctionExecutorUtilities.replaceSimpleStringMatch(params, currentContent, replacement) : EditDocumentFunctionExecutorUtilities.replaceRegexpMatch(params, currentContent, replacement);
        return replaced;
    }

    private static String replaceRegexpMatch(EditDocumentProperties params, String currentContent, DocumentReplacement replacement) throws IOException {
        String replaced = null;
        String normalizedAndEscaped = EditDocumentFunctionExecutorUtilities.normalizeAndEscape(replacement.old_string_value);
        Pattern pattern = Pattern.compile(normalizedAndEscaped);
        Matcher matcher = pattern.matcher(currentContent);
        if (matcher.find()) {
            replaced = params.replace_all ? matcher.replaceAll(replacement.new_string_value) : matcher.replaceFirst(replacement.new_string_value);
        } else {
            throw new IOException("Could not locate string '" + replacement.old_string_value + "' to replace in content, please try again with a more precise string value, make sure all possible indentation spaces, tabs, new lines are properly specified.");
        }
        return replaced;
    }

    private static String replaceSimpleStringMatch(EditDocumentProperties params, String currentContent, DocumentReplacement replacement) {
        String replaced = null;
        replaced = params.replace_all ? currentContent.replace(replacement.old_string_value, replacement.new_string_value) : currentContent.replaceFirst(Pattern.quote(replacement.old_string_value), Matcher.quoteReplacement(replacement.new_string_value));
        return replaced;
    }

    private static String normalizeAndEscape(String input) {
        String normalized = input.replaceAll("\\s+", " ");
        String[] parts = normalized.split(" ");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (i > 0) {
                result.append("\\s+");
            }
            result.append(Pattern.quote(parts[i]));
        }
        return result.toString();
    }

    public static Object execute(String toolId, Object arguments, ToolExecutor superExecutor, Function<URL, String> docContentProvider, Function<String, URL> urlConverter) throws CannotExecuteFunctionException {
        Object toReturn;
        EditDocumentProperties props = (EditDocumentProperties)arguments;
        String checkParamsError = EditDocumentFunctionExecutorUtilities.checkParamsValid(props);
        if (checkParamsError != null) {
            toReturn = checkParamsError;
        } else if (props.content != null) {
            SaveDocumentProperties saveProps = new SaveDocumentProperties();
            saveProps.content = props.content;
            saveProps.url = props.url;
            saveProps.validate = true;
            toReturn = superExecutor.execute(toolId, saveProps);
        } else {
            String replacementError = EditDocumentFunctionExecutorUtilities.checkReplacementsValid(props);
            if (replacementError != null) {
                toReturn = replacementError;
            } else {
                try {
                    SaveDocumentProperties saveProps = EditDocumentFunctionExecutorUtilities.createSaveProps(props, docContentProvider, urlConverter);
                    toReturn = superExecutor.execute(toolId, saveProps);
                }
                catch (IOException e) {
                    toReturn = e.getMessage();
                }
            }
        }
        return toReturn;
    }

    public static interface ToolExecutor {
        public Object execute(String var1, Object var2) throws CannotExecuteFunctionException;
    }
}

