/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.tools;

import com.oxygenxml.positron.core.tools.CannotExecuteFunctionException;
import com.oxygenxml.positron.core.tools.FunctionExecutor;
import com.oxygenxml.positron.core.tools.thread.strategy.ThreadFunctionCallStrategy;
import com.oxygenxml.positron.utilities.functions.ChatFunctionSignature;
import com.oxygenxml.positron.utilities.functions.CopyMoveRenamePathFunctionSignature;
import com.oxygenxml.positron.utilities.functions.FileOperation;
import com.oxygenxml.positron.utilities.functions.FunctionsAndRAGHelperProvider;
import com.oxygenxml.positron.utilities.functions.parameters.CopyMoveRenameParams;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CopyMoveRenameFunctionExecutor
implements FunctionExecutor {
    private static final Logger log = LoggerFactory.getLogger(CopyMoveRenameFunctionExecutor.class);
    private CopyMoveRenamePathFunctionSignature functionDef = new CopyMoveRenamePathFunctionSignature();

    @Override
    public Object execute(String toolId, Object arguments) throws CannotExecuteFunctionException {
        CopyMoveRenameParams params;
        if (log.isDebugEnabled()) {
            log.debug("List files in directory: " + arguments);
        }
        if ((params = (CopyMoveRenameParams)arguments) != null && params.source_path != null && params.destination_path != null) {
            log.debug("Source path: {}", (Object)params.source_path);
            log.debug("Destination path : {}", (Object)params.destination_path);
            try {
                String result = FunctionsAndRAGHelperProvider.getProjectRAGHelper().copyMoveRename(params.source_path, params.destination_path, params.copy ? FileOperation.COPY : FileOperation.MOVE_OR_RENAME);
                log.debug("Copy, move or rename result: {} ", (Object)result);
                return result;
            }
            catch (IOException e) {
                log.debug((Throwable)e);
                throw new CannotExecuteFunctionException(e.getMessage(), true);
            }
        }
        if (params == null) {
            throw new CannotExecuteFunctionException("No tool parameters were provided", true);
        }
        if (params.source_path == null) {
            throw new CannotExecuteFunctionException("No source path was provided", true);
        }
        if (params.destination_path == null) {
            throw new CannotExecuteFunctionException("No destination path was provided", true);
        }
        return null;
    }

    @Override
    public ChatFunctionSignature getFunctionSignature() {
        return this.functionDef;
    }

    @Override
    public ThreadFunctionCallStrategy getFunctionCallsRequestThreadStrategy() {
        return ThreadFunctionCallStrategy.KEEP_ALL_CALLS;
    }
}

