/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.service;

import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.api.SSE;
import com.oxygenxml.positron.core.auth.requests.AccountInfoProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.service.PositronErrorsUtil;
import com.oxygenxml.positron.core.service.SSEFormatException;
import com.oxygenxml.positron.utilities.debug.LoggerUtil;
import io.reactivex.rxjava3.core.FlowableEmitter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketTimeoutException;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;
import ro.sync.basic.execution.StoppedByUserException;

public class ResponseBodyCallback
implements Callback<ResponseBody> {
    private static final Logger log = LoggerFactory.getLogger(ResponseBodyCallback.class);
    private FlowableEmitter<SSE> emitter;
    private AccountInfoProvider accountInfoProvider;

    public ResponseBodyCallback(FlowableEmitter<SSE> emitter, AccountInfoProvider accountInfoProvider) {
        this.emitter = emitter;
        this.accountInfoProvider = accountInfoProvider;
    }

    public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
        try {
            if (log.isDebugEnabled()) {
                log.debug("The response is successful: " + response.isSuccessful());
            }
            if (!response.isSuccessful()) {
                PositronErrorsUtil.throwExceptionForFailedRequest(response, this.accountInfoProvider);
            }
            this.processResponse(response);
            this.emitter.onComplete();
        }
        catch (StoppedByUserException e) {
            this.onFailure(call, e);
        }
        catch (CannotComputeCompletionDetailsException ex) {
            this.onFailure(call, ex);
        }
        catch (SocketTimeoutException e) {
            this.handleTimeout(call, e);
        }
        catch (SSEFormatException | IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.onFailure(call, new CannotComputeCompletionDetailsException(e.getMessage(), e));
        }
    }

    private void processResponse(Response<ResponseBody> response) throws IOException, SSEFormatException, StoppedByUserException {
        try (InputStream in = ((ResponseBody)response.body()).byteStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));){
            String line;
            SSE sse = null;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("data:")) {
                    String data = line.substring(5).trim();
                    sse = new SSE(data);
                    if (log.isDebugEnabled()) {
                        log.debug("SSE: " + LoggerUtil.filterMessagesFromRequestBody((String)sse.getData()));
                    }
                } else if (line.equals("") && sse != null) {
                    if (sse.isDone()) {
                        break;
                    }
                    this.emitter.onNext((Object)sse);
                    sse = null;
                } else {
                    log.error("Invalid sse format! " + line);
                    throw new SSEFormatException("Received content has an invalid SSE format.");
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new StoppedByUserException();
            }
        }
    }

    public void onFailure(Call<ResponseBody> call, Throwable t) {
        if (log.isDebugEnabled()) {
            log.debug((Object)t, t);
        }
        if (t instanceof SocketTimeoutException) {
            this.handleTimeout(call, (SocketTimeoutException)t);
        } else {
            this.emitter.onError(t);
        }
    }

    private void handleTimeout(Call<ResponseBody> call, SocketTimeoutException ex) {
        log.error(ex.getMessage(), (Throwable)ex);
        Translator translator = Translator.getInstance();
        String message = translator.getTranslation("Cannot_obtain_ai_response") + " " + translator.getTranslation("Please_try_again");
        this.onFailure(call, new CannotComputeCompletionDetailsException(message, ex, true));
    }
}

