/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.service;

import com.oxygenxml.positron.api.connector.dto.CompletionChunk;
import com.oxygenxml.positron.api.connector.dto.CompletionResponse;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.core.AICompletionDetailsProvider;
import com.oxygenxml.positron.core.ActionInterruptedByEditorDeselectionException;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.InappropriateCompletionException;
import com.oxygenxml.positron.core.IncompleteCompletionException;
import com.oxygenxml.positron.core.RefusalCompletionException;
import com.oxygenxml.positron.core.actions.ActionInteractor;
import com.oxygenxml.positron.core.actions.MessagePresenter;
import com.oxygenxml.positron.core.api.CompletionResponseUtil;
import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.service.PositronErrorsUtil;
import com.oxygenxml.positron.core.tools.RAGDisabledException;
import com.oxygenxml.positron.utilities.error.ApiErrorCodes;
import io.reactivex.rxjava3.core.Flowable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.execution.StoppedByUserException;

public class PositronServiceUtil {
    private static final Logger log = LoggerFactory.getLogger(PositronServiceUtil.class);

    private PositronServiceUtil() {
    }

    public static String handleStreamResult(String aiCompletion, String responseModel, List<Throwable> exceptions, AICompletionDetailsProvider aiCompletionProvider, ActionInteractor actionInteractor, ChatInteractor chatInteractor, MessagePresenter statusPresenter) {
        if (PositronErrorsUtil.wasCancelledByAiIgnore(exceptions)) {
            String msg = Translator.getInstance().getTranslation("Cannot_execute_action_Document_AI_ignored");
            chatInteractor.showAIAssistantChunkMessage(msg);
            chatInteractor.storeAIAssistantMessage(actionInteractor, responseModel, new Message(RoleType.ASSISTANT, (MessageContent)new MessageTextContent(msg)), true);
            return msg;
        }
        String resultedCompletion = aiCompletion;
        if (PositronErrorsUtil.hasInappropriateCompletion(exceptions) || PositronErrorsUtil.hasRefusalCompletion(exceptions)) {
            chatInteractor.clearCurrentResponse();
            resultedCompletion = "";
        } else {
            boolean isIncomplete = PositronErrorsUtil.hasStreamingIncomplete(exceptions);
            chatInteractor.storeAIAssistantMessage(actionInteractor, responseModel, new Message(RoleType.ASSISTANT, (MessageContent)new MessageTextContent(resultedCompletion)), isIncomplete);
            if (isIncomplete) {
                resultedCompletion = "";
            }
        }
        if (!exceptions.isEmpty()) {
            String error;
            resultedCompletion = "";
            Throwable exception = exceptions.get(0);
            if (log.isDebugEnabled()) {
                log.debug(exception.getMessage(), exception);
            }
            if (!(error = PositronServiceUtil.computeErrorMessage(exception, aiCompletion, aiCompletionProvider)).isBlank()) {
                boolean isCancelled = PositronErrorsUtil.hasStreamingCancelled(exceptions);
                Map<String, String> errorLinks = aiCompletionProvider.computeErrorLink(exception);
                chatInteractor.showMessageForNotSuccessfulAction(error, isCancelled, PositronServiceUtil.shouldAllowRetry(exceptions), false, errorLinks);
                if (!(statusPresenter == null || isCancelled || exception.getCause() instanceof RAGDisabledException || exception instanceof ActionInterruptedByEditorDeselectionException)) {
                    statusPresenter.showErrorMessageDialog(error, errorLinks);
                }
            }
        }
        return resultedCompletion;
    }

    public static String computeErrorMessage(Throwable exception, String aiCompletion, AICompletionDetailsProvider aiCompletionProvider) {
        String error = aiCompletionProvider.getHumanReadableErrorMessageToPresent(exception);
        if (error.isBlank() && aiCompletion.isEmpty() && !PositronErrorsUtil.isStoppedByUser(exception)) {
            StringBuilder builder = new StringBuilder();
            builder.append(Translator.getInstance().getTranslation("Something_went_wrong"));
            builder.append(" ").append(Translator.getInstance().getTranslation("Please_try_again"));
            error = builder.toString();
        }
        return error;
    }

    public static boolean shouldAllowRetry(List<Throwable> exceptions) {
        boolean isAllowToRetry = false;
        for (Throwable e : exceptions) {
            if (!(e instanceof CannotComputeCompletionDetailsException) || !((CannotComputeCompletionDetailsException)e).isAbleToRetry()) continue;
            isAllowToRetry = true;
        }
        return isAllowToRetry;
    }

    public static String extractErrorMessage(String aiCompletion, List<Throwable> exceptions) {
        StringBuilder errorMessage = new StringBuilder();
        boolean hasStoppedByUserException = false;
        for (int i = 0; i < exceptions.size(); ++i) {
            Throwable e = exceptions.get(i);
            if (i > 0) {
                errorMessage.append(" ");
            }
            if (e instanceof InterruptedException) {
                log.debug((Object)e, e);
                continue;
            }
            if (e instanceof StoppedByUserException) {
                log.debug((Object)e, e);
                hasStoppedByUserException = true;
                continue;
            }
            if (e instanceof CannotComputeCompletionDetailsException) {
                log.debug((Object)e, e);
                errorMessage.append(e.getMessage());
                continue;
            }
            if (e instanceof InappropriateCompletionException) {
                errorMessage.append(Translator.getInstance().getTranslation("Resulted_content_inappropriate"));
                continue;
            }
            if (e instanceof RefusalCompletionException) {
                errorMessage.append(Translator.getInstance().getTranslation("Resulted_content_refused"));
                continue;
            }
            if (e instanceof IncompleteCompletionException) {
                errorMessage.append(Translator.getInstance().getTranslation("Incomplete_response"));
                continue;
            }
            log.error((Object)e, e);
            errorMessage.append(e.getMessage());
        }
        if (errorMessage.length() == 0 && aiCompletion.isEmpty() && !hasStoppedByUserException) {
            errorMessage.append(Translator.getInstance().getTranslation("Something_went_wrong"));
            errorMessage.append(" ").append(Translator.getInstance().getTranslation("Please_try_again"));
        }
        return errorMessage.toString();
    }

    public static Set<String> extractPositronErrorCodes(List<Throwable> exceptions) {
        HashSet<String> errorCodes = new HashSet<String>();
        for (int i = 0; i < exceptions.size(); ++i) {
            String positronErrorCode;
            Throwable e = exceptions.get(i);
            if (!(e instanceof CannotComputeCompletionDetailsException) || (positronErrorCode = ((CannotComputeCompletionDetailsException)e).getPositronErrorCode()) == null) continue;
            errorCodes.add(positronErrorCode);
        }
        return errorCodes;
    }

    public static Map<String, String> computeErrorLinks(Set<String> errorCodes, String serverUrl) {
        HashMap<String, String> links = new HashMap<String, String>();
        if (errorCodes.contains(ApiErrorCodes.CREDITS_LIMIT_EXCEEDED.getCode()) || errorCodes.contains(ApiErrorCodes.NOT_ENOUGH_CREDITS.getCode()) || errorCodes.contains(ApiErrorCodes.PLAN_EXPIRED.getCode())) {
            links.put(Translator.getInstance().getTranslation("Manage_subscription") + "...", serverUrl + "/subscriptions");
        }
        return links;
    }

    public static boolean isBlockerCompletionException(CannotComputeCompletionDetailsException exception) {
        return !exception.isAbleToRetry() && (exception.getPositronErrorCode() == null || ApiErrorCodes.BAD_REQUEST.getCode().equals(exception.getPositronErrorCode()) || ApiErrorCodes.CREDITS_LIMIT_EXCEEDED.getCode().equals(exception.getPositronErrorCode()) || ApiErrorCodes.PLAN_EXPIRED.getCode().equals(exception.getPositronErrorCode()));
    }

    public static Flowable<? extends CompletionChunk> handleFinalFlags(Flowable<? extends CompletionChunk> streamChunks) {
        return streamChunks.map(chunk -> {
            if (CompletionResponseUtil.isFlaggedByModeration((CompletionResponse)chunk)) {
                throw new InappropriateCompletionException();
            }
            if (CompletionResponseUtil.isRefusalCompletion((CompletionResponse)chunk)) {
                throw new RefusalCompletionException();
            }
            if (CompletionResponseUtil.isIncompleteCompletion((CompletionResponse)chunk)) {
                throw new IncompleteCompletionException();
            }
            return chunk;
        });
    }
}

