/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.responses.handler;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.responses.handler.IResponseFormatHandler;
import com.oxygenxml.positron.core.responses.handler.ResponseFormatHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseParser {
    private static final Logger log = LoggerFactory.getLogger(ResponseParser.class);
    private ChatInteractor chatInteractor;
    private PipedOutputStream outputStream;
    private PipedInputStream inputStream;
    private JsonParser parser;
    private Thread responseConsumerThread;
    private IResponseFormatHandler responseFormatHandler;

    public ResponseParser(boolean shouldReceiveStructuredResponse, ChatInteractor chatInteractor) {
        this.chatInteractor = chatInteractor;
        this.responseFormatHandler = new ResponseFormatHandler(chatInteractor);
        if (shouldReceiveStructuredResponse) {
            this.outputStream = new PipedOutputStream();
            try {
                this.inputStream = new PipedInputStream(this.outputStream);
                this.responseConsumerThread = new Thread(this::consumeResponse, "ResponseFormatHandlerThread");
                this.responseConsumerThread.start();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void addNewChunk(String chunk) {
        if (this.outputStream != null) {
            try {
                this.outputStream.write(chunk.getBytes(StandardCharsets.UTF_8));
                this.outputStream.flush();
            }
            catch (IOException e) {
                try {
                    this.inputStream.close();
                    this.inputStream = null;
                    this.outputStream = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.chatInteractor.showAIAssistantChunkMessage(chunk);
            }
        } else {
            this.chatInteractor.showAIAssistantChunkMessage(chunk);
        }
    }

    private void consumeResponse() {
        try {
            this.parser = new JsonFactory().createParser((InputStream)this.inputStream);
            ResponseParser.handleJsonObject(this.parser, this.responseFormatHandler);
        }
        catch (IOException | UnsupportedOperationException e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            this.closeParser();
        }
    }

    public void completionEnd() {
        if (this.responseConsumerThread != null && this.responseConsumerThread.isAlive()) {
            this.responseConsumerThread.interrupt();
        }
        this.closeParser();
    }

    private void closeParser() {
        try {
            if (this.parser != null) {
                this.parser.close();
            } else if (this.inputStream != null) {
                this.inputStream.close();
            } else if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    Thread getResponseConsumerThread() {
        return this.responseConsumerThread;
    }

    private static void handleJsonObject(JsonParser parser, IResponseFormatHandler handler) throws IOException {
        while (parser.nextToken() != JsonToken.END_OBJECT && !Thread.currentThread().isInterrupted()) {
            ResponseParser.handleJsonField(parser, handler);
        }
    }

    private static void handleJsonField(JsonParser parser, IResponseFormatHandler handler) throws IOException {
        String fieldname = parser.getCurrentName();
        if (fieldname != null) {
            JsonToken nextToken = parser.nextToken();
            handler.handleFieldStarted(fieldname);
            if (nextToken == JsonToken.START_OBJECT) {
                ResponseParser.handleJsonObject(parser, handler);
            } else if (nextToken == JsonToken.START_ARRAY) {
                ResponseParser.handleJsonArray(parser, handler);
            } else {
                handler.handleFieldContentChunk(String.valueOf(parser.getText()));
            }
            handler.handleFieldEnded(fieldname);
        }
    }

    private static void handleJsonArray(JsonParser parser, IResponseFormatHandler handler) throws IOException {
        while (parser.nextToken() != JsonToken.END_ARRAY && !Thread.currentThread().isInterrupted()) {
            if (parser.getCurrentToken() == JsonToken.START_OBJECT) {
                ResponseParser.handleJsonObject(parser, handler);
                continue;
            }
            if (parser.getText() == null) continue;
            handler.handleFieldContentChunk(String.valueOf(parser.getText()));
            ResponseParser.handleJsonField(parser, handler);
        }
    }

    public void setResponseFormatHandler(IResponseFormatHandler responseFormatHandler) {
        this.responseFormatHandler = responseFormatHandler;
    }
}

