/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.progress;

import com.oxygenxml.positron.core.progress.TaskListener;
import java.util.Objects;
import javax.swing.SwingWorker;

public class ProgressWorker
extends SwingWorker<Void, Void> {
    private TaskListener taskListener;
    private Runnable runOnThread;
    private Runnable runAfterProgressIsDone;

    public ProgressWorker(Runnable toExecuteOnThread, Runnable runAfterProgressIsDone, TaskListener taskListener) {
        this.runOnThread = Objects.requireNonNull(toExecuteOnThread);
        this.runAfterProgressIsDone = Objects.requireNonNull(runAfterProgressIsDone);
        this.taskListener = Objects.requireNonNull(taskListener);
    }

    @Override
    protected Void doInBackground() throws Exception {
        try {
            this.taskListener.taskStarted();
            this.runOnThread.run();
        }
        finally {
            this.taskListener.taskFinished();
        }
        return null;
    }

    public void stopProcessing() {
        try {
            this.cancel(true);
        }
        finally {
            this.taskListener.taskCanceled();
        }
    }

    @Override
    protected void done() {
        this.runAfterProgressIsDone.run();
    }
}

