/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.progress;

import com.oxygenxml.positron.core.progress.OperationProgressPresenter;
import com.oxygenxml.positron.core.progress.ProgressWorker;
import com.oxygenxml.positron.core.progress.TaskListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ProgressTracker {
    private ProgressWorker worker = null;
    private OperationProgressPresenter statusPanel;
    final ActionListener cancelListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            ProgressTracker.this.cancelProgress(true);
        }
    };
    private boolean inProgress;
    private Boolean isCancelledByUser = null;

    public ProgressTracker(OperationProgressPresenter statusPanel) {
        this.statusPanel = statusPanel;
    }

    public void cancelProgress(boolean byUser) {
        this.isCancelledByUser = byUser;
        this.worker.stopProcessing();
    }

    public void startTracking(Runnable runOnThread, Runnable runAfterProgressIsDone) {
        this.worker = new ProgressWorker(runOnThread, runAfterProgressIsDone, new TaskListener(){

            @Override
            public void taskStarted() {
                ProgressTracker.this.inProgress = true;
                ProgressTracker.this.isCancelledByUser = null;
                ProgressTracker.this.statusPanel.taskStarted();
                ProgressTracker.this.statusPanel.addCancelListener(ProgressTracker.this.cancelListener);
            }

            @Override
            public void taskFinished() {
                ProgressTracker.this.statusPanel.removeCancelListener(ProgressTracker.this.cancelListener);
                ProgressTracker.this.statusPanel.taskFinished();
                ProgressTracker.this.inProgress = false;
            }

            @Override
            public void taskCanceled() {
                ProgressTracker.this.statusPanel.removeCancelListener(ProgressTracker.this.cancelListener);
                ProgressTracker.this.statusPanel.taskCanceled();
                ProgressTracker.this.inProgress = false;
            }
        });
        this.worker.execute();
    }

    public boolean isCanceled() {
        return this.statusPanel.isCanceled();
    }

    public Boolean isCancelledByUser() {
        return this.isCancelledByUser;
    }

    public boolean isInProgress() {
        return this.inProgress;
    }

    public boolean isDone() {
        return this.worker.isDone();
    }
}

