/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.interactions.textpage;

import com.oxygenxml.positron.core.interactions.textpage.NodeOffset;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.xml.WSXMLTextEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.xml.WSXMLTextNodeRange;
import ro.sync.exml.workspace.api.editor.page.text.xml.XPathException;

public class TextXPathEffector {
    private WSTextEditorPage textEditorPage;

    public List<NodeOffset> findNodeOffsetsByXPath(String xpathExpression) throws BadLocationException, XPathException {
        ArrayList<NodeOffset> offsets = new ArrayList<NodeOffset>();
        if (this.textEditorPage instanceof WSXMLTextEditorPage) {
            WSXMLTextNodeRange[] findElementsByXPath;
            WSXMLTextEditorPage wsxmlTextEditorPage = (WSXMLTextEditorPage)this.textEditorPage;
            for (WSXMLTextNodeRange range : findElementsByXPath = wsxmlTextEditorPage.findElementsByXPath(xpathExpression)) {
                int start = wsxmlTextEditorPage.getOffsetOfLineStart(range.getStartLine()) + range.getStartColumn() - 1;
                int end = wsxmlTextEditorPage.getOffsetOfLineStart(range.getEndLine()) + range.getEndColumn() - 1;
                offsets.add(new NodeOffset(start, end));
            }
        }
        return offsets;
    }

    public Object[] evaluateXPath(String xpathExpression) throws BadLocationException, XPathException {
        if (this.textEditorPage instanceof WSXMLTextEditorPage) {
            WSXMLTextEditorPage wsxmlTextEditorPage = (WSXMLTextEditorPage)this.textEditorPage;
            return wsxmlTextEditorPage.evaluateXPath(xpathExpression);
        }
        return new Object[0];
    }

    public TextXPathEffector(WSTextEditorPage textEditorPage) {
        this.textEditorPage = textEditorPage;
    }
}

