/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.interactions.textpage;

import com.oxygenxml.positron.core.interactions.ContextInfo;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.interactions.textpage.NodeOffset;
import com.oxygenxml.positron.core.interactions.textpage.TextPageHighlighter;
import com.oxygenxml.positron.core.interactions.textpage.TextXPathEffector;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.json.InputContext;
import com.oxygenxml.tokenmarker.xml.XMLLexerTokenMarker;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.xml.XPathException;
import ro.sync.syntaxhighlight.marker.Token;

public class PrefixExtractorForTextPage
implements DocumentContentInteractor {
    private static final Logger logger = LoggerFactory.getLogger((String)PrefixExtractorForTextPage.class.getName());
    protected Document document;
    private JTextComponent textComponent;
    private Reader contentReader;
    private URL editorLocation;
    private TextXPathEffector xPathEffector;
    private TextPageHighlighter textHighlighter;
    private WSTextEditorPage textEditorPage;

    public PrefixExtractorForTextPage(WSTextEditorPage textEditorPage, TextXPathEffector xPathEffector) {
        this.textEditorPage = textEditorPage;
        this.document = textEditorPage.getDocument();
        this.textComponent = (JTextComponent)textEditorPage.getTextComponent();
        this.contentReader = textEditorPage.getParentEditor().createContentReader();
        this.editorLocation = textEditorPage.getParentEditor().getEditorLocation();
        this.xPathEffector = xPathEffector;
        this.textHighlighter = new TextPageHighlighter(this.textComponent);
    }

    @Override
    public String computeUserInputFromDocument(int offset, int maxNumberOfChars) throws BadLocationException {
        String text = this.getTextBeforeCaret(offset, maxNumberOfChars);
        return this.getOnlyTextTokens(text);
    }

    private String getTextBeforeCaret(int offset, int maxNumberOfChars) throws BadLocationException {
        int startOffset = offset - maxNumberOfChars;
        if (startOffset < 0) {
            startOffset = 0;
        }
        String text = this.document.getText(startOffset, offset - startOffset);
        logger.debug("Raw text {}", (Object)text);
        int newlineIndex = text.indexOf(10);
        if (newlineIndex != -1) {
            text = text.substring(newlineIndex + 1);
        }
        logger.debug("After first newline {}", (Object)text);
        return text;
    }

    private String getOnlyTextTokens(String text) {
        StringBuilder sb = new StringBuilder();
        XMLLexerTokenMarker tm = new XMLLexerTokenMarker();
        tm.insertLines(0, 1);
        Token token = tm.markTokens((CharSequence)text, 0);
        boolean afterSpace = false;
        while (token != null && token.id != 127) {
            if (token.id == 0) {
                sb.append(text.substring(token.offsetInLine, token.offsetInLine + token.length));
                afterSpace = Character.isWhitespace(sb.charAt(sb.length() - 1));
            } else if (!afterSpace) {
                sb.append(' ');
                afterSpace = true;
            }
            token = token.next;
        }
        return sb.toString();
    }

    private String extractXMLCommentFromCaret(String text) {
        String textFromContext = null;
        XMLLexerTokenMarker tm = new XMLLexerTokenMarker();
        tm.insertLines(0, 1);
        Token token = tm.markTokens((CharSequence)text, 0);
        Token commentContentToken = null;
        Token lastToken = token;
        while (token != null && token.id != 127) {
            if (lastToken.id == 1 && token.id == 1 && token.next != null && token.next.id == 1) {
                commentContentToken = token;
            } else if (commentContentToken != null && token.id != 0 && token.id != 1 && token.id != 127) {
                commentContentToken = null;
            }
            lastToken = token;
            token = token.next;
        }
        if (commentContentToken != null) {
            textFromContext = text.substring(commentContentToken.offsetInLine, commentContentToken.offsetInLine + commentContentToken.length).trim();
        }
        return textFromContext;
    }

    @Override
    public String computePromptTextFromCaret(int offset) throws BadLocationException {
        String text = this.getTextBeforeCaret(offset, 6000);
        return this.extractXMLCommentFromCaret(text);
    }

    @Override
    public ContextInfo getCurrentContextInfo(boolean shouldContainMarkup, InputContext inputContext, boolean updateSelectionIfNeeded) throws BadLocationException {
        int selStart = this.textComponent.getSelectionStart();
        int selEnd = this.textComponent.getSelectionEnd();
        if (inputContext == InputContext.DOCUMENT || inputContext == InputContext.AUTO_SELECTION_DOCUMENT && selStart == selEnd) {
            selStart = 0;
            selEnd = this.textComponent.getDocument().getLength();
        }
        try {
            return new ContextInfo(this.textComponent.getDocument().getText(selStart, selEnd - selStart), selStart, selEnd);
        }
        catch (BadLocationException e) {
            logger.error((Object)e, (Throwable)e);
            return new ContextInfo("", selStart, selEnd);
        }
    }

    @Override
    public ContextInfo getCurrentNodeContent(boolean shouldContainMarkup) {
        try {
            List<NodeOffset> nodeOffsets = this.xPathEffector.findNodeOffsetsByXPath("self::*[1]");
            if (!nodeOffsets.isEmpty()) {
                int start = nodeOffsets.get(0).getStart();
                int end = nodeOffsets.get(0).getEnd();
                String text = this.document.getText(start, end - start);
                this.textHighlighter.addHighlight(start, end);
                return new ContextInfo(text, start, end);
            }
        }
        catch (BadLocationException | XPathException e) {
            logger.debug("Cannot determine current element", e);
        }
        return null;
    }

    @Override
    public void cleanUp() {
        this.textHighlighter.cleanUp();
    }

    @Override
    public String getContentAroundCaret(int maxNumberOfChars) throws BadLocationException {
        return TextUtils.getContentAroundCaretInternal(this.document, this.getCaretOffset(), maxNumberOfChars, false);
    }

    @Override
    public String extractContextWithCaretMarker(int maxNumberOfChars) throws BadLocationException {
        return TextUtils.getContentAroundCaretInternal(this.document, this.getCaretOffset(), maxNumberOfChars, true);
    }

    @Override
    public ContextInfo getEntireDocumentContent(boolean shouldContainMarkup) throws BadLocationException {
        String text;
        try {
            text = IOUtil.read((Reader)this.contentReader).toString();
        }
        catch (IOException e) {
            text = this.textComponent.getDocument().getText(0, this.textComponent.getDocument().getLength());
        }
        if (!shouldContainMarkup) {
            text = TextUtils.removeMarkup(text);
        }
        text = text.trim();
        return new ContextInfo(text, 0, this.textComponent.getDocument().getLength());
    }

    @Override
    public int getCaretOffset() {
        return this.textComponent.getSelectionEnd();
    }

    @Override
    public boolean hasSelection() {
        return this.textComponent.getSelectionStart() != this.textComponent.getSelectionEnd();
    }

    @Override
    public URL getEditorLocation() {
        return this.editorLocation;
    }

    @Override
    public void prepareSelectionForReplaceAction(InputContext inputContext) {
        if (!this.hasSelection()) {
            if (inputContext == InputContext.SELECTION_NODE_DOCUMENT || inputContext == InputContext.NODE) {
                ContextInfo currentNode = this.getCurrentNodeContent(true);
                if (currentNode != null) {
                    this.textComponent.setSelectionStart(currentNode.getStartOffset());
                    this.textComponent.setSelectionEnd(currentNode.getEndOffset());
                } else if (inputContext == InputContext.SELECTION_NODE_DOCUMENT) {
                    this.textComponent.setSelectionStart(0);
                    this.textComponent.setSelectionEnd(this.textComponent.getDocument().getLength());
                }
            } else if (inputContext == InputContext.AUTO_SELECTION_DOCUMENT || inputContext == InputContext.DOCUMENT) {
                this.textComponent.setSelectionStart(0);
                this.textComponent.setSelectionEnd(this.textComponent.getDocument().getLength());
            }
        }
    }

    @Override
    public void reloadContent(String content, boolean shouldMarkAsClean) throws IOException {
        this.textComponent.setText(content);
        if (shouldMarkAsClean) {
            this.textEditorPage.getParentEditor().setModified(false);
        }
    }

    @Override
    public boolean isConcurrentEditingEnabled() {
        return false;
    }
}

