/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.interactions.textpage;

import com.oxygenxml.positron.core.interactions.textpage.NodeOffset;
import com.oxygenxml.positron.core.interactions.textpage.TextXPathEffector;
import java.util.List;
import javax.swing.text.BadLocationException;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.xml.XPathException;

public class NodeDetectorForTextPage {
    private final WSTextEditorPage textEditorPage;
    private final int targetStart;
    private final int targetEnd;

    public NodeOffset findFirstNodeThatFullyContainsTargetOffsets() throws BadLocationException, XPathException {
        TextXPathEffector textXPathEffector = new TextXPathEffector(this.textEditorPage);
        List<NodeOffset> offsets = textXPathEffector.findNodeOffsetsByXPath("//*");
        NodeOffset bestMatch = null;
        int minDistance = Integer.MAX_VALUE;
        for (NodeOffset offset : offsets) {
            int distance;
            if (offset.getEnd() < this.targetStart || offset.getStart() > this.targetEnd || (distance = Math.abs(offset.getStart() - this.targetStart) + Math.abs(offset.getEnd() - this.targetEnd)) >= minDistance) continue;
            minDistance = distance;
            bestMatch = offset;
        }
        return bestMatch;
    }

    public NodeOffset findFirstParent() throws BadLocationException, XPathException {
        TextXPathEffector textXPathEffector = new TextXPathEffector(this.textEditorPage);
        List<NodeOffset> offsets = textXPathEffector.findNodeOffsetsByXPath("//*");
        NodeOffset bestParent = null;
        int smallestSpan = Integer.MAX_VALUE;
        for (NodeOffset offset : offsets) {
            int span;
            boolean strictlyContains = offset.getStart() < this.targetStart && offset.getEnd() > this.targetEnd;
            if (!strictlyContains || (span = offset.getEnd() - offset.getStart()) >= smallestSpan) continue;
            smallestSpan = span;
            bestParent = offset;
        }
        return bestParent;
    }

    public NodeDetectorForTextPage(WSTextEditorPage textEditorPage, int targetStart, int targetEnd) {
        this.textEditorPage = textEditorPage;
        this.targetStart = targetStart;
        this.targetEnd = targetEnd;
    }
}

