/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.interactions;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.ecss.extensions.api.AuthorDocumentType;

public class MarkupPreprocessor {
    private static final Logger logger = LoggerFactory.getLogger(MarkupPreprocessor.class);
    private static final String DOCTYPE_INTERNAL_SUBSET_MATCHER_STRING = "<!DOCTYPE(.*?)\\[(.*?)\\](\\s*)>";
    private static final String DOCTYPE_MATCHER_STRING = "<!DOCTYPE(.*?)>";
    private static final String XML_MODEL_MATCHER_STRING = "<\\?xml-model(.*?)\\?>";
    private static final String XML_ENCODING_MATCHER_STRING = "<\\?xml (.*?)\\?>";
    private static final Pattern ROOT_START_PATTERN = Pattern.compile("<([\\p{L}_:][\\p{L}\\p{N}\\p{M}_.:\\-]*)[\\s>/]");
    private static final Pattern OUTSIDE_ROOT_PIS_COMMENTS_PATTERN = Pattern.compile("(<!--[\\s\\S]*?-->)|(<\\?[\\s\\S]*?\\?>)");

    private MarkupPreprocessor() {
    }

    public static PreprocessedTextInfo preprocessText(String text, boolean removeXMLCommentsAndProcessingInstructionsBeforeAndAfterRoot) {
        PreprocessedTextInfo ti = new PreprocessedTextInfo();
        text = text.replace("& ", "&amp; ");
        text = MarkupPreprocessor.removeXMLEncoding(text);
        text = MarkupPreprocessor.extractDOCTYPE(text, ti);
        text = MarkupPreprocessor.extractXMLModel(text, ti);
        if (removeXMLCommentsAndProcessingInstructionsBeforeAndAfterRoot) {
            text = MarkupPreprocessor.removeXMLCommentsAndProcessingInstructionsBeforeAndAfterRoot(text);
        }
        ti.processedText = text;
        return ti;
    }

    private static String removeXMLCommentsAndProcessingInstructionsBeforeAndAfterRoot(String text) {
        Matcher startMatcher = ROOT_START_PATTERN.matcher(text);
        if (!startMatcher.find()) {
            return text;
        }
        String rootName = startMatcher.group(1);
        int rootStartIndex = startMatcher.start();
        int rootEndAfterIndex = -1;
        Matcher endTagMatcher = Pattern.compile("</" + Pattern.quote(rootName) + "\\s*>").matcher(text);
        while (endTagMatcher.find()) {
            rootEndAfterIndex = endTagMatcher.end();
        }
        if (rootEndAfterIndex == -1) {
            int startTagEnd = text.indexOf(62, rootStartIndex);
            if (startTagEnd != -1 && startTagEnd > rootStartIndex && text.charAt(startTagEnd - 1) == '/') {
                rootEndAfterIndex = startTagEnd + 1;
            } else {
                return text;
            }
        }
        String prefix = text.substring(0, rootStartIndex);
        String cleanedPrefix = OUTSIDE_ROOT_PIS_COMMENTS_PATTERN.matcher(prefix).replaceAll("");
        String rootAndMiddle = text.substring(rootStartIndex, rootEndAfterIndex);
        String suffix = text.substring(rootEndAfterIndex);
        String cleanedSuffix = OUTSIDE_ROOT_PIS_COMMENTS_PATTERN.matcher(suffix).replaceAll("");
        return cleanedPrefix + rootAndMiddle + cleanedSuffix;
    }

    private static String extractXMLModel(String text, PreprocessedTextInfo ti) {
        if (text.contains("<?xml-model")) {
            Matcher matcher = Pattern.compile(XML_MODEL_MATCHER_STRING).matcher(text);
            StringBuilder sb = new StringBuilder();
            while (matcher.find()) {
                sb.append(matcher.group());
            }
            text = matcher.replaceAll("");
            text = text.trim();
            ti.insertBeforeRoot = sb.toString();
        }
        return text;
    }

    public static String extractDOCTYPE(String text, PreprocessedTextInfo ti) {
        if (text.contains("<!DOCTYPE")) {
            String doctype = null;
            Matcher matcher = Pattern.compile(DOCTYPE_INTERNAL_SUBSET_MATCHER_STRING, 32).matcher(text);
            if (matcher.find()) {
                doctype = matcher.group();
                text = matcher.replaceAll("");
                text = text.trim();
            } else {
                matcher = Pattern.compile(DOCTYPE_MATCHER_STRING, 32).matcher(text);
                if (matcher.find()) {
                    doctype = matcher.group();
                    text = matcher.replaceAll("");
                    text = text.trim();
                }
            }
            if (doctype != null && !doctype.isEmpty()) {
                ti.doctype = MarkupPreprocessor.parseDoctype(doctype);
            }
        }
        return text;
    }

    private static String removeXMLEncoding(String text) {
        if (text.contains("<?xml")) {
            text = text.replaceAll(XML_ENCODING_MATCHER_STRING, "");
            text = text.trim();
        }
        return text;
    }

    private static AuthorDocumentType parseDoctype(String doctype) {
        AuthorDocumentType dt;
        block4: {
            dt = null;
            String name = null;
            try {
                StringTokenizer st = new StringTokenizer(doctype);
                st.nextToken();
                name = st.nextToken();
                String systemID = null;
                String publicId = null;
                boolean hasPublicId = "PUBLIC".equals(st.nextToken());
                if (hasPublicId) {
                    st.nextToken("\"'");
                    publicId = st.nextToken("\"'");
                    st.nextToken("\"'");
                    systemID = st.nextToken("\"'");
                } else {
                    st.nextToken("\"'");
                    systemID = st.nextToken("\"'");
                }
                dt = new AuthorDocumentType(name, systemID, publicId, doctype);
            }
            catch (NoSuchElementException ex) {
                if (!logger.isDebugEnabled()) break block4;
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
        }
        return dt;
    }

    public static class PreprocessedTextInfo {
        public String processedText;
        public String insertBeforeRoot;
        public AuthorDocumentType doctype;
    }
}

