/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.interactions;

import com.oxygenxml.positron.core.interactions.BaseDocumentDetailsProvider;
import com.oxygenxml.positron.core.interactions.ContentInserter;
import com.oxygenxml.positron.core.interactions.MarkupPreprocessor;
import com.oxygenxml.positron.core.interactions.ReadOnlyController;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.AuthorSelectionAndCaretModelUtil;
import com.oxygenxml.positron.core.util.SelectionUtil;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.json.InsertMode;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.undo.CannotUndoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;
import ro.sync.basic.xml.BasicXmlUtil;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSelectionModel;
import ro.sync.ecss.extensions.api.highlights.AuthorHighlighter;
import ro.sync.ecss.extensions.api.highlights.ColorHighlightPainter;
import ro.sync.ecss.extensions.api.highlights.Highlight;
import ro.sync.ecss.extensions.api.highlights.HighlightPainter;
import ro.sync.ecss.extensions.api.node.AuthorDocument;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.node.AuthorParentNode;
import ro.sync.ecss.extensions.api.schemaaware.SchemaAwareHandlerResult;
import ro.sync.exml.view.graphics.Color;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.documenttype.DocumentTypeInformation;
import ro.sync.exml.workspace.api.editor.page.WSTextBasedEditorPage;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;

public abstract class DefaultContentInserterForAuthorPage
extends BaseDocumentDetailsProvider
implements ContentInserter {
    private static final Logger logger = LoggerFactory.getLogger(DefaultContentInserterForAuthorPage.class);
    private static final String DITA_FRAMEWORK_NAME_PART = "DITA";
    private static final String XML_MODEL_PI_TARGET = "xml-model";
    private final AuthorDocumentController controller;
    private AuthorSelectionModel selectionModel;
    private Consumer<String> errorConsumer;
    private String contentType;
    private ReadOnlyController readOnlyController;
    private AuthorHighlighter highlighter;
    private Highlight insertionHighlight;
    protected WSAuthorEditorPage authorPage;
    private DocumentTypeInformation documentTypeInfo;
    private Map<String, String> highlightsMap = null;

    public DefaultContentInserterForAuthorPage(AuthorDocumentController controller, WSAuthorEditorPage authorEditorPage, Consumer<String> errorConsumer, ReadOnlyController readOnlyController) {
        this.authorPage = authorEditorPage;
        this.controller = controller;
        WSEditor parentEditor = this.authorPage.getParentEditor();
        this.documentTypeInfo = parentEditor.getDocumentTypeInformation();
        this.contentType = parentEditor.getContentType();
        this.selectionModel = this.authorPage.getAuthorSelectionModel();
        this.highlighter = this.authorPage.getHighlighter();
        this.errorConsumer = errorConsumer;
        this.readOnlyController = readOnlyController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] insert(int startOffset, int endOffset, String suggestion, List<InsertMode> insertModes, boolean asMarkup, boolean deleteSelection, boolean isCopilotInsertion) {
        int[] toRet = new int[]{-1, -1};
        if (suggestion != null) {
            this.controller.beginCompoundEdit();
            try {
                toRet = this.insertInternal(startOffset, endOffset, suggestion, insertModes, asMarkup, deleteSelection, isCopilotInsertion);
            }
            finally {
                this.controller.endCompoundEdit();
            }
        }
        return toRet;
    }

    private int[] insertInternal(int startOffset, int endOffset, String suggestion, List<InsertMode> insertModes, boolean asMarkup, boolean deleteSelection, boolean isCopilotInsertion) {
        int[] toRet = new int[]{-1, -1};
        if (suggestion != null && !suggestion.isEmpty()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Insert suggestion as markup {}", (Object)asMarkup);
                logger.debug("Interval start:" + startOffset + " end: " + endOffset + " replace:" + deleteSelection + " doc length " + this.controller.getAuthorDocumentNode().getLength() + " modes: " + insertModes);
            }
            if (asMarkup) {
                toRet = this.insertInternalAsMarkup(startOffset, endOffset, suggestion, insertModes, deleteSelection, isCopilotInsertion);
            } else {
                if (deleteSelection) {
                    this.controller.delete(startOffset, endOffset - 1);
                }
                toRet = this.insertTextAndSelect(startOffset, suggestion);
            }
        }
        return toRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] insertInternalAsMarkup(int startOffset, int endOffset, String markup, List<InsertMode> insertModes, boolean deleteSelection, boolean isCopilotInsertion) {
        int[] toRet;
        block16: {
            toRet = new int[]{-1, -1};
            AuthorDocumentFragment frag = null;
            boolean wasChangeTrackingToggled = false;
            try {
                this.controller.beginCompoundEdit();
                if (!isCopilotInsertion && this.authorPage != null && this.authorPage.getReviewController() != null && this.authorPage.getReviewController().isTrackingChanges()) {
                    this.authorPage.getReviewController().toggleTrackChanges();
                    wasChangeTrackingToggled = true;
                }
                if (this.isRootSelected(startOffset, endOffset) && deleteSelection) {
                    MarkupPreprocessor.PreprocessedTextInfo preprocessedTextInfo = MarkupPreprocessor.preprocessText(markup, true);
                    AuthorElement oldRootElement = this.controller.getAuthorDocumentNode().getRootElement();
                    this.updateDoctypeAndTextBeforeRoot(preprocessedTextInfo, oldRootElement);
                    int contentOffset = oldRootElement.getStartOffset() + 1;
                    frag = this.controller.createNewDocumentFragmentInContext(preprocessedTextInfo.processedText, contentOffset);
                    this.controller.replaceRoot(frag);
                    AuthorElement newRootElement = this.controller.getAuthorDocumentNode().getRootElement();
                    int selAndHighlightStartOffset = newRootElement.getStartOffset();
                    int selAndHighlightEndOffset = newRootElement.getEndOffset() + 1;
                    this.addInsertionHighlight(selAndHighlightStartOffset, selAndHighlightEndOffset);
                    toRet = new int[]{selAndHighlightStartOffset, selAndHighlightEndOffset};
                } else {
                    int offset;
                    SchemaAwareHandlerResult result;
                    MarkupPreprocessor.PreprocessedTextInfo preprocessedTextInfo = MarkupPreprocessor.preprocessText(markup, false);
                    if (deleteSelection && endOffset > startOffset) {
                        this.controller.delete(startOffset, endOffset - 1);
                    }
                    if ((result = this.controller.insertFragmentSchemaAware(offset = this.applyInsertionStrategy(insertModes, startOffset), frag = this.controller.createNewDocumentFragmentInContext(preprocessedTextInfo.processedText, startOffset))) != null) {
                        Integer insertionOffset = (Integer)result.getResult("result.id.handle.insert.fragment.offset");
                        int selectionAndHighlightEndOffset = insertionOffset + frag.getLength();
                        this.addInsertionHighlight(insertionOffset, selectionAndHighlightEndOffset);
                        toRet = new int[]{insertionOffset, selectionAndHighlightEndOffset};
                    } else {
                        toRet = new int[]{startOffset, startOffset + (frag != null ? frag.getLength() : 0)};
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                if (frag == null) {
                    Translator translator = Translator.getInstance();
                    Optional.ofNullable(this.errorConsumer).ifPresent(t -> t.accept(MessageFormat.format(translator.getTranslation("Couldnt_insert_invalid_content"), e.getMessage())));
                    break block16;
                }
                try {
                    this.controller.cancelCompoundEdit();
                }
                catch (CannotUndoException ex) {
                    logger.error(ex.getMessage(), (Throwable)e);
                }
                Optional.ofNullable(this.errorConsumer).ifPresent(t -> t.accept(e.getMessage()));
            }
            finally {
                if (wasChangeTrackingToggled) {
                    this.authorPage.getReviewController().toggleTrackChanges();
                }
                if (frag != null) {
                    this.controller.endCompoundEdit();
                }
            }
        }
        return toRet;
    }

    private void updateDoctypeAndTextBeforeRoot(MarkupPreprocessor.PreprocessedTextInfo preprocessedTextInfo, AuthorElement rootElement) {
        if (preprocessedTextInfo.doctype != null && !preprocessedTextInfo.doctype.equals((Object)this.controller.getDoctype())) {
            this.controller.setDoctype(preprocessedTextInfo.doctype);
        }
        if (preprocessedTextInfo.insertBeforeRoot != null) {
            try {
                AuthorDocumentFragment frag = this.controller.createNewDocumentFragmentInContext(preprocessedTextInfo.insertBeforeRoot, rootElement.getStartOffset() + 1);
                AuthorParentNode doc = (AuthorParentNode)rootElement.getParent();
                if (doc != null) {
                    ArrayList docChildren = new ArrayList(doc.getContentNodes());
                    docChildren.stream().filter(DefaultContentInserterForAuthorPage::isXMLModelPI).forEach(arg_0 -> ((AuthorDocumentController)this.controller).deleteNode(arg_0));
                }
                this.controller.insertFragment(rootElement.getStartOffset(), frag);
            }
            catch (AuthorOperationException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private static boolean isXMLModelPI(AuthorNode authorNode) {
        try {
            return authorNode.getType() == 5 && authorNode.getTextContent() != null && authorNode.getTextContent().startsWith(XML_MODEL_PI_TARGET);
        }
        catch (BadLocationException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private int applyInsertionStrategy(List<InsertMode> insertStrategies, int insertionOffset) throws AuthorOperationException {
        if (insertStrategies == null || insertStrategies.isEmpty()) {
            return insertionOffset;
        }
        for (InsertMode insertMode : insertStrategies) {
            AuthorNode[] targetNodes;
            boolean isValidCondition;
            boolean bl = isValidCondition = insertMode.getXPathCondition() == null;
            if (!isValidCondition) {
                Object[] result = this.controller.evaluateXPath("boolean(" + insertMode.getXPathCondition() + ")", true, true, true);
                boolean bl2 = isValidCondition = result.length > 0 && Boolean.parseBoolean(result[0].toString());
            }
            if (!isValidCondition || TextUtils.isNullOrBlank(insertMode.getTargetLocation()) || (targetNodes = this.controller.findNodesByXPath(insertMode.getTargetLocation(), true, true, true)) == null || targetNodes.length <= 0 || targetNodes[0].getType() != 0) continue;
            AuthorElement targetNode = (AuthorElement)targetNodes[0];
            switch (insertMode.getAction()) {
                case "insert-after": {
                    insertionOffset = targetNode.getEndOffset() + 1;
                    break;
                }
                case "insert-before": {
                    insertionOffset = targetNode.getStartOffset();
                    break;
                }
                case "replace": {
                    insertionOffset = targetNode.getStartOffset();
                    this.controller.deleteNode((AuthorNode)targetNode);
                    break;
                }
            }
            break;
        }
        return insertionOffset;
    }

    private void addInsertionHighlight(int startOffset, int endOffset) {
        ColorHighlightPainter painter = new ColorHighlightPainter();
        painter.setBgColor(Color.COLOR_PASTE_HIGHLIGHT_YELLOW);
        painter.setTextDecoration(ColorHighlightPainter.TextDecoration.NONE);
        try {
            this.insertionHighlight = this.highlighter.addHighlight(startOffset, endOffset - 1, (HighlightPainter)painter, this.highlightsMap);
        }
        catch (BadLocationException e) {
            logger.error("Could not add highlight!", (Throwable)e);
        }
    }

    public boolean isRootSelected(int startOffset, int endOffset) {
        AuthorElement rootElement = this.controller.getAuthorDocumentNode().getRootElement();
        return startOffset <= rootElement.getStartOffset() && rootElement.getEndOffset() <= endOffset;
    }

    private int[] insertTextAndSelect(int offset, String text) {
        this.controller.insertText(offset, text);
        int endOffset = offset + text.length();
        this.addInsertionHighlight(offset, endOffset);
        return new int[]{offset, endOffset};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] replaceSelectionWithSuggestion(String suggestion, boolean asMarkup, int startOffset, int endOffset, boolean isCopilotReplace) {
        if (suggestion != null) {
            this.controller.beginCompoundEdit();
            this.controller.markSelection(null, -1, null, AuthorSelectionAndCaretModelUtil.convertSelectionIntervals(this.selectionModel.getSelectionIntervals()), this.authorPage.getCaretOffset(), this.selectionModel.getSelectionInterpretationMode());
            try {
                int[] nArray = this.insertInternal(startOffset, endOffset, suggestion, null, asMarkup, true, isCopilotReplace);
                return nArray;
            }
            finally {
                this.controller.endCompoundEdit();
            }
        }
        return new int[]{startOffset, endOffset};
    }

    @Override
    public Optional<String> getContentType() {
        return Optional.ofNullable(this.contentType);
    }

    @Override
    public ReadOnlyController getReadOnlyController() {
        return this.readOnlyController;
    }

    @Override
    public Optional<String> getDocumentTypeName() {
        return Optional.ofNullable(this.documentTypeInfo).map(doctype -> {
            Object doctypeName = doctype.getName();
            if (doctypeName != null && !((String)doctypeName).contains(DITA_FRAMEWORK_NAME_PART) && this.isCurrentDocADITAResource()) {
                doctypeName = (String)doctypeName + " DITA";
            }
            return doctypeName;
        }).or(Optional::empty);
    }

    @Override
    public void cleanUp() {
        this.removeInsertionHighlight();
    }

    protected void removeInsertionHighlight() {
        if (this.highlighter != null && this.insertionHighlight != null) {
            this.highlighter.removeHighlight(this.insertionHighlight);
        }
    }

    @Override
    public abstract boolean previewReplaceSelectionWithSuggestion(String var1, boolean var2, int var3, int var4);

    @Override
    public abstract boolean previewInsert(int var1, int var2, String var3, List<InsertMode> var4, boolean var5, boolean var6);

    @Override
    public Position createPosition(int offset) throws BadLocationException {
        return this.controller.createPositionInContent(offset);
    }

    @Override
    public String getEntireDocumentContent() {
        Reader reader = this.authorPage.getParentEditor().createContentReader();
        try {
            return IOUtil.read((Reader)reader).toString();
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
            return null;
        }
    }

    @Override
    public Reader createDocumentReader() {
        return this.authorPage.getParentEditor().createContentReader();
    }

    @Override
    public String getEditorLocation() {
        URL editorLocation = this.authorPage.getParentEditor().getEditorLocation();
        return editorLocation != null ? editorLocation.toString() : null;
    }

    @Override
    public int getSelectionStart() {
        return this.authorPage.getBalancedSelectionStart();
    }

    @Override
    public int getSelectionEnd() {
        return this.authorPage.getBalancedSelectionEnd();
    }

    public void setAttributesHighlightsMap(Map<String, String> highligtsMap) {
        this.highlightsMap = highligtsMap;
    }

    @Override
    public int getRootStart() {
        return this.authorPage.getDocumentController().getAuthorDocumentNode().getRootElement().getStartOffset();
    }

    @Override
    public int getRootEnd() {
        int endOffset = this.authorPage.getDocumentController().getAuthorDocumentNode().getRootElement().getEndOffset();
        return endOffset + 1;
    }

    private boolean isCurrentDocADITAResource() {
        AuthorElement element;
        AuthorDocument doc;
        boolean isDITAResource = false;
        if (this.authorPage != null && this.authorPage.getDocumentController() != null && (doc = this.authorPage.getDocumentController().getAuthorDocumentNode()) != null && doc.getRootElement() != null && (element = doc.getRootElement()) != null) {
            int length = element.getAttributesCount();
            for (int i = 0; i < length; ++i) {
                String attrQName = element.getAttributeAtIndex(i);
                String attributeLocalName = BasicXmlUtil.getLocalName((String)attrQName);
                String namespace = element.getAttributeNamespace(BasicXmlUtil.getProxy((String)attrQName));
                if (!"DITAArchVersion".equals(attributeLocalName) || !"http://dita.oasis-open.org/architecture/2005/".equals(namespace)) continue;
                isDITAResource = true;
                break;
            }
        }
        return isDITAResource;
    }

    @Override
    public String getCaretSelectionInfo() {
        return SelectionUtil.getCaretSelectioInfo((WSTextBasedEditorPage)this.authorPage);
    }
}

