/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.interactions;

import com.oxygenxml.positron.core.interactions.ContextInfo;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.function.Function;
import javax.swing.text.BadLocationException;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPageBase;

public class AuthorContextInfo
extends ContextInfo {
    private WeakReference<AuthorDocumentController> controllerRef;
    private WeakReference<WSAuthorEditorPageBase> authorPageRef;

    public AuthorContextInfo(WSAuthorEditorPageBase authorPage, AuthorDocumentController controller, String usableContent, int startOffset, int endOffset) {
        super(usableContent, startOffset, endOffset);
        if (controller != null) {
            this.controllerRef = new WeakReference<AuthorDocumentController>(controller);
        }
        if (authorPage != null) {
            this.authorPageRef = new WeakReference<WSAuthorEditorPageBase>(authorPage);
        }
    }

    public List<AuthorNode> getNodesInSelection() throws BadLocationException {
        if (this.controllerRef != null) {
            AuthorDocumentController controller = (AuthorDocumentController)this.controllerRef.get();
            return controller.getNodesToSelect(this.getStartOffset(), this.getEndOffset());
        }
        return null;
    }

    public Function<AuthorNode, Styles> getStylesProvider() {
        WSAuthorEditorPageBase authorPage;
        if (this.authorPageRef != null && (authorPage = (WSAuthorEditorPageBase)this.authorPageRef.get()) != null) {
            return new Function<AuthorNode, Styles>(){

                @Override
                public Styles apply(AuthorNode node) {
                    return authorPage.getStyles(node);
                }
            };
        }
        return null;
    }
}

