/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.filter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.oxygenxml.positron.core.filter.MaskingDetail;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SensitiveContentMaskingInfo {
    @JsonProperty(value="messages_masked_count")
    private int messagesMaskedCount = 0;
    @JsonProperty(value="parameters_masked_count")
    private int parametersMaskedCount = 0;
    @JsonProperty(value="placeholder_texts")
    private List<String> placeholderTexts = new ArrayList<String>();
    @JsonProperty(value="masking_details")
    private List<MaskingDetail> maskingDetails = new ArrayList<MaskingDetail>();

    public void setPlaceholderTexts(List<String> placeholderTexts) {
        this.placeholderTexts = placeholderTexts != null ? placeholderTexts : new ArrayList();
    }

    public void setMaskingDetails(List<MaskingDetail> maskingDetails) {
        this.maskingDetails = maskingDetails != null ? maskingDetails : new ArrayList();
    }

    public void addMessagesMasking(int count, String placeholderText) {
        this.messagesMaskedCount += count;
        if (placeholderText != null && !this.placeholderTexts.contains(placeholderText)) {
            this.placeholderTexts.add(placeholderText);
        }
    }

    public void addParametersMasking(int count, String placeholderText) {
        this.parametersMaskedCount += count;
        if (placeholderText != null && !this.placeholderTexts.contains(placeholderText)) {
            this.placeholderTexts.add(placeholderText);
        }
    }

    public void addMaskingDetail(MaskingDetail detail) {
        if (detail != null) {
            this.maskingDetails.add(detail);
        }
    }

    public boolean hasMasking() {
        return this.messagesMaskedCount > 0 || this.parametersMaskedCount > 0;
    }

    @JsonIgnore
    public int getTotalMaskedCount() {
        return this.messagesMaskedCount + this.parametersMaskedCount;
    }

    public void reset() {
        this.messagesMaskedCount = 0;
        this.parametersMaskedCount = 0;
        this.placeholderTexts.clear();
        this.maskingDetails.clear();
    }

    public SensitiveContentMaskingInfo clone() {
        SensitiveContentMaskingInfo cloned = new SensitiveContentMaskingInfo();
        cloned.messagesMaskedCount = this.messagesMaskedCount;
        cloned.parametersMaskedCount = this.parametersMaskedCount;
        cloned.placeholderTexts = new ArrayList<String>(this.placeholderTexts);
        cloned.maskingDetails = new ArrayList<MaskingDetail>(this.maskingDetails);
        return cloned;
    }

    @JsonProperty(value="messages_masked_count")
    public void setMessagesMaskedCount(int messagesMaskedCount) {
        this.messagesMaskedCount = messagesMaskedCount;
    }

    @JsonProperty(value="parameters_masked_count")
    public void setParametersMaskedCount(int parametersMaskedCount) {
        this.parametersMaskedCount = parametersMaskedCount;
    }

    public int getMessagesMaskedCount() {
        return this.messagesMaskedCount;
    }

    public int getParametersMaskedCount() {
        return this.parametersMaskedCount;
    }

    public List<String> getPlaceholderTexts() {
        return this.placeholderTexts;
    }

    public List<MaskingDetail> getMaskingDetails() {
        return this.maskingDetails;
    }
}

