/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.api.connector.dto.AssistantMessage;
import com.oxygenxml.positron.api.connector.dto.CompletionFunctionCall;
import com.oxygenxml.positron.api.connector.dto.CompletionToolCall;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.Pair;
import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.filter.DefaultSensitiveFilterPatternBuilder;
import com.oxygenxml.positron.core.filter.FilteredContentRestorer;
import com.oxygenxml.positron.core.filter.MaskingDetail;
import com.oxygenxml.positron.core.filter.MessageCloner;
import com.oxygenxml.positron.core.filter.SensitiveContentMaskingInfo;
import com.oxygenxml.positron.core.filter.SensitiveContentPattern;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensitiveContentFilter
implements FilteredContentRestorer {
    private static final Logger log = LoggerFactory.getLogger(SensitiveContentFilter.class);
    private Supplier<String> filterPatternsSupplier;
    private final Map<String, String> placeholderToContent = new HashMap<String, String>();
    private final AtomicInteger placeholderCounter = new AtomicInteger(1);
    private final Map<String, Integer> maskTypeCounter = new HashMap<String, Integer>();
    private List<Pair<Pattern, String>> compiledPatterns;
    private String lastPatternsString;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private ChatInteractor chatInteractor;

    public SensitiveContentFilter(Supplier<String> filterPatternsSupplier) {
        this(filterPatternsSupplier, () -> false);
    }

    public SensitiveContentFilter(Supplier<String> filterPatternsSupplier, Supplier<Boolean> includeDefaultsSupplier) {
        this.filterPatternsSupplier = () -> SensitiveContentFilter.mergeDefaultSensitivePatternsWithUserContentPatterns(filterPatternsSupplier, includeDefaultsSupplier);
    }

    public void setFilterPatternsSupplier(Supplier<String> filterPatternsSupplier, Supplier<Boolean> includeDefaultsSupplier) {
        this.compiledPatterns = null;
        this.lastPatternsString = null;
        this.filterPatternsSupplier = () -> SensitiveContentFilter.mergeDefaultSensitivePatternsWithUserContentPatterns(filterPatternsSupplier, includeDefaultsSupplier);
    }

    public List<Message> maskMessages(List<Message> messages) {
        if (messages == null || messages.isEmpty()) {
            return messages;
        }
        this.ensurePatternsCompiled();
        if (this.compiledPatterns == null || this.compiledPatterns.isEmpty()) {
            return messages;
        }
        SensitiveContentMaskingInfo maskingInfo = new SensitiveContentMaskingInfo();
        int operationStartCount = this.placeholderToContent.size();
        List<Message> maskedMessages = MessageCloner.deepClone(messages);
        this.performMessagesMasking(maskedMessages, maskingInfo);
        this.postProcessMessagesForSingleOccurrences(maskedMessages, maskingInfo);
        int operationEndCount = this.placeholderToContent.size();
        int maskedCount = operationEndCount - operationStartCount;
        if (maskedCount > 0) {
            String placeholderText = this.compiledPatterns.isEmpty() ? null : (String)this.compiledPatterns.get(0).getSecond();
            maskingInfo.addMessagesMasking(maskedCount, placeholderText);
        }
        this.notifyChat(maskingInfo);
        return maskedMessages;
    }

    public Pair<List<Message>, Map<String, String>> maskMessagesAndParameters(List<Message> messages, Map<String, String> parameters) {
        int operationEndCount;
        int maskedCount;
        List<Message> maskedMessages = messages;
        Map<String, String> maskedParameters = parameters;
        this.ensurePatternsCompiled();
        if (this.compiledPatterns == null || this.compiledPatterns.isEmpty()) {
            return new Pair(maskedMessages, maskedParameters);
        }
        SensitiveContentMaskingInfo maskingInfo = new SensitiveContentMaskingInfo();
        int operationStartCount = this.placeholderToContent.size();
        if (messages != null && !messages.isEmpty()) {
            maskedMessages = MessageCloner.deepClone(messages);
            this.performMessagesMasking(maskedMessages, maskingInfo);
        }
        if (parameters != null && !parameters.isEmpty()) {
            maskedParameters = this.performParametersMasking(parameters, maskingInfo);
        }
        if (maskedMessages != null && !maskedMessages.isEmpty()) {
            this.postProcessMessagesForSingleOccurrences(maskedMessages, maskingInfo);
        }
        if (maskedParameters != null && !maskedParameters.isEmpty()) {
            maskedParameters = this.postProcessParametersForSingleOccurrences(maskedParameters);
        }
        if ((maskedCount = (operationEndCount = this.placeholderToContent.size()) - operationStartCount) > 0) {
            String placeholderText = this.compiledPatterns.isEmpty() ? null : (String)this.compiledPatterns.get(0).getSecond();
            maskingInfo.addMessagesMasking(maskedCount, placeholderText);
        }
        this.notifyChat(maskingInfo);
        return new Pair(maskedMessages, maskedParameters);
    }

    private void performMessagesMasking(List<Message> maskedMessages, SensitiveContentMaskingInfo maskingInfo) {
        for (Message message : maskedMessages) {
            AssistantMessage assistantMessage;
            this.maskMessage(message, maskingInfo);
            if (!(message instanceof AssistantMessage) || (assistantMessage = (AssistantMessage)message).getToolCalls() == null || assistantMessage.getToolCalls().isEmpty()) continue;
            this.maskToolCallArguments(assistantMessage.getToolCalls(), maskingInfo);
        }
    }

    private Map<String, String> performParametersMasking(Map<String, String> parameters, SensitiveContentMaskingInfo maskingInfo) {
        HashMap<String, String> maskedParameters = new HashMap<String, String>();
        boolean hasChanges = false;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String originalValue = entry.getValue();
            String maskedValue = this.maskText(originalValue, maskingInfo);
            maskedParameters.put(entry.getKey(), maskedValue);
            if (originalValue == null || originalValue.equals(maskedValue)) continue;
            hasChanges = true;
        }
        if (hasChanges) {
            int maskedCount = this.placeholderToContent.size();
            String placeholderText = this.compiledPatterns.isEmpty() ? null : (String)this.compiledPatterns.get(0).getSecond();
            maskingInfo.addParametersMasking(maskedCount, placeholderText);
        }
        return hasChanges ? maskedParameters : parameters;
    }

    private Message maskMessage(Message message, SensitiveContentMaskingInfo maskingInfo) {
        if (message == null || message.getContent() == null) {
            return message;
        }
        ArrayList<Object> maskedContents = new ArrayList<Object>();
        boolean hasChanges = false;
        for (MessageContent content : message.getContent()) {
            if (content instanceof MessageTextContent) {
                MessageTextContent textContent = (MessageTextContent)content;
                String originalText = textContent.getText();
                String maskedText = this.maskText(originalText, maskingInfo);
                maskedContents.add(new MessageTextContent(maskedText));
                if (originalText == null || originalText.equals(maskedText)) continue;
                hasChanges = true;
                continue;
            }
            maskedContents.add(content);
        }
        if (hasChanges) {
            message.setContent(maskedContents);
        }
        return message;
    }

    private String maskText(String text, SensitiveContentMaskingInfo maskingInfo) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        this.ensurePatternsCompiled();
        String originalText = text;
        String result = text;
        for (Pair<Pattern, String> patternMask : this.compiledPatterns) {
            Matcher matcher = ((Pattern)patternMask.getFirst()).matcher(result);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String matched = matcher.group();
                int matchStartInOriginal = originalText.indexOf(matched);
                PlaceholderInfo placeholderInfo = this.getPlaceholderWithDetails(matched, (String)patternMask.getSecond(), originalText, matchStartInOriginal);
                if (placeholderInfo.isNewlyCreated()) {
                    maskingInfo.addMaskingDetail(placeholderInfo.getMaskingDetail());
                }
                matcher.appendReplacement(sb, Matcher.quoteReplacement(placeholderInfo.getPlaceholder()));
            }
            matcher.appendTail(sb);
            result = sb.toString();
        }
        return result;
    }

    private void postProcessMessagesForSingleOccurrences(List<Message> messages, SensitiveContentMaskingInfo maskingInfo) {
        if (messages == null || this.compiledPatterns == null) {
            return;
        }
        for (Pair<Pattern, String> patternMask : this.compiledPatterns) {
            String mask = (String)patternMask.getSecond();
            int totalCount = this.maskTypeCounter.getOrDefault(mask, 0);
            if (totalCount != 1) continue;
            String oldPlaceholder = "[" + mask + "_1]";
            String newPlaceholder = "[" + mask + "]";
            String content = this.placeholderToContent.remove(oldPlaceholder);
            if (content != null) {
                this.placeholderToContent.put(newPlaceholder, content);
            }
            for (MaskingDetail detail : maskingInfo.getMaskingDetails()) {
                if (!detail.getPlaceholder().equals(mask + "_1")) continue;
                detail.setPlaceholder(mask);
            }
            this.postProcessAllMEssageContents(messages, oldPlaceholder, newPlaceholder);
        }
    }

    private void postProcessAllMEssageContents(List<Message> messages, String oldPlaceholder, String newPlaceholder) {
        for (Message message : messages) {
            AssistantMessage assistantMessage;
            if (message.getContent() != null) {
                ArrayList<Object> updatedContents = new ArrayList<Object>();
                boolean contentChanged = false;
                for (MessageContent content2 : message.getContent()) {
                    if (content2 instanceof MessageTextContent) {
                        MessageTextContent textContent = (MessageTextContent)content2;
                        String text = textContent.getText();
                        if (text != null && text.contains(oldPlaceholder)) {
                            updatedContents.add(new MessageTextContent(text.replace(oldPlaceholder, newPlaceholder)));
                            contentChanged = true;
                            continue;
                        }
                        updatedContents.add(content2);
                        continue;
                    }
                    updatedContents.add(content2);
                }
                if (contentChanged) {
                    message.setContent(updatedContents);
                }
            }
            if (!(message instanceof AssistantMessage) || (assistantMessage = (AssistantMessage)message).getToolCalls() == null) continue;
            for (CompletionToolCall toolCall : assistantMessage.getToolCalls()) {
                CompletionFunctionCall function;
                String args;
                if (toolCall == null || toolCall.getFunction() == null || (args = (function = toolCall.getFunction()).getArguments()) == null || !args.contains(oldPlaceholder)) continue;
                function.setArguments(args.replace(oldPlaceholder, newPlaceholder));
            }
        }
    }

    private Map<String, String> postProcessParametersForSingleOccurrences(Map<String, String> parameters) {
        if (parameters == null || this.compiledPatterns == null) {
            return parameters;
        }
        HashMap<String, String> result = new HashMap<String, String>(parameters);
        boolean hasChanges = false;
        for (Pair<Pattern, String> patternMask : this.compiledPatterns) {
            String mask = (String)patternMask.getSecond();
            int totalCount = this.maskTypeCounter.getOrDefault(mask, 0);
            if (totalCount != 1) continue;
            String oldPlaceholder = "[" + mask + "_1]";
            String newPlaceholder = "[" + mask + "]";
            String content = this.placeholderToContent.remove(oldPlaceholder);
            if (content != null) {
                this.placeholderToContent.put(newPlaceholder, content);
            }
            for (Map.Entry entry : result.entrySet()) {
                String value = (String)entry.getValue();
                if (value == null || !value.contains(oldPlaceholder)) continue;
                result.put((String)entry.getKey(), value.replace(oldPlaceholder, newPlaceholder));
                hasChanges = true;
            }
        }
        return hasChanges ? result : parameters;
    }

    public String maskText(String text) {
        return this.maskText(text, new SensitiveContentMaskingInfo());
    }

    private PlaceholderInfo getPlaceholderWithDetails(String matchedContent, String mask, String fullText, int matchStartIndex) {
        for (Map.Entry<String, String> entry : this.placeholderToContent.entrySet()) {
            if (!entry.getValue().equals(matchedContent)) continue;
            return new PlaceholderInfo(entry.getKey(), false, null);
        }
        int currentCount = this.maskTypeCounter.getOrDefault(mask, 0);
        int num = currentCount + 1;
        this.maskTypeCounter.put(mask, num);
        String placeholder = "[" + mask + "_" + num + "]";
        String placeholderName = mask + "_" + num;
        this.placeholderToContent.put(placeholder, matchedContent);
        String contextBefore = this.extractContext(fullText, matchStartIndex, true);
        String contextAfter = this.extractContext(fullText, matchStartIndex + matchedContent.length(), false);
        MaskingDetail detail = new MaskingDetail(placeholderName, matchedContent, contextBefore, contextAfter);
        return new PlaceholderInfo(placeholder, true, detail);
    }

    private String extractContext(String text, int position, boolean beforePosition) {
        int CONTEXT_LENGTH = 50;
        String toReturn = null;
        if (beforePosition) {
            int startIndex = Math.max(0, position - 50);
            toReturn = text.substring(startIndex, position).trim();
        } else {
            int endIndex = Math.min(text.length(), position + 50);
            toReturn = text.substring(position, endIndex).trim();
        }
        return toReturn;
    }

    private String getPlaceholder(String matchedContent, String mask) {
        for (Map.Entry<String, String> entry : this.placeholderToContent.entrySet()) {
            if (!entry.getValue().equals(matchedContent)) continue;
            return entry.getKey();
        }
        int num = this.placeholderCounter.getAndIncrement();
        String placeholder = "[" + mask + "_" + num + "]";
        this.placeholderToContent.put(placeholder, matchedContent);
        return placeholder;
    }

    @Override
    public String restoreContent(String content) {
        if (content == null || content.isEmpty() || this.placeholderToContent.isEmpty()) {
            return content;
        }
        String result = content;
        for (Map.Entry<String, String> entry : this.placeholderToContent.entrySet()) {
            result = result.replace(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private void maskToolCallArguments(List<CompletionToolCall> toolCalls, SensitiveContentMaskingInfo maskingInfo) {
        if (toolCalls == null || toolCalls.isEmpty()) {
            return;
        }
        for (CompletionToolCall toolCall : toolCalls) {
            CompletionFunctionCall function;
            if (toolCall == null || toolCall.getFunction() == null || (function = toolCall.getFunction()).getArguments() == null) continue;
            String maskedArguments = this.maskText(function.getArguments(), maskingInfo);
            function.setArguments(maskedArguments);
        }
    }

    @Override
    public List<CompletionToolCall> restoreContentInToolCallArguments(List<CompletionToolCall> toolCalls) {
        if (toolCalls == null || toolCalls.isEmpty() || this.placeholderToContent.isEmpty()) {
            return toolCalls;
        }
        for (CompletionToolCall toolCall : toolCalls) {
            CompletionFunctionCall function;
            if (toolCall == null || toolCall.getFunction() == null || (function = toolCall.getFunction()).getArguments() == null) continue;
            String restoredArguments = this.restoreContent(function.getArguments());
            function.setArguments(restoredArguments);
        }
        return toolCalls;
    }

    public void setChatInteractor(ChatInteractor chatInteractor) {
        this.chatInteractor = chatInteractor;
    }

    private void notifyChat(SensitiveContentMaskingInfo maskingInfo) {
        if (this.chatInteractor != null && maskingInfo.hasMasking()) {
            this.chatInteractor.showSensitiveContentMasking(maskingInfo.clone());
        }
    }

    public void clearMappings() {
        this.placeholderToContent.clear();
        this.placeholderCounter.set(1);
        this.maskTypeCounter.clear();
    }

    public FilteredContentRestorer createContentRestorer() {
        return this;
    }

    private void ensurePatternsCompiled() {
        String patternsString = this.filterPatternsSupplier.get();
        if (this.compiledPatterns != null) {
            if (patternsString == null && this.lastPatternsString == null) {
                return;
            }
            if (patternsString != null && patternsString.equals(this.lastPatternsString)) {
                return;
            }
        }
        this.lastPatternsString = patternsString;
        if (patternsString == null || patternsString.trim().isEmpty()) {
            this.compiledPatterns = new ArrayList<Pair<Pattern, String>>();
            return;
        }
        this.compiledPatterns = new ArrayList<Pair<Pattern, String>>();
        List<SensitiveContentPattern> patterns = this.parsePatternsFromJSON(patternsString);
        for (SensitiveContentPattern patternDto : patterns) {
            String trimmed;
            if (patternDto.getPattern() == null || (trimmed = patternDto.getPattern().trim()).isEmpty()) continue;
            try {
                Pattern compiled = Pattern.compile(trimmed);
                String placeholderText = patternDto.getPlaceholderText() != null && !patternDto.getPlaceholderText().trim().isEmpty() ? patternDto.getPlaceholderText().trim() : "[FILTERED_";
                this.compiledPatterns.add((Pair<Pattern, String>)new Pair((Object)compiled, (Object)placeholderText));
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        }
    }

    private List<SensitiveContentPattern> parsePatternsFromJSON(String patternsJson) {
        String trimmed = patternsJson.trim();
        List<SensitiveContentPattern> toReturn = new ArrayList<SensitiveContentPattern>();
        if (!trimmed.isEmpty()) {
            try {
                List patterns = (List)OBJECT_MAPPER.readValue(trimmed, (TypeReference)new TypeReference<List<SensitiveContentPattern>>(){});
                if (patterns != null) {
                    toReturn = patterns;
                }
            }
            catch (JsonProcessingException jsonProcessingException) {
                // empty catch block
            }
        }
        return toReturn;
    }

    private static String mergeDefaultSensitivePatternsWithUserContentPatterns(Supplier<String> userPatternsSupplier, Supplier<Boolean> includeDefaultsSupplier) {
        boolean includeDefaults;
        String userPatternsJson;
        ArrayList<SensitiveContentPattern> mergedPatterns = new ArrayList<SensitiveContentPattern>();
        String string = userPatternsJson = userPatternsSupplier != null ? userPatternsSupplier.get() : null;
        if (userPatternsJson != null && !userPatternsJson.trim().isEmpty()) {
            try {
                List userPatterns = (List)OBJECT_MAPPER.readValue(userPatternsJson, (TypeReference)new TypeReference<List<SensitiveContentPattern>>(){});
                if (userPatterns != null) {
                    mergedPatterns.addAll(userPatterns);
                }
            }
            catch (JsonProcessingException e) {
                log.debug("Error loading the json from supplier", (Throwable)e);
            }
        }
        boolean bl = includeDefaults = includeDefaultsSupplier != null && includeDefaultsSupplier.get() != false;
        if (includeDefaults) {
            List<SensitiveContentPattern> defaultPatterns = new DefaultSensitiveFilterPatternBuilder().addAllDefaultPatterns().build();
            mergedPatterns.addAll(defaultPatterns);
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(mergedPatterns);
        }
        catch (JsonProcessingException e) {
            log.debug("Error serializing the json back", (Throwable)e);
            return "[]";
        }
    }

    private static class PlaceholderInfo {
        private final String placeholder;
        private final boolean newlyCreated;
        private final MaskingDetail maskingDetail;

        PlaceholderInfo(String placeholder, boolean newlyCreated, MaskingDetail maskingDetail) {
            this.placeholder = placeholder;
            this.newlyCreated = newlyCreated;
            this.maskingDetail = maskingDetail;
        }

        String getPlaceholder() {
            return this.placeholder;
        }

        boolean isNewlyCreated() {
            return this.newlyCreated;
        }

        MaskingDetail getMaskingDetail() {
            return this.maskingDetail;
        }
    }
}

