/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCloner {
    private static final Logger log = LoggerFactory.getLogger(MessageCloner.class);

    private MessageCloner() {
    }

    public static List<Message> deepClone(List<Message> messages) {
        if (messages == null || messages.isEmpty()) {
            return messages;
        }
        try {
            ObjectMapper defaultObjectMapper = AIRequestUtil.defaultObjectMapper();
            String json = defaultObjectMapper.writeValueAsString(messages);
            return (List)defaultObjectMapper.readValue(json, (TypeReference)new TypeReference<List<Message>>(){});
        }
        catch (JsonProcessingException e) {
            log.error("Failed to clone messages using Jackson serialization. Returning original list.", (Throwable)e);
            return messages;
        }
    }
}

