/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.filter;

import com.oxygenxml.positron.core.filter.SensitiveContentPattern;
import java.util.ArrayList;
import java.util.List;

public class DefaultSensitiveFilterPatternBuilder {
    private final List<SensitiveContentPattern> patterns = new ArrayList<SensitiveContentPattern>();

    public DefaultSensitiveFilterPatternBuilder addEmailPattern() {
        this.patterns.add(new SensitiveContentPattern("[\\w.+-]+@[\\w.-]+\\.\\w{2,}", "filtered_email"));
        return this;
    }

    public DefaultSensitiveFilterPatternBuilder addPhoneNumberPattern() {
        this.patterns.add(new SensitiveContentPattern("\\+[1-9]\\d{6,14}|\\+[1-9]\\d{0,2}[\\s.-]*(?:\\(\\s*\\d{1,4}\\s*\\)|\\d{1,4})[\\s.-]*\\d{2,4}[\\s.-]*\\d{2,4}(?:[\\s.-]*\\d{2,4})?", "filtered_phone"));
        return this;
    }

    public DefaultSensitiveFilterPatternBuilder addCreditCardPattern() {
        this.patterns.add(new SensitiveContentPattern("\\b\\d{4}[-\\s]?\\d{4}[-\\s]?\\d{4}[-\\s]?\\d{4}\\b", "filtered_credit_card"));
        return this;
    }

    public DefaultSensitiveFilterPatternBuilder addSSNPattern() {
        this.patterns.add(new SensitiveContentPattern("\\b\\d{3}-\\d{2}-\\d{4}\\b", "filtered_ssn"));
        return this;
    }

    public DefaultSensitiveFilterPatternBuilder addAIProviderKeyPattern() {
        this.patterns.add(new SensitiveContentPattern("\\b(?:sk-[A-Za-z0-9-]{30,200}|xai-[A-Za-z0-9]{16,200}|AIza[A-Za-z0-9_-]{35})\\b", "filtered_ai_key"));
        return this;
    }

    public DefaultSensitiveFilterPatternBuilder addGitHubTokenPattern() {
        this.patterns.add(new SensitiveContentPattern("\\b(?:ghp|gho|ghu|ghs|ghr)_[A-Za-z0-9]{36}\\b|\\bgithub_pat_[A-Za-z0-9_]{50,255}\\b", "filtered_github_token"));
        return this;
    }

    public DefaultSensitiveFilterPatternBuilder addGitLabTokenPattern() {
        this.patterns.add(new SensitiveContentPattern("\\b(?:glpat|gloas|gldt|glrt|glrtr|glcbt|glptt|glft|glimt|glagent|glwt|glsoat)-[A-Za-z0-9_-]{10,200}\\b", "filtered_gitlab_token"));
        return this;
    }

    public DefaultSensitiveFilterPatternBuilder addIBANPattern() {
        this.patterns.add(new SensitiveContentPattern("[A-Z]{2}\\d{2}[\\s]?[\\dA-Z]{4}[\\s]?[\\dA-Z]{4}[\\s]?[\\dA-Z]{4}[\\s]?[\\dA-Z]{4}[\\s]?[\\dA-Z]{0,4}", "filtered_iban"));
        return this;
    }

    public DefaultSensitiveFilterPatternBuilder addJWTPattern() {
        this.patterns.add(new SensitiveContentPattern("\\beyJ[A-Za-z0-9_-]{10,}\\.[A-Za-z0-9_-]{10,}\\.[A-Za-z0-9_-]{10,}", "filtered_jwt"));
        return this;
    }

    public DefaultSensitiveFilterPatternBuilder addURLCredentialsPattern() {
        this.patterns.add(new SensitiveContentPattern("://[^/:@\\s]+:[^@\\s]+@[^\\s/]+", "filtered_url_credentials"));
        return this;
    }

    public DefaultSensitiveFilterPatternBuilder addAWSAccessKeyPattern() {
        this.patterns.add(new SensitiveContentPattern("\\bAKIA[A-Z0-9]{16}\\b", "filtered_aws_access_key"));
        return this;
    }

    public DefaultSensitiveFilterPatternBuilder addAWSSecretKeyPattern() {
        this.patterns.add(new SensitiveContentPattern("(?i)(?:aws_secret_access_key|secret_access_key|aws_secret)\\s*[=:]\\s*[A-Za-z0-9+/]{40}", "filtered_aws_secret_key"));
        return this;
    }

    public DefaultSensitiveFilterPatternBuilder addPrivateKeyPattern() {
        this.patterns.add(new SensitiveContentPattern("-----BEGIN [A-Z ]*PRIVATE KEY-----", "filtered_private_key"));
        return this;
    }

    public DefaultSensitiveFilterPatternBuilder addBasicAuthPattern() {
        this.patterns.add(new SensitiveContentPattern("\\bBasic\\s+[A-Za-z0-9+/]{10,}={0,2}", "filtered_basic_auth"));
        return this;
    }

    public DefaultSensitiveFilterPatternBuilder addBearerTokenPattern() {
        this.patterns.add(new SensitiveContentPattern("\\bBearer\\s+[A-Za-z0-9._-]{20,}", "filtered_bearer_token"));
        return this;
    }

    public DefaultSensitiveFilterPatternBuilder addDatabaseConnectionStringPattern() {
        this.patterns.add(new SensitiveContentPattern("(?:jdbc:[a-z]+://|mongodb(?:\\+srv)?://|postgres://|mysql://)[^/:@\\s]+:[^@\\s]+@[^\\s]+", "filtered_db_connection"));
        return this;
    }

    public DefaultSensitiveFilterPatternBuilder addAzureStorageKeyPattern() {
        this.patterns.add(new SensitiveContentPattern("AccountKey=[A-Za-z0-9+/]{50,}={0,2}", "filtered_azure_storage_key"));
        return this;
    }

    public DefaultSensitiveFilterPatternBuilder addAllDefaultPatterns() {
        return this.addAIProviderKeyPattern().addGitHubTokenPattern().addGitLabTokenPattern().addAWSAccessKeyPattern().addAzureStorageKeyPattern().addAWSSecretKeyPattern().addJWTPattern().addBearerTokenPattern().addPrivateKeyPattern().addBasicAuthPattern().addDatabaseConnectionStringPattern().addURLCredentialsPattern().addCreditCardPattern().addIBANPattern().addSSNPattern().addEmailPattern().addPhoneNumberPattern();
    }

    public List<SensitiveContentPattern> build() {
        return new ArrayList<SensitiveContentPattern>(this.patterns);
    }

    public DefaultSensitiveFilterPatternBuilder clear() {
        this.patterns.clear();
        return this;
    }

    public int size() {
        return this.patterns.size();
    }
}

