/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.filter;

import com.oxygenxml.positron.api.connector.dto.CompletionChoice;
import com.oxygenxml.positron.api.connector.dto.CompletionChunk;
import com.oxygenxml.positron.api.connector.dto.CompletionMessage;
import com.oxygenxml.positron.core.filter.FilteredContentRestorer;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import java.util.Arrays;
import org.reactivestreams.Publisher;

public class ContentRestorationFlowableTransformer
implements FlowableTransformer<CompletionChunk, CompletionChunk> {
    private final FilteredContentRestorer contentRestorer;
    private String buffer = "";

    public ContentRestorationFlowableTransformer(FilteredContentRestorer contentRestorer) {
        this.contentRestorer = contentRestorer;
    }

    public Publisher<CompletionChunk> apply(Flowable<CompletionChunk> upstream) {
        if (this.contentRestorer == null) {
            return upstream;
        }
        return upstream.concatMap(chunk -> {
            CompletionChunk processedChunk = this.processChunk((CompletionChunk)chunk);
            if (processedChunk == null) {
                return Flowable.empty();
            }
            return Flowable.just((Object)processedChunk);
        });
    }

    private CompletionChunk processChunk(CompletionChunk chunk) {
        if (chunk == null || chunk.getChoices() == null || chunk.getChoices().isEmpty()) {
            return chunk;
        }
        String content = this.getContentFromChunk(chunk);
        if (content == null || content.isEmpty()) {
            return chunk;
        }
        if (this.hasFinishReason(chunk)) {
            String fullText = this.buffer + content;
            this.buffer = "";
            String restored = this.contentRestorer.restoreContent(fullText);
            return this.setContentInChunk(restored, chunk);
        }
        CompletionChunk toRet = chunk;
        String fullText = this.buffer + content;
        int lastOpenBracket = fullText.lastIndexOf(91);
        if (lastOpenBracket == -1) {
            this.buffer = "";
            String restored = this.contentRestorer.restoreContent(fullText);
            this.setContentInChunk(restored, chunk);
        } else {
            int closingBracket = fullText.indexOf(93, lastOpenBracket);
            if (closingBracket != -1) {
                this.buffer = "";
                String restored = this.contentRestorer.restoreContent(fullText);
                this.setContentInChunk(restored, chunk);
            } else {
                String toProcess = fullText.substring(0, lastOpenBracket);
                this.buffer = fullText.substring(lastOpenBracket);
                if (toProcess.isEmpty()) {
                    toRet = null;
                } else {
                    String restored = this.contentRestorer.restoreContent(toProcess);
                    this.setContentInChunk(restored, chunk);
                }
            }
        }
        return toRet;
    }

    private boolean hasFinishReason(CompletionChunk chunk) {
        if (chunk == null || chunk.getChoices() == null || chunk.getChoices().isEmpty()) {
            return false;
        }
        String finishReason = ((CompletionChoice)chunk.getChoices().get(0)).getFinishReason();
        return finishReason != null && !finishReason.isEmpty();
    }

    private String getContentFromChunk(CompletionChunk chunk) {
        if (chunk.getChoices() != null && !chunk.getChoices().isEmpty()) {
            return ((CompletionChoice)chunk.getChoices().get(0)).getCompletionText();
        }
        return null;
    }

    private CompletionChunk setContentInChunk(String restoredContent, CompletionChunk originalChunk) {
        CompletionChoice completionChoice;
        if (originalChunk == null) {
            originalChunk = new CompletionChunk();
            CompletionChoice completionChoice2 = new CompletionChoice();
            completionChoice2.setIndex(0);
            CompletionMessage message = new CompletionMessage();
            message.setContent(restoredContent);
            completionChoice2.setMessage(message);
            originalChunk.setChoices(Arrays.asList(completionChoice2));
        } else if (restoredContent != null && !restoredContent.isEmpty() && (completionChoice = (CompletionChoice)originalChunk.getChoices().get(0)).getMessage() != null) {
            CompletionMessage message = completionChoice.getMessage();
            message.setContent(restoredContent);
            completionChoice.setMessage(message);
            completionChoice.setDelta(null);
        }
        return originalChunk;
    }
}

