/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.auth.requests;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.oxygenxml.positron.core.auth.ConnectionTokens;
import com.oxygenxml.positron.core.auth.ConnectionUtil;
import com.oxygenxml.positron.core.auth.data.Auth0ConnectionDetails;
import com.oxygenxml.positron.core.auth.data.Auth0User;
import com.oxygenxml.positron.core.auth.data.ConnectionDataDecoder;
import com.oxygenxml.positron.core.auth.exceptions.AuthDataExpiredException;
import com.oxygenxml.positron.core.auth.exceptions.ServerRequestException;
import com.oxygenxml.positron.core.auth.requests.BearerTokenProvider;
import com.oxygenxml.positron.core.auth.requests.RefreshTokenChangedListener;
import com.oxygenxml.positron.core.auth.requests.RefreshTokenStore;
import com.oxygenxml.positron.core.auth.requests.ServerUrlChangedListener;
import com.oxygenxml.positron.core.auth.requests.ServerUrlProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionChangedEvent;
import ro.sync.exml.workspace.api.options.WSOptionListener;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyConnectionInfo;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyDetailsProvider;

public class AuthenticationInfoManager
implements BearerTokenProvider,
ServerUrlProvider {
    private static final Logger logger = LoggerFactory.getLogger((String)AuthenticationInfoManager.class.getName());
    private static final Translator TRANSLATOR = Translator.getInstance();
    private Optional<String> accessToken = Optional.empty();
    private Auth0User user;
    private Auth0ConnectionDetails auth0ConnectionDetails;
    private RefreshTokenStore refreshTokenStore = new RefreshTokenStore();
    private ProxyDetailsProvider proxyProvider;
    private RefreshTokenChangedListener refreshTokenChangedListener;
    private List<ServerUrlChangedListener> serverUrlChangedListeners = new ArrayList<ServerUrlChangedListener>();

    public AuthenticationInfoManager(ProxyDetailsProvider proxyProvider) {
        this.proxyProvider = proxyProvider;
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (pluginWorkspace != null && pluginWorkspace.getOptionsStorage() != null) {
            pluginWorkspace.getOptionsStorage().addOptionListener(new WSOptionListener("oxygen.positron.plugin.refresh.token"){

                public void optionValueChanged(WSOptionChangedEvent arg0) {
                    if (AuthenticationInfoManager.this.refreshTokenChangedListener != null) {
                        AuthenticationInfoManager.this.refreshTokenChangedListener.refreshTokenChanged();
                    }
                }
            });
            pluginWorkspace.getOptionsStorage().addOptionListener(new WSOptionListener("oxygen.positron.plugin.positron.address"){

                public void optionValueChanged(WSOptionChangedEvent arg0) {
                    AuthenticationInfoManager.this.clear();
                    for (ServerUrlChangedListener serverUrlChangedListener : AuthenticationInfoManager.this.serverUrlChangedListeners) {
                        serverUrlChangedListener.serverUrlChanged();
                    }
                }
            });
        }
    }

    public Auth0User getUser() {
        return this.user;
    }

    public Auth0ConnectionDetails getAuth0ConnectionDetails() throws ServerRequestException {
        if (this.auth0ConnectionDetails == null) {
            String serverUrl = this.getServerUrl();
            URL authDetalsURL = null;
            if (!serverUrl.isEmpty()) {
                authDetalsURL = URLUtil.convertToURL((String)(serverUrl + "/api/authDetails"));
            }
            if (authDetalsURL == null || URLUtil.isFromLocalDrive((URL)authDetalsURL)) {
                throw new ServerRequestException(MessageFormat.format(TRANSLATOR.getTranslation("Invalid_ai_positron_service_address"), serverUrl), true);
            }
            this.auth0ConnectionDetails = this.requestForAuth0ConnectionDetails(authDetalsURL);
        }
        return this.auth0ConnectionDetails;
    }

    @Override
    public Optional<String> getAccessToken() {
        return this.accessToken;
    }

    @Override
    public String getServerUrl() {
        String serverUrl = null;
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (pluginWorkspace != null && pluginWorkspace.getOptionsStorage() != null) {
            serverUrl = pluginWorkspace.getOptionsStorage().getOption("oxygen.positron.plugin.positron.address", "https://aipositron.oxygenxml.com");
        }
        if (serverUrl == null) {
            serverUrl = "https://aipositron.oxygenxml.com";
        }
        if (serverUrl.endsWith("/") || serverUrl.endsWith("\\")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        return serverUrl;
    }

    public void storeSession(String accessToken, String refreshToken, Auth0User user) {
        this.accessToken = Optional.ofNullable(accessToken);
        this.user = user;
        if (refreshToken != null) {
            this.storeRefreshTokenInOptions(refreshToken);
        }
    }

    @Override
    public void refreshAuthentication() throws ServerRequestException {
        try {
            String connectResult = this.getRefreshRequestResponse();
            ConnectionTokens tokens = ConnectionUtil.parseConnectionServerResponse(connectResult);
            if (tokens != null) {
                this.storeSession(tokens.getAccessToken(), this.getRefreshTokenFromOptions().get(), ConnectionDataDecoder.getUserInfo(tokens.getIdToken()));
            }
        }
        catch (AuthDataExpiredException e) {
            this.clear();
            throw e;
        }
        catch (JsonProcessingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getRefreshRequestResponse() throws ServerRequestException {
        String refreshToken = this.getRefreshTokenFromOptions().orElseThrow(() -> new ServerRequestException(MessageFormat.format(TRANSLATOR.getTranslation("not_connected_message"), "Oxygen AI Positron", TRANSLATOR.getTranslation("AI_Assistant"))));
        Auth0ConnectionDetails connectionDetails = this.getAuth0ConnectionDetails();
        String auth0Url = "https://" + connectionDetails.getAuthDomain() + "/oauth/token";
        ProxyConnectionInfo proxyInfo = this.proxyProvider.getProxyConnectionInfo(URLUtil.convertToURL((String)auth0Url));
        try (CloseableHttpClient httpClient = ConnectionUtil.getHttpClientBuilder(proxyInfo).build();){
            String string;
            block14: {
                HttpPost httpPost = new HttpPost(auth0Url);
                String requestBody = String.format("{\"grant_type\":\"refresh_token\",\"client_id\":\"%s\",\"refresh_token\":\"%s\"}", connectionDetails.getClientId(), refreshToken);
                httpPost.setEntity((HttpEntity)new StringEntity(requestBody));
                httpPost.setHeader("Content-Type", "application/json");
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                try {
                    string = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (response == null) break block14;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return string;
        }
        catch (IOException e) {
            throw new ServerRequestException("Authentication failed: " + e.getMessage(), e.getCause());
        }
    }

    public Optional<String> getRefreshTokenFromOptions() {
        return this.refreshTokenStore.getRefreshTokenFromOptions();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Auth0ConnectionDetails requestForAuth0ConnectionDetails(URL authDetailsURL) throws ServerRequestException {
        ProxyConnectionInfo proxyInfo = this.proxyProvider.getProxyConnectionInfo(authDetailsURL);
        try (CloseableHttpClient httpClient = ConnectionUtil.getHttpClientBuilder(proxyInfo).build();){
            Auth0ConnectionDetails auth0ConnectionDetails;
            block17: {
                URIBuilder uriBuilder = new URIBuilder(authDetailsURL.toURI());
                HttpGet httpGet = new HttpGet(uriBuilder.build());
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                try {
                    Auth0ConnectionDetails authDetails = ConnectionDataDecoder.getAuth0ConnectionDetails(EntityUtils.toString((HttpEntity)response.getEntity()));
                    if (authDetails == null) {
                        Object message = "";
                        StatusLine statusLine = response.getStatusLine();
                        if (statusLine != null) {
                            message = String.valueOf(statusLine.getStatusCode());
                            if (statusLine.getReasonPhrase() != null && !statusLine.getReasonPhrase().isEmpty()) {
                                message = (String)message + " " + statusLine.getReasonPhrase();
                            }
                        }
                        throw new ServerRequestException(((String)message).trim());
                    }
                    auth0ConnectionDetails = authDetails;
                    if (response == null) break block17;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return auth0ConnectionDetails;
        }
        catch (IOException | URISyntaxException e) {
            throw new ServerRequestException(MessageFormat.format(TRANSLATOR.getTranslation("authentication_details_cannot_be_obtained"), authDetailsURL.getHost()) + " " + e.getMessage(), e.getCause());
        }
    }

    private void storeRefreshTokenInOptions(String refreshToken) {
        this.refreshTokenStore.storeRefreshTokenInOptions(refreshToken);
    }

    public void clear() {
        this.user = null;
        this.accessToken = Optional.empty();
        this.refreshTokenStore.clearRefreshToken();
        this.auth0ConnectionDetails = null;
    }

    public void setRefreshTokenListener(RefreshTokenChangedListener listener) {
        this.refreshTokenChangedListener = listener;
    }

    @Override
    public void addServerUrlChangedListener(ServerUrlChangedListener serverUrlChangedListener) {
        this.serverUrlChangedListeners.add(serverUrlChangedListener);
    }

    public boolean isConnected() {
        Optional<String> theAccessToken = this.getAccessToken();
        return theAccessToken.isPresent() && !theAccessToken.get().isEmpty();
    }

    @Override
    public boolean isAccountVerified() {
        return this.user != null && this.user.isAccountVerified();
    }
}

