/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.auth.data;

import com.auth0.jwt.JWT;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.core.auth.data.Auth0ConnectionDetails;
import com.oxygenxml.positron.core.auth.data.Auth0User;
import java.io.IOException;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionDataDecoder {
    private static final Logger logger = LoggerFactory.getLogger((String)ConnectionDataDecoder.class.getName());

    private ConnectionDataDecoder() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static Auth0User getUserInfo(String idToken) {
        try {
            DecodedJWT decodedJWT = JWT.decode((String)idToken);
            return (Auth0User)new ObjectMapper().readValue(Base64.getUrlDecoder().decode(decodedJWT.getPayload()), Auth0User.class);
        }
        catch (JWTDecodeException | IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Could not extract user info.", e);
            }
            return null;
        }
    }

    public static Auth0ConnectionDetails getAuth0ConnectionDetails(String connectionDetails) {
        try {
            return (Auth0ConnectionDetails)new ObjectMapper().readValue(connectionDetails, Auth0ConnectionDetails.class);
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Could not extract Auth0 connection details.", (Throwable)e);
            }
            return null;
        }
    }
}

