/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.auth;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.core.auth.BrowserOpener;
import com.oxygenxml.positron.core.auth.ConnectionRequestInteractor;
import com.oxygenxml.positron.core.auth.ConnectionTokens;
import com.oxygenxml.positron.core.auth.ConnectionUtil;
import com.oxygenxml.positron.core.auth.DeviceCodeInfo;
import com.oxygenxml.positron.core.auth.DisconnectionRequestListener;
import com.oxygenxml.positron.core.auth.ReconnectionRequestListener;
import com.oxygenxml.positron.core.auth.ResendAccountVerificationEmailRequest;
import com.oxygenxml.positron.core.auth.ServerAuthenticationManager;
import com.oxygenxml.positron.core.auth.data.Auth0ConnectionDetails;
import com.oxygenxml.positron.core.auth.data.Auth0User;
import com.oxygenxml.positron.core.auth.data.ConnectionDataDecoder;
import com.oxygenxml.positron.core.auth.exceptions.AuthDataExpiredException;
import com.oxygenxml.positron.core.auth.exceptions.ServerRequestException;
import com.oxygenxml.positron.core.auth.requests.AuthenticationInfoManager;
import com.oxygenxml.positron.core.plugin.Translator;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyConnectionInfo;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyDetailsProvider;

public class ServerAuthenticationManagerImpl
implements ServerAuthenticationManager {
    private static final String UTF_8 = StandardCharsets.UTF_8.name();
    private static final Logger logger = LoggerFactory.getLogger((String)ServerAuthenticationManagerImpl.class.getName());
    private AuthenticationInfoManager authenticationManager;
    private final Thread[] lastConnectionThread = new Thread[1];
    private ProxyDetailsProvider proxyProvider;
    private BrowserOpener browserOpener;

    public ServerAuthenticationManagerImpl(AuthenticationInfoManager authenticationManager, BrowserOpener browserOpener, ProxyDetailsProvider proxyProvider) {
        this.authenticationManager = authenticationManager;
        this.browserOpener = browserOpener;
        this.proxyProvider = proxyProvider;
    }

    @Override
    public void refreshConnectionIfPossible(ReconnectionRequestListener reconnectionRequestListener, int delay) {
        Optional<String> refreshToken = this.authenticationManager.getRefreshTokenFromOptions();
        if (refreshToken.isPresent()) {
            this.lastConnectionThread[0] = new Thread(() -> this.reconnectOnCurrentThread(reconnectionRequestListener, delay));
            this.lastConnectionThread[0].start();
        } else {
            reconnectionRequestListener.reconnectTokenNotAvailable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconnectOnCurrentThread(ReconnectionRequestListener reconnectionRequestListener, int delay) {
        try {
            Thread.sleep(delay);
            reconnectionRequestListener.beforeRequestStarted();
            this.authenticationManager.refreshAuthentication();
            if (this.authenticationManager.isConnected()) {
                String userName = Optional.ofNullable(this.authenticationManager.getUser()).map(Auth0User::getDisplayName).orElse("");
                reconnectionRequestListener.reconnected(userName);
            }
        }
        catch (AuthDataExpiredException e) {
            reconnectionRequestListener.reconnectTokenExpired();
        }
        catch (ServerRequestException e) {
            reconnectionRequestListener.requestFailed(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (logger.isDebugEnabled()) {
                logger.debug("Reconnecting thread interrupted: " + e.getMessage(), (Throwable)e);
            }
        }
        finally {
            reconnectionRequestListener.requestEnded();
        }
    }

    @Override
    public void connect(ConnectionRequestInteractor connectionListener) {
        this.lastConnectionThread[0] = new Thread(() -> this.connectOnCurrentThread(connectionListener));
        this.lastConnectionThread[0].start();
    }

    void connectOnCurrentThread(ConnectionRequestInteractor connectionRequestInteractor) {
        block9: {
            connectionRequestInteractor.beforeRequestStarted();
            try {
                Optional<String> refreshToken = this.authenticationManager.getRefreshTokenFromOptions();
                if (!refreshToken.isPresent()) {
                    this.connectForTokens(connectionRequestInteractor);
                } else {
                    this.tryRefreshingAuthentication(connectionRequestInteractor);
                }
                if (this.authenticationManager.isConnected()) {
                    connectionRequestInteractor.connected(Optional.ofNullable(this.authenticationManager.getUser()).map(Auth0User::getDisplayName).orElse(""));
                    break block9;
                }
                throw new ServerRequestException(Translator.getInstance().getTranslation("exception_cannot_obtain_login_data_from_server"));
            }
            catch (ServerRequestException e) {
                logger.debug(e.getMessage(), (Throwable)e);
                if (!Thread.currentThread().isInterrupted()) {
                    connectionRequestInteractor.requestFailed(e);
                }
            }
            finally {
                connectionRequestInteractor.requestEnded();
            }
        }
    }

    private void tryRefreshingAuthentication(ConnectionRequestInteractor connectionRequestInteractor) throws ServerRequestException {
        try {
            this.authenticationManager.refreshAuthentication();
        }
        catch (AuthDataExpiredException e) {
            this.connectForTokens(connectionRequestInteractor);
        }
    }

    private void connectForTokens(ConnectionRequestInteractor connectionRequestInteractor) throws ServerRequestException {
        DeviceCodeInfo deviceCode = this.getDeviceCode();
        if (!Thread.currentThread().isInterrupted() && deviceCode != null && deviceCode.getVerificationUri() != null) {
            connectionRequestInteractor.showUserCode(deviceCode.getUserCode());
            if (logger.isDebugEnabled()) {
                logger.debug("Opening the following link in browser: {}", (Object)deviceCode.getVerificationUri());
            }
            this.browserOpener.openWebpage(deviceCode.getVerificationUri());
            ConnectionTokens tokens = null;
            if (!Thread.currentThread().isInterrupted()) {
                tokens = this.pollForConnectionTokens(deviceCode);
            }
            if (!Thread.currentThread().isInterrupted() && tokens != null) {
                Auth0User userInfo = ConnectionDataDecoder.getUserInfo(tokens.getIdToken());
                this.authenticationManager.storeSession(tokens.getAccessToken(), tokens.getRefreshToken(), userInfo);
            }
        }
    }

    protected ConnectionTokens pollForConnectionTokens(DeviceCodeInfo deviceCode) throws ServerRequestException {
        ConnectionTokens toRet = null;
        Auth0ConnectionDetails connectionDetails = this.authenticationManager.getAuth0ConnectionDetails();
        String tokenUrl = "https://" + connectionDetails.getAuthDomain() + "/oauth/token";
        String postData = this.getPostDataForConnectionPolling(connectionDetails, deviceCode);
        ProxyConnectionInfo proxyInfo = this.proxyProvider.getProxyConnectionInfo(URLUtil.convertToURL((String)tokenUrl));
        int sleepInterval = deviceCode.getIntervals() * 1000;
        int totalSleepInterval = 0;
        int expireTime = deviceCode.getExpiresIn() * 1000;
        while (totalSleepInterval < expireTime) {
            try {
                Thread.sleep(sleepInterval);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
                break;
            }
            totalSleepInterval += sleepInterval;
            if (Thread.currentThread().isInterrupted()) break;
            try {
                CloseableHttpClient httpClient = ConnectionUtil.getHttpClientBuilder(proxyInfo).build();
                try {
                    HttpPost httpPost = new HttpPost(tokenUrl);
                    httpPost.setEntity((HttpEntity)new StringEntity(postData));
                    httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
                    httpPost.setHeader("charset", UTF_8);
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                    try {
                        ObjectMapper objectMapper;
                        Map responseMap;
                        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                        if (logger.isDebugEnabled()) {
                            logger.debug("Polling request response: {}", (Object)(responseBody.contains("access_token") ? "HIDDEN_TOKENS" : responseBody));
                        }
                        if ((responseMap = (Map)(objectMapper = new ObjectMapper()).readValue(responseBody, Map.class)).containsKey("error")) {
                            if ("authorization_pending".equals(responseMap.get("error"))) continue;
                            if ("slow_down".equals(responseMap.get("error"))) {
                                sleepInterval += 1000;
                                continue;
                            }
                            if ("expired_token".equals(responseMap.get("error"))) {
                                throw new ServerRequestException(Translator.getInstance().getTranslation("connection_time_expired"));
                            }
                            if (!"access_denied".equals(responseMap.get("error"))) continue;
                            throw new ServerRequestException(Translator.getInstance().getTranslation("access_denied"));
                        }
                        if (!responseMap.containsKey("access_token")) continue;
                        logger.debug("Polling request contains access token");
                        toRet = new ConnectionTokens((String)responseMap.get("id_token"), (String)responseMap.get("access_token"), (String)responseMap.get("refresh_token"));
                        break;
                    }
                    finally {
                        if (response == null) continue;
                        response.close();
                    }
                }
                finally {
                    if (httpClient == null) continue;
                    httpClient.close();
                }
            }
            catch (ServerRequestException ex) {
                throw ex;
            }
            catch (IOException e) {
                throw new ServerRequestException(e.getMessage(), e.getCause());
            }
        }
        if (toRet == null && totalSleepInterval >= expireTime) {
            throw new ServerRequestException(Translator.getInstance().getTranslation("connection_time_expired"));
        }
        return toRet;
    }

    private String getPostDataForConnectionPolling(Auth0ConnectionDetails connectionDetails, DeviceCodeInfo deviceCodeInfo) {
        StringBuilder postData = new StringBuilder("grant_type=urn%3Aietf%3Aparams%3Aoauth%3Agrant-type%3Adevice_code");
        try {
            postData.append("&device_code=").append(URLEncoder.encode(deviceCodeInfo.getDeviceCode(), UTF_8));
            postData.append("&client_id=" + URLEncoder.encode(connectionDetails.getClientId(), UTF_8));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return postData.toString();
    }

    @Override
    public void disconnect(DisconnectionRequestListener listener) {
        new Thread(() -> {
            block20: {
                listener.beforeRequestStarted();
                try {
                    if (this.authenticationManager.getRefreshTokenFromOptions().isPresent()) {
                        Auth0ConnectionDetails connectionDetails = this.authenticationManager.getAuth0ConnectionDetails();
                        String auth0Url = "https://" + connectionDetails.getAuthDomain() + "/oauth/revoke";
                        ProxyConnectionInfo proxyInfo = this.proxyProvider.getProxyConnectionInfo(URLUtil.convertToURL((String)auth0Url));
                        try (CloseableHttpClient httpClient = ConnectionUtil.getHttpClientBuilder(proxyInfo).build();){
                            HttpPost httpPost = new HttpPost(auth0Url);
                            String requestBody = String.format("{\"client_id\":\"%s\",\"token\":\"%s\"}", connectionDetails.getClientId(), this.authenticationManager.getRefreshTokenFromOptions().get());
                            httpPost.setEntity((HttpEntity)new StringEntity(requestBody));
                            httpPost.setHeader("Content-Type", "application/json");
                            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                                this.authenticationManager.clear();
                                listener.disconnected();
                                break block20;
                            }
                        }
                    }
                    this.authenticationManager.clear();
                    listener.disconnected();
                }
                catch (ServerRequestException e) {
                    logger.debug((Object)e, (Throwable)e);
                    listener.requestFailed(e);
                }
                catch (IOException e) {
                    logger.debug((Object)e, (Throwable)e);
                    ServerRequestException ex = new ServerRequestException(e.getMessage());
                    ex.initCause(e);
                    listener.requestFailed(ex);
                }
                finally {
                    this.authenticationManager.clear();
                    listener.requestEnded();
                }
            }
        }).start();
    }

    @Override
    public boolean cancelConnection() {
        boolean connectionCancelled = false;
        if (this.lastConnectionThread[0] != null && !this.lastConnectionThread[0].isInterrupted()) {
            this.lastConnectionThread[0].interrupt();
            this.lastConnectionThread[0] = null;
            connectionCancelled = true;
        }
        return connectionCancelled;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    DeviceCodeInfo getDeviceCode() throws ServerRequestException {
        Auth0ConnectionDetails connectionDetails = this.authenticationManager.getAuth0ConnectionDetails();
        String auth0Url = "https://" + connectionDetails.getAuthDomain() + "/oauth/device/code";
        ProxyConnectionInfo proxyInfo = this.proxyProvider.getProxyConnectionInfo(URLUtil.convertToURL((String)auth0Url));
        try (CloseableHttpClient httpClient = ConnectionUtil.getHttpClientBuilder(proxyInfo).build();){
            DeviceCodeInfo deviceCodeInfo;
            block15: {
                HttpPost httpPost = new HttpPost(auth0Url);
                String postData = "client_id=" + URLEncoder.encode(connectionDetails.getClientId(), UTF_8) + "&scope=offline_access+openid+email+profile" + URLEncoder.encode(connectionDetails.getApiScope(), UTF_8) + "&audience=" + URLEncoder.encode(connectionDetails.getApiAudience(), UTF_8);
                httpPost.setEntity((HttpEntity)new StringEntity(postData));
                httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded");
                httpPost.setHeader("charset", UTF_8);
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                try {
                    String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                    if (logger.isDebugEnabled()) {
                        logger.debug("Response when requesting device code: {}", (Object)responseBody);
                    }
                    deviceCodeInfo = ConnectionUtil.parseResponseForDeviceCodeInfo(responseBody);
                    if (response == null) break block15;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return deviceCodeInfo;
        }
        catch (IOException e) {
            throw new ServerRequestException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public void resendVerificationEmail() throws ServerRequestException {
        ResendAccountVerificationEmailRequest resendAccountVerificationEmailRequest = new ResendAccountVerificationEmailRequest(this.authenticationManager.getServerUrl(), this.authenticationManager.getAccessToken(), this.proxyProvider);
        resendAccountVerificationEmailRequest.resendEmailVerification();
    }
}

