/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.auth;

import com.oxygenxml.positron.core.auth.ConnectionUtil;
import com.oxygenxml.positron.core.auth.exceptions.ServerRequestException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyConnectionInfo;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyDetailsProvider;

public class ResendAccountVerificationEmailRequest {
    private static final List<Integer> VALID_RESPONSES = Arrays.asList(200, 201, 202);
    private static final String RESEND_EMAIL_ENDPOINT = "%s/api/users/resendEmail";
    private String serverUrl;
    private Optional<String> acceessToken;
    private ProxyDetailsProvider proxyProvider;

    public ResendAccountVerificationEmailRequest(String serverUrl, Optional<String> acceessToken, ProxyDetailsProvider proxyProvider) {
        this.serverUrl = serverUrl;
        this.acceessToken = acceessToken;
        this.proxyProvider = proxyProvider;
    }

    public void resendEmailVerification() throws ServerRequestException {
        String resendEmailEndpoint = String.format(RESEND_EMAIL_ENDPOINT, this.serverUrl);
        ProxyConnectionInfo proxyInfo = this.proxyProvider.getProxyConnectionInfo(URLUtil.convertToURL((String)resendEmailEndpoint));
        try (CloseableHttpClient httpClient = ConnectionUtil.getHttpClientBuilder(proxyInfo).build();){
            HttpPost http = new HttpPost(resendEmailEndpoint);
            http.setHeader("Authorization", "Bearer " + this.acceessToken.get());
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)http);
            if (!VALID_RESPONSES.contains(response.getStatusLine().getStatusCode())) {
                throw new ServerRequestException("Unable to send account verification email.");
            }
        }
        catch (IOException e) {
            throw new ServerRequestException("Unable to send account verification email.", e);
        }
    }
}

