/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.auth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.core.auth.AcceptAllCertificatesProtocolSocketFactory;
import com.oxygenxml.positron.core.auth.ConnectionTokens;
import com.oxygenxml.positron.core.auth.DeviceCodeInfo;
import com.oxygenxml.positron.core.auth.exceptions.AuthDataExpiredException;
import com.oxygenxml.positron.core.auth.exceptions.ServerRequestException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyConnectionInfo;

public class ConnectionUtil {
    public static final String ERROR = "error";
    private static final Logger logger = LoggerFactory.getLogger((String)ConnectionUtil.class.getName());

    private ConnectionUtil() {
    }

    public static ConnectionTokens parseConnectionServerResponse(String responseBody) throws ServerRequestException, JsonProcessingException {
        ConnectionTokens toRet = null;
        ObjectMapper objectMapper = new ObjectMapper();
        Map responseMap = (Map)objectMapper.readValue(responseBody, Map.class);
        if (responseMap.containsKey(ERROR)) {
            String errorMessage = "Authentication failed";
            if (responseMap.containsKey("error_description")) {
                errorMessage = (String)responseMap.get("error_description");
            }
            ServerRequestException exception = new ServerRequestException(errorMessage);
            if ("invalid_grant".equals(responseMap.get(ERROR)) || "unauthorized_client".equals(responseMap.get(ERROR)) || "access_denied".equals(responseMap.get(ERROR))) {
                throw new AuthDataExpiredException(exception);
            }
            throw exception;
        }
        if (responseMap.containsKey("id_token")) {
            toRet = new ConnectionTokens((String)responseMap.get("id_token"), (String)responseMap.get("access_token"), (String)responseMap.get("refresh_token"));
        }
        return toRet;
    }

    public static DeviceCodeInfo parseResponseForDeviceCodeInfo(String responseBody) throws ServerRequestException, JsonProcessingException {
        DeviceCodeInfo toRet = null;
        ObjectMapper objectMapper = new ObjectMapper();
        Map responseMap = (Map)objectMapper.readValue(responseBody, Map.class);
        if (responseMap.containsKey(ERROR)) {
            String errorMessage = "Authentication failed";
            if (responseMap.containsKey("error_description")) {
                errorMessage = (String)responseMap.get("error_description");
            }
            throw new ServerRequestException(errorMessage);
        }
        if (responseMap.containsKey("device_code")) {
            toRet = new DeviceCodeInfo((String)responseMap.get("device_code"), (String)responseMap.get("user_code"), (String)responseMap.get("verification_uri_complete"), (Integer)responseMap.get("expires_in"), (Integer)responseMap.get("interval"));
        }
        return toRet;
    }

    public static HttpClientBuilder getHttpClientBuilder(ProxyConnectionInfo proxyInfo) {
        Registry<ConnectionSocketFactory> allowAllCertsRegistry;
        HttpClientBuilder httpBuilder = HttpClients.custom().setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build());
        if (proxyInfo != null) {
            try {
                HttpHost httpHost = new HttpHost(InetAddress.getByName(proxyInfo.getHost()), proxyInfo.getPort());
                httpBuilder = httpBuilder.setProxy(httpHost);
            }
            catch (UnknownHostException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        if ((allowAllCertsRegistry = ConnectionUtil.buildAllowAllCertsRegistry()) != null) {
            PoolingHttpClientConnectionManager allowAllConnectionManager = new PoolingHttpClientConnectionManager(allowAllCertsRegistry);
            httpBuilder.setConnectionManager((HttpClientConnectionManager)allowAllConnectionManager);
        }
        return httpBuilder;
    }

    public static Registry<ConnectionSocketFactory> buildAllowAllCertsRegistry() {
        PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (pluginWorkspace != null) {
            boolean allowCerts;
            Object allowAllCerts = pluginWorkspace.getGlobalObjectProperty("automatically.accept.certificates");
            boolean bl = allowCerts = allowAllCerts != null && allowAllCerts instanceof Boolean && (Boolean)allowAllCerts != false;
            if (allowCerts) {
                try {
                    AcceptAllCertificatesProtocolSocketFactory socketFactory = new AcceptAllCertificatesProtocolSocketFactory();
                    RegistryBuilder registryBuilder = RegistryBuilder.create();
                    registryBuilder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
                    registryBuilder.register("https", (Object)socketFactory);
                    return registryBuilder.build();
                }
                catch (Exception e) {
                    logger.error((Object)e, (Throwable)e);
                }
            }
        }
        return null;
    }
}

