/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.api;

import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.core.OxyHttpClientExtraConfigProvider;
import com.oxygenxml.positron.core.auth.requests.AuthenticationInfoManager;
import com.oxygenxml.positron.core.auth.requests.ServerUrlChangedListener;
import com.oxygenxml.positron.core.service.PositronService;
import com.oxygenxml.positron.core.service.config.UserAgentInfo;
import com.oxygenxml.positron.core.util.AIModelsUtil;
import com.oxygenxml.positron.utilities.AIProviderConstants;
import com.oxygenxml.positron.utilities.json.Engine;
import com.oxygenxml.positron.utilities.models.CompletedModelDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyDetailsProvider;

public class PositronServiceModelsManager {
    private static final Logger log = LoggerFactory.getLogger(PositronServiceModelsManager.class);
    private final AuthenticationInfoManager authenticationInfoManager;
    private PositronService positronService;
    private List<CompletedModelDTO> loadedModels = null;
    private final List<ModelsChangedListener> modelsChangedListeners = new ArrayList<ModelsChangedListener>();
    private Engine defaultEngine = AIProviderConstants.DEFAULT_POSTRON_SERVICE_ENGINE;

    public PositronServiceModelsManager(final AuthenticationInfoManager authenticationInfoManager, final UserAgentInfo userAgentInfo) {
        this.authenticationInfoManager = authenticationInfoManager;
        StandalonePluginWorkspace pluginWorkspace = (StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
        ProxyDetailsProvider proxyDetailsProvider = pluginWorkspace.getProxyDetailsProvider();
        final OxyHttpClientExtraConfigProvider httpClientExtraConfigProvider = new OxyHttpClientExtraConfigProvider(proxyDetailsProvider);
        this.positronService = new PositronService(authenticationInfoManager.getServerUrl(), authenticationInfoManager, httpClientExtraConfigProvider, userAgentInfo);
        authenticationInfoManager.addServerUrlChangedListener(new ServerUrlChangedListener(){

            @Override
            public void serverUrlChanged() {
                PositronServiceModelsManager.this.positronService = new PositronService(authenticationInfoManager.getServerUrl(), authenticationInfoManager, httpClientExtraConfigProvider, userAgentInfo);
            }
        });
    }

    PositronServiceModelsManager(AuthenticationInfoManager authenticationInfoManager, PositronService positronService) {
        this.authenticationInfoManager = authenticationInfoManager;
        this.positronService = positronService;
    }

    public void addModelsChangedListener(ModelsChangedListener listener) {
        if (listener != null && !this.modelsChangedListeners.contains(listener)) {
            this.modelsChangedListeners.add(listener);
        }
    }

    public void removeModelsChangedListener(ModelsChangedListener listener) {
        this.modelsChangedListeners.remove(listener);
    }

    private void notifyModelsChanged() {
        for (ModelsChangedListener listener : this.modelsChangedListeners) {
            try {
                listener.modelsChanged();
            }
            catch (Exception e) {
                log.error("Error notifying models changed listener", (Throwable)e);
            }
        }
    }

    public void loadModels() {
        Thread loader = new Thread(this::doLoadModels);
        loader.start();
    }

    void doLoadModels() {
        try {
            if (!this.authenticationInfoManager.isConnected()) {
                log.debug("Not connected to Positron service, clearing models list");
                this.loadedModels = Collections.emptyList();
            } else {
                this.loadedModels = this.positronService.getModels();
                log.debug("Successfully loaded {} models from Positron service", (Object)(this.loadedModels != null ? this.loadedModels.size() : 0));
                this.updateDefaultModelFromLoadedModels();
            }
            this.notifyModelsChanged();
        }
        catch (Exception e) {
            log.error("Failed to load models from Positron service: {}", (Object)e.getMessage(), (Object)e);
            this.loadedModels = Collections.emptyList();
            this.notifyModelsChanged();
        }
    }

    private void updateDefaultModelFromLoadedModels() {
        if (this.loadedModels == null || this.loadedModels.isEmpty()) {
            return;
        }
        Optional<CompletedModelDTO> defaultModelOpt = this.loadedModels.stream().filter(model -> Boolean.TRUE.equals(model.getIsDefault())).findFirst();
        if (defaultModelOpt.isPresent()) {
            CompletedModelDTO defaultModel = defaultModelOpt.get();
            String modelId = defaultModel.getModelID();
            log.debug("Found default model from API: {}", (Object)modelId);
            this.defaultEngine = new Engine(modelId);
            log.debug("Updated default model to: {}", (Object)modelId);
        } else {
            log.debug("No default model found in API response, keeping existing defaults");
        }
    }

    public Map<String, List<ModelDescriptor>> getGroupedModelsForUI() {
        if (this.loadedModels == null || this.loadedModels.isEmpty()) {
            log.debug("No models loaded, returning empty map");
            return Collections.emptyMap();
        }
        ArrayList<CompletedModelDTO> modelDTOList = new ArrayList<CompletedModelDTO>(this.loadedModels);
        return AIModelsUtil.getGroupedModelsForUI(modelDTOList, this.defaultEngine, true);
    }

    public Engine getDefaultEngine() {
        return this.defaultEngine;
    }

    public static interface ModelsChangedListener {
        public void modelsChanged();
    }
}

