/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.ResponseFormatDTO;
import com.oxygenxml.positron.api.connector.dto.Tool;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import com.oxygenxml.positron.utilities.functions.IDisabledToolsChecker;
import com.oxygenxml.positron.utilities.functions.IFunctionSignaturesRepository;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExecutableAction {
    private List<Message> messages;
    private AIActionDetails actionDetails;
    private Map<String, String> parameters;
    private boolean stream;
    private List<Tool> tools;
    @JsonProperty(value="response_format")
    private ResponseFormatDTO responseFormat;

    public ExecutableAction(List<Message> messages, Map<String, String> parameters, AIActionDetails actionDetails) {
        this.messages = messages;
        this.parameters = parameters;
        this.actionDetails = actionDetails;
    }

    public void setFunctionsToUse(IFunctionSignaturesRepository functionsRepo) {
        this.setFunctionsToUse(functionsRepo, null);
    }

    public void setFunctionsToUse(IFunctionSignaturesRepository functionsRepo, IDisabledToolsChecker disabledToolsChecker) {
        this.tools = AIRequestUtil.expandFunctionReferences((List)this.actionDetails.getParameters().getFunctionRefs(), (IFunctionSignaturesRepository)functionsRepo, (String)this.actionDetails.getId(), (IDisabledToolsChecker)disabledToolsChecker);
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public AIActionDetails getActionDetails() {
        return this.actionDetails;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean isStream() {
        return this.stream;
    }

    public List<Tool> getTools() {
        return this.tools;
    }

    public ResponseFormatDTO getResponseFormat() {
        return this.responseFormat;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public void setActionDetails(AIActionDetails actionDetails) {
        this.actionDetails = actionDetails;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void setTools(List<Tool> tools) {
        this.tools = tools;
    }

    public String toString() {
        return "ExecutableAction(messages=" + this.getMessages() + ", actionDetails=" + this.getActionDetails() + ", parameters=" + this.getParameters() + ", stream=" + this.isStream() + ", tools=" + this.getTools() + ", responseFormat=" + this.getResponseFormat() + ")";
    }

    public ExecutableAction() {
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    @JsonProperty(value="response_format")
    public void setResponseFormat(ResponseFormatDTO responseFormat) {
        this.responseFormat = responseFormat;
    }
}

