/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.aiignore;

import com.oxygenxml.positron.core.aiignore.AiIgnoreManager;
import com.oxygenxml.positron.core.aiignore.RegExpUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class StandaloneAiIgnoreManager
implements AiIgnoreManager {
    private static final Logger log = LoggerFactory.getLogger(StandaloneAiIgnoreManager.class);
    private static final String AI_IGNORE_FILE = ".ai-ignore";

    @Override
    public boolean isIgnoredFromAiIgnoreFile(URL resourceToCheck) {
        File absoluteFile;
        boolean isIgnored = false;
        if (resourceToCheck != null && (absoluteFile = URLUtil.getAbsoluteFileFromFileUrl((URL)resourceToCheck)) != null && !absoluteFile.isDirectory()) {
            isIgnored = this.checkParentDirectoriesForIgnoreRule(absoluteFile, resourceToCheck);
        }
        return isIgnored;
    }

    private boolean checkParentDirectoriesForIgnoreRule(File file, URL resourceToCheck) {
        for (File parentFile = file.getParentFile(); parentFile != null && parentFile.isDirectory(); parentFile = parentFile.getParentFile()) {
            File aiIgnoreFile = this.getAiIgnoreFile(parentFile);
            if (aiIgnoreFile == null || !this.matchesIgnoreRules(aiIgnoreFile, resourceToCheck)) continue;
            return true;
        }
        return false;
    }

    private File getAiIgnoreFile(File directory) {
        File aiIgnoreFile = new File(directory, AI_IGNORE_FILE);
        if (aiIgnoreFile.isFile()) {
            return aiIgnoreFile;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean matchesIgnoreRules(File aiIgnoreFile, URL resourceToCheck) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(aiIgnoreFile), StandardCharsets.UTF_8));){
            String line;
            String relativePath = URLUtil.uncorrect((String)URLUtil.makeRelative((URL)URLUtil.correct((File)aiIgnoreFile), (URL)resourceToCheck));
            do {
                if ((line = reader.readLine()) == null) return false;
            } while (!this.isValidIgnoreRule(line) || !this.isMatch(line.trim(), relativePath, resourceToCheck));
            boolean bl = true;
            return bl;
        }
        catch (IOException | PatternSyntaxException e) {
            this.logError(aiIgnoreFile, e);
        }
        return false;
    }

    private boolean isValidIgnoreRule(String line) {
        return line != null && !line.trim().isEmpty() && !line.trim().startsWith("#");
    }

    private boolean isMatch(String rule, String relativePath, URL resourceToCheck) {
        String input = rule.startsWith("*") ? resourceToCheck.toExternalForm() : relativePath;
        Pattern pattern = Pattern.compile(RegExpUtil.convertWildcardToRegexp(rule, true));
        return pattern.matcher(input).matches();
    }

    private void logError(File aiIgnoreFile, Exception e) {
        if (log.isDebugEnabled()) {
            log.debug((Object)e, (Throwable)e);
        }
        log.error("Cannot read content of ai-ignore file: " + URLUtil.clearUserInfo((String)aiIgnoreFile.toURI().toASCIIString()));
    }

    @Override
    public void addToAiIgnore(List<URL> resourcesToAdd) {
        if (resourcesToAdd != null && !resourcesToAdd.isEmpty()) {
            for (URL url : resourcesToAdd) {
                File absoluteFile = URLUtil.getAbsoluteFileFromFileUrl((URL)url);
                if (absoluteFile == null) continue;
                this.addResourceToIgnoreFile(absoluteFile, url);
            }
        }
    }

    private void addResourceToIgnoreFile(File file, URL url) {
        File parentDirectory = file.getParentFile();
        if (parentDirectory != null && parentDirectory.exists()) {
            Path aiIgnoreFilePath = Optional.ofNullable(this.getAiIgnoreFile(parentDirectory)).map(File::toPath).orElse(Paths.get(new File(parentDirectory, AI_IGNORE_FILE).toURI()));
            Object ruleToAdd = file.isDirectory() ? file.getName() + "/*" : URLUtil.extractFileName((String)URLUtil.uncorrect((String)url.toExternalForm()));
            try {
                this.appendToIgnoreFile(aiIgnoreFilePath, (String)ruleToAdd);
                this.openAiIgnoreFileInEditor(aiIgnoreFilePath);
            }
            catch (MalformedURLException e) {
                log.error("Failed to open .ai-ignore file in editor: " + aiIgnoreFilePath, (Throwable)e);
            }
            catch (IOException e) {
                log.error("Cannot write to .ai-ignore file: " + aiIgnoreFilePath, (Throwable)e);
            }
        } else {
            log.error("Unable to handle ai-ignore files for parent dir: " + parentDirectory, (Throwable)new Exception());
        }
    }

    private void appendToIgnoreFile(Path ignoreFilePath, String rule) throws IOException {
        if (ignoreFilePath.toFile().exists() && Files.size(ignoreFilePath) > 0L) {
            rule = System.lineSeparator() + (String)rule;
        }
        Files.write(ignoreFilePath, ((String)rule).getBytes(StandardCharsets.UTF_8), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
    }

    private void openAiIgnoreFileInEditor(Path ignoreFilePath) throws MalformedURLException {
        PluginWorkspace workspace = PluginWorkspaceProvider.getPluginWorkspace();
        if (workspace != null) {
            workspace.open(ignoreFilePath.toUri().toURL(), null, "text/plain");
        }
    }
}

