/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions.types;

import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.MessageContent;
import com.oxygenxml.positron.api.connector.dto.MessageTextContent;
import com.oxygenxml.positron.api.connector.dto.RoleType;
import com.oxygenxml.positron.core.AICompletionProviderResolver;
import com.oxygenxml.positron.core.actions.MessagePresenter;
import com.oxygenxml.positron.core.actions.OperationSemaphoreHandler;
import com.oxygenxml.positron.core.actions.types.ActionSpecificParamsExpandingException;
import com.oxygenxml.positron.core.actions.types.BaseActionInteractor;
import com.oxygenxml.positron.core.actions.types.InvalidFileUsedForDocDraftConfigurationException;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.actions.types.RequestMessagesCreationException;
import com.oxygenxml.positron.core.actions.types.UsableContentProcessingException;
import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.interactions.IDocumentCreator;
import com.oxygenxml.positron.core.progress.OperationProgressPresenter;
import com.oxygenxml.positron.core.util.attach.MessageAttachmentUtils;
import com.oxygenxml.positron.utilities.json.ActionParam;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ro.sync.basic.io.IOUtil;
import ro.sync.util.editorvars.EditorVariables;

public class PositronDocumentationDraftAction
extends PositronAIActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PositronDocumentationDraftAction.class.getName());
    private static final String XML_DECLARATION = "xml-declaration";
    private static final String HTTP_APACHE_ORG_XML_FEATURES_DISALLOW_DOCTYPE_DECL = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String USE_RELATED_CONTENT_FROM_PROJECT = "use-related-content-from-project";
    private Document docDraftModel;
    protected IDocumentCreator documentCreator;

    public PositronDocumentationDraftAction(BaseActionInteractor actionInteractor, AICompletionProviderResolver completionProviderResolver, MessagePresenter messagePresenter, ChatInteractor chatInteractor, OperationSemaphoreHandler operationSemaphoreHandler, OperationProgressPresenter progressPresenter, IDocumentCreator documentCreator) {
        super(actionInteractor, completionProviderResolver, messagePresenter, chatInteractor, operationSemaphoreHandler, progressPresenter);
        this.documentCreator = documentCreator;
    }

    @Override
    protected void processUsableContent(String content) throws UsableContentProcessingException {
        boolean isDocDraftConfigFile;
        Optional<String> frameworkName = this.completionInserter.getDocumentTypeName();
        boolean bl = isDocDraftConfigFile = frameworkName.isPresent() && frameworkName.get().equals("AI Positron Documentation Draft Generation Configuration");
        if (isDocDraftConfigFile) {
            try {
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                docBuilderFactory.setFeature(HTTP_APACHE_ORG_XML_FEATURES_DISALLOW_DOCTYPE_DECL, true);
                InputSource inputSource = new InputSource(new StringReader(content));
                this.docDraftModel = docBuilderFactory.newDocumentBuilder().parse(inputSource);
                Element documentElement = this.docDraftModel.getDocumentElement();
                documentElement.normalize();
            }
            catch (IOException | ParserConfigurationException | SAXException ex) {
                throw new UsableContentProcessingException(ex);
            }
        } else {
            throw new UsableContentProcessingException(new InvalidFileUsedForDocDraftConfigurationException());
        }
    }

    @Override
    protected List<Message> createRequestMessage() throws RequestMessagesCreationException {
        Node instructionsNode;
        NodeList instructionsNodeList;
        String draftSummaryText;
        ArrayList<Message> messages = new ArrayList<Message>();
        NodeList draftSummaryNodeList = this.docDraftModel.getElementsByTagName("draft-summary");
        if (draftSummaryNodeList.getLength() > 0 && !(draftSummaryText = PositronDocumentationDraftAction.serializeNodeContent(draftSummaryNodeList.item(0))).isBlank()) {
            messages.add(new Message(RoleType.USER, (MessageContent)new MessageTextContent(draftSummaryText)));
        }
        if ((instructionsNodeList = this.docDraftModel.getElementsByTagName("instructions")).getLength() > 0) {
            instructionsNode = instructionsNodeList.item(0);
            if (PositronDocumentationDraftAction.isEmptyNode(instructionsNode)) {
                throw new RequestMessagesCreationException("The <instructions> element must not be empty.");
            }
        } else {
            throw new RequestMessagesCreationException("The <instructions> element is required.");
        }
        PositronDocumentationDraftAction.addInstructionsMessage(messages, instructionsNode);
        return messages;
    }

    private static void addInstructionsMessage(List<Message> messages, Node instructionsNode) throws RequestMessagesCreationException {
        ArrayList<MessageContent> contents = new ArrayList<MessageContent>();
        NodeList childNodes = instructionsNode.getChildNodes();
        int noOfChildren = childNodes.getLength();
        for (int i = 0; i < noOfChildren; ++i) {
            try {
                PositronDocumentationDraftAction.addInstructionMessagePart(contents, childNodes.item(i));
                continue;
            }
            catch (IOException e) {
                throw new RequestMessagesCreationException(e.getMessage());
            }
        }
        if (!contents.isEmpty()) {
            messages.add(new Message(RoleType.USER, contents));
        }
    }

    private static void addInstructionMessagePart(List<MessageContent> contents, Node node) throws IOException {
        Element item;
        String href;
        String nodeName = node.getNodeName();
        if ("instruction".equals(nodeName)) {
            String nodeContent = PositronDocumentationDraftAction.serializeNodeContent(node);
            if (!nodeContent.isBlank()) {
                contents.add((MessageContent)new MessageTextContent(nodeContent));
            }
        } else if ("image".equals(nodeName)) {
            Element item2 = (Element)node;
            String href2 = item2.getAttribute("href");
            if (!href2.isBlank()) {
                contents.add((MessageContent)MessageAttachmentUtils.createImageAttachmentMessageContent(href2));
            }
        } else if ("file".equals(nodeName) && !(href = (item = (Element)node).getAttribute("href")).isBlank()) {
            List<MessageContent> textContent = MessageAttachmentUtils.getTextContent(href, null);
            contents.add((MessageContent)new MessageTextContent("### START OF FILE CONTENT FOR: " + href + " ###"));
            for (MessageContent messageContentItem : textContent) {
                contents.add(messageContentItem);
            }
            contents.add((MessageContent)new MessageTextContent("### END OF FILE CONTENT FOR: " + href + " ###"));
        }
    }

    private static boolean isEmptyNode(Node node) {
        return !node.hasChildNodes() || node.getChildNodes().getLength() == 1 && node.getFirstChild().getNodeType() == 3 && node.getFirstChild().getTextContent().isBlank();
    }

    private static String serializeNodeContent(Node node) {
        StringBuilder content = new StringBuilder();
        DOMImplementationLS lsImpl = (DOMImplementationLS)node.getOwnerDocument().getImplementation().getFeature("LS", "3.0");
        LSSerializer lsSerializer = lsImpl.createLSSerializer();
        DOMConfiguration config = lsSerializer.getDomConfig();
        config.setParameter(XML_DECLARATION, false);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            content.append(lsSerializer.writeToString(children.item(i)));
        }
        return content.toString();
    }

    @Override
    protected boolean shouldCallReferencedFunctions() {
        Node useProjectContent;
        NamedNodeMap attributes;
        boolean shouldCallReferencedFunctions = false;
        NodeList draftSummaryNodeList = this.docDraftModel.getElementsByTagName("draft-summary");
        if (draftSummaryNodeList.getLength() > 0 && (attributes = draftSummaryNodeList.item(0).getAttributes()).getLength() > 0 && (useProjectContent = attributes.getNamedItem(USE_RELATED_CONTENT_FROM_PROJECT)) != null) {
            shouldCallReferencedFunctions = Boolean.parseBoolean(useProjectContent.getNodeValue());
        }
        return shouldCallReferencedFunctions;
    }

    @Override
    protected Map<String, String> getExpandedActionSpecificParms(List<ActionParam> params) throws ActionSpecificParamsExpandingException {
        HashMap<String, String> actionSpecificParams = new HashMap<String, String>();
        block14: for (ActionParam param : params) {
            switch (param.getName()) {
                case "draft-context": {
                    String draftContextValue = this.getSerializedContentValueForParamName("draft-context");
                    if (draftContextValue.isBlank()) break;
                    actionSpecificParams.put("draft-context", draftContextValue);
                    break;
                }
                case "draft-audience": {
                    String audienceValue = this.getSerializedContentValueForParamName("draft-audience");
                    if (audienceValue.isBlank()) break;
                    actionSpecificParams.put("draft-audience", audienceValue);
                    break;
                }
                case "img-hrefs": {
                    NodeList images = this.docDraftModel.getElementsByTagName("image");
                    if (images.getLength() <= 0) break;
                    this.expandImageHrefs(images, actionSpecificParams);
                    break;
                }
                case "draft-similar-topic": {
                    try {
                        String similarTopicContent = this.getSimilarTopicContent();
                        if (similarTopicContent.isBlank()) continue block14;
                        actionSpecificParams.put("draft-similar-topic", "The generated DITA XML documentation topic should resemble the following structure:\n" + similarTopicContent + "\n\nRefrain from using information from the previous structure example. Instead use it to see how we structure our content, how we use DITA markup, and what tone and style we adopt.");
                        break;
                    }
                    catch (IOException e) {
                        throw new ActionSpecificParamsExpandingException(e);
                    }
                }
            }
        }
        return actionSpecificParams;
    }

    private void expandImageHrefs(NodeList images, Map<String, String> actionSpecificParams) {
        StringBuilder sb = new StringBuilder();
        int length = images.getLength();
        for (int i = 0; i < length; ++i) {
            Element element = (Element)images.item(i);
            String srcAttrVal = element.getAttribute("href");
            sb.append(srcAttrVal);
            if (i >= length - 1) continue;
            sb.append(", ");
        }
        String hrefs = sb.toString();
        if (!hrefs.isBlank()) {
            actionSpecificParams.put("img-hrefs", "The values used for the href attributes of the image references, from the first attached image to the last one, must be the following: " + hrefs);
        }
    }

    String getSimilarTopicContent() throws IOException {
        MessageContent messageContent;
        List<MessageContent> mcs;
        Element element;
        String srcAttrVal;
        String content = null;
        NodeList nodeList = this.docDraftModel.getElementsByTagName("similar-topic");
        if (nodeList.getLength() > 0 && !(srcAttrVal = (element = (Element)nodeList.item(0)).getAttribute("href")).isBlank() && (mcs = MessageAttachmentUtils.getTextContent(srcAttrVal, null)) != null && !mcs.isEmpty() && (messageContent = mcs.get(0)) instanceof MessageTextContent) {
            content = ((MessageTextContent)messageContent).getText();
        }
        return content != null ? content : "";
    }

    private String getSerializedContentValueForParamName(String paramName) {
        String value = "";
        String modelElementName = "";
        switch (paramName) {
            case "draft-context": {
                modelElementName = "context";
                break;
            }
            case "draft-audience": {
                modelElementName = "audience";
                break;
            }
        }
        NodeList nodeList = this.docDraftModel.getElementsByTagName(modelElementName);
        if (nodeList.getLength() > 0) {
            value = PositronDocumentationDraftAction.serializeNodeContent(nodeList.item(0));
        }
        return value;
    }

    @Override
    protected void treatUsableContentProcessingException(UsableContentProcessingException e) {
        if (e.getCause() instanceof InvalidFileUsedForDocDraftConfigurationException) {
            this.handleActionStoppedPrematurely();
            MessagePresenter.MessageDialogResult result = this.messagePresenter.showOKCancelInfoMessageDialog("Generate Documentation Draft", TRANSLATOR.getTranslation("Doc_draft_invoked_on_wrong_editor_dlg_message"), TRANSLATOR.getTranslation("Create_doc_draft_model_file"), TRANSLATOR.getTranslation("Close"));
            if (result == MessagePresenter.MessageDialogResult.OK_PRESSED && this.documentCreator != null) {
                String editorContent;
                try {
                    String configTemplateFileLocation = EditorVariables.expandEditorVariables((String)"${frameworkDir(AI Positron Documentation Draft Generation Configuration)}/templates/AI Doc Draft Configuration.xml", null);
                    editorContent = IOUtil.readFile((File)new File(configTemplateFileLocation), (String)"UTF-8");
                }
                catch (IOException ex) {
                    LOGGER.warn("Could not read the template file for documentation drafting configuration. Using fallback content.");
                    editorContent = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<doc-draft>\n  <title>Generate Documentation Draft</title>\n  <instructions>\n    <draft-summary></draft-summary>\n    <instruction></instruction>\n    <image href=\"\"/>\n    <file href=\"\"/>\n  </instructions>\n</doc-draft>";
                }
                this.documentCreator.createNewEditor("xml", "text/xml", editorContent);
            }
        } else {
            super.treatUsableContentProcessingException(e);
        }
    }
}

