/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions.types;

import com.oxygenxml.positron.core.AICompletionProviderResolver;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.actions.MessagePresenter;
import com.oxygenxml.positron.core.actions.OperationCancelledByUserException;
import com.oxygenxml.positron.core.actions.OperationSemaphoreHandler;
import com.oxygenxml.positron.core.actions.types.AIFixActionInteractor;
import com.oxygenxml.positron.core.actions.types.BaseActionInteractor;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.aiignore.OperationCancelledByAiIgnoreException;
import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.interactions.ContextInfo;
import com.oxygenxml.positron.core.progress.OperationProgressPresenter;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.functions.parameters.ContentParams;
import java.net.URL;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.document.DocumentPositionedInfo;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.WSEditorPage;
import ro.sync.exml.workspace.api.editor.page.author.WSAuthorEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;

public class PositronAIFixAction
extends PositronAIActionBase {
    private static final Logger log = LoggerFactory.getLogger(PositronAIFixAction.class);
    private DocumentPositionedInfo currentDPI = null;
    public static final String PROBLEM_DESCRIPTION_PARAM_NAME = "problemDescription";

    public PositronAIFixAction(BaseActionInteractor actionInteractor, AICompletionProviderResolver completionProviderResolver, MessagePresenter messagePresenter, ChatInteractor chatInteractor, OperationSemaphoreHandler operationSemaphoreHandler, OperationProgressPresenter statusPanel) {
        super(actionInteractor, completionProviderResolver, messagePresenter, chatInteractor, operationSemaphoreHandler, statusPanel);
    }

    @Override
    protected ContextInfo getTextToProcess() throws CannotComputeCompletionDetailsException, OperationCancelledByUserException, BadLocationException, OperationCancelledByAiIgnoreException {
        StandalonePluginWorkspace pluginWS = (StandalonePluginWorkspace)PluginWorkspaceProvider.getPluginWorkspace();
        ContextInfo imposedContext = null;
        if (this.currentDPI != null) {
            try {
                WSEditorPage currentPage;
                WSEditor editorAccess = pluginWS.getEditorAccess(new URL(this.currentDPI.getSystemID()), 0);
                WSEditorPage wSEditorPage = currentPage = editorAccess != null ? editorAccess.getCurrentPage() : null;
                if (currentPage instanceof WSAuthorEditorPage) {
                    WSAuthorEditorPage authorPage = (WSAuthorEditorPage)currentPage;
                    int[] startEndOffsets = authorPage.getStartEndOffsets(this.currentDPI);
                    AuthorDocumentFragment createDocumentFragment = authorPage.getDocumentController().createDocumentFragment(startEndOffsets[0], startEndOffsets[1] - 1);
                    String offendingString = authorPage.getDocumentController().serializeFragmentToXML(createDocumentFragment);
                    imposedContext = new ContextInfo("Correct this content: " + offendingString, startEndOffsets[0], startEndOffsets[1]);
                } else if (currentPage instanceof WSTextEditorPage) {
                    WSTextEditorPage textPage = (WSTextEditorPage)currentPage;
                    int[] startEndOffsets = textPage.getStartEndOffsets(this.currentDPI);
                    String offendingString = textPage.getDocument().getText(startEndOffsets[0], startEndOffsets[1] - startEndOffsets[0]);
                    imposedContext = new ContextInfo("Correct this content: " + offendingString, startEndOffsets[0], startEndOffsets[1]);
                }
            }
            catch (Exception ex) {
                throw new CannotComputeCompletionDetailsException(ex.getMessage());
            }
        }
        return imposedContext != null ? imposedContext : super.getTextToProcess();
    }

    public void performFix(DocumentPositionedInfo currentDPI) {
        this.currentDPI = currentDPI;
        StringBuilder contextBuilder = new StringBuilder("Problem description: \n");
        contextBuilder.append(currentDPI.asText());
        if (this.actionInteractor instanceof AIFixActionInteractor) {
            if (currentDPI.getLine() != -1 || currentDPI.getEndLine() != -1) {
                int startLine = currentDPI.getLine();
                int endLine = currentDPI.getEndLine() != -1 ? currentDPI.getEndLine() : startLine;
                contextBuilder.append("\n EXTENDED CONTEXT START\n");
                try {
                    ContentParams params = new ContentParams();
                    params.read_entire_file = false;
                    params.start_line = startLine - 10;
                    params.end_line = endLine + 10;
                    String contextBlock = this.prefixExtractor.getEntireDocumentContent(true).getUsableContent();
                    contextBlock = TextUtils.changeContentToFitLineRanges(params, contextBlock);
                    contextBuilder.append(contextBlock);
                }
                catch (OperationCancelledByAiIgnoreException | BadLocationException e) {
                    log.debug((Throwable)e);
                }
                contextBuilder.append("\n EXTENDED CONTEXT END\n");
            }
            ((AIFixActionInteractor)this.actionInteractor).setPreviouslyUsedContext(null);
            ((AIFixActionInteractor)this.actionInteractor).setOriginalContext(null);
            ((AIFixActionInteractor)this.actionInteractor).setSpecificParameters(Map.of(PROBLEM_DESCRIPTION_PARAM_NAME, contextBuilder.toString()));
        }
        log.debug("contextBuilder {}", (Object)contextBuilder);
        this.actionPerformed(null);
    }
}

