/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions.types;

import com.oxygenxml.positron.core.AICompletionProviderResolver;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.actions.MessagePresenter;
import com.oxygenxml.positron.core.actions.OperationCancelledByUserException;
import com.oxygenxml.positron.core.actions.OperationSemaphoreHandler;
import com.oxygenxml.positron.core.actions.types.BaseActionInteractor;
import com.oxygenxml.positron.core.actions.types.PositronAIActionBase;
import com.oxygenxml.positron.core.aiignore.OperationCancelledByAiIgnoreException;
import com.oxygenxml.positron.core.chat.ChatInteractor;
import com.oxygenxml.positron.core.interactions.ContextInfo;
import com.oxygenxml.positron.core.interactions.DocumentContentInteractor;
import com.oxygenxml.positron.core.progress.OperationProgressPresenter;
import com.oxygenxml.positron.utilities.json.InputContext;
import com.oxygenxml.positron.utilities.json.InputType;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PositronAICreateDocumentAction
extends PositronAIActionBase {
    private static final Logger log = LoggerFactory.getLogger(PositronAICreateDocumentAction.class);

    public PositronAICreateDocumentAction(BaseActionInteractor actionInteractor, AICompletionProviderResolver completionProviderResolver, MessagePresenter messagePresenter, ChatInteractor chatInteractor, OperationSemaphoreHandler operationSemaphoreHandler, OperationProgressPresenter statusPanel) {
        super(actionInteractor, completionProviderResolver, messagePresenter, chatInteractor, operationSemaphoreHandler, statusPanel);
    }

    @Override
    protected ContextInfo getTextToProcess() throws CannotComputeCompletionDetailsException, OperationCancelledByUserException, BadLocationException, OperationCancelledByAiIgnoreException {
        String initialContent = this.getInitialContent(this.prefixExtractor);
        String textToProcess = this.getContentFromUserDialog(initialContent);
        if (textToProcess == null || textToProcess.isEmpty()) {
            throw new OperationCancelledByUserException(this.getActionCanceledMessage());
        }
        return new ContextInfo(textToProcess, 0, 0);
    }

    private String getInitialContent(DocumentContentInteractor completionInserter) throws BadLocationException, OperationCancelledByAiIgnoreException {
        ContextInfo currentContextInfo;
        String initialContent = null;
        if (completionInserter != null && (currentContextInfo = completionInserter.getCurrentContextInfo(this.details.getInputType() == null || this.details.getInputType() != InputType.PLAIN_TEXT, InputContext.SELECTION, true)) != null) {
            initialContent = currentContextInfo.getUsableContent();
        }
        return initialContent;
    }

    protected String getContentFromUserDialog(String initialContent) {
        String toReturn = "";
        if (this.userInputProvider != null) {
            toReturn = this.userInputProvider.askUserForInput(this.details.getShortDescription(), this.details.getDescription(), TRANSLATOR.getTranslation("Generated_content_can_be_saved_afterwards"), TRANSLATOR.getTranslation("Generate"), initialContent, false);
        } else {
            log.warn("The user input aquirer is not initialized.");
        }
        return toReturn;
    }
}

