/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions.types;

import com.oxygenxml.positron.core.actions.types.BaseActionInteractor;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.json.AIActionDetails;

public class InsertFragmentActionInteractor
extends BaseActionInteractor
implements Cloneable {
    public InsertFragmentActionInteractor(AIActionDetails details) {
        super(details);
    }

    @Override
    public String getActionChangeType() {
        return TRANSLATOR.getTranslation("Insert");
    }

    @Override
    public String getActionChangeDescription() {
        return TRANSLATOR.getTranslation("Insert_response_at_caret_position");
    }

    @Override
    public String getPreviewChangeDescription() {
        return TRANSLATOR.getTranslation("Preview_insert_response_at_caret_position");
    }

    @Override
    public void previewDocumentModifications(String response) {
        response = TextUtils.extractInsertionContentFromResponseForInserter(response, this.completionInserter);
        int[] offsets = this.getUpdatedStartAndEndOffsets();
        this.completionInserter.previewInsert(offsets[0], offsets[1], response != null ? response : this.initialSuggestion, this.details.getInsertModes(), true, false);
    }

    @Override
    public String getActionChangeIconPath() {
        return "/images/InsertAIResponse16.png";
    }

    @Override
    public int[] modifyDocument(String response) {
        response = TextUtils.extractInsertionContentFromResponseForInserter(response, this.completionInserter);
        int[] offsets = this.getUpdatedStartAndEndOffsets();
        int[] insertedOffsets = this.completionInserter.insert(offsets[0], offsets[1], response != null ? response : this.initialSuggestion, this.details.getInsertModes(), true, false, false);
        this.initialSuggestion = null;
        return insertedOffsets;
    }
}

