/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions.types;

import com.oxygenxml.positron.core.actions.types.ReplaceCapableActionInteractor;
import com.oxygenxml.positron.core.interactions.ContextInfo;
import com.oxygenxml.positron.core.tools.ContextInfoSession;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AIFixActionInteractor
extends ReplaceCapableActionInteractor
implements ContextInfoSession,
Cloneable {
    private static final Logger log = LoggerFactory.getLogger(AIFixActionInteractor.class);
    private ContextInfo previouslyUsedUsedContext = null;
    private ContextInfo originalContext = null;
    private Map<String, String> parameters = Collections.emptyMap();

    public AIFixActionInteractor(AIActionDetails details) {
        super(details);
    }

    @Override
    public Map<String, String> getExpandedActionParams() {
        Map<String, String> expandedParams = super.getExpandedActionParams();
        expandedParams.putAll(this.parameters);
        return expandedParams;
    }

    public void setSpecificParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public boolean canModifyDocument() {
        return true;
    }

    @Override
    public boolean canPreviewDocumentModifications() {
        return true;
    }

    @Override
    public void previewDocumentModifications(String response) {
        int[] offsets = this.getUpdatedStartAndEndOffsets();
        this.completionInserter.previewReplaceSelectionWithSuggestion(Objects.requireNonNullElse(response, this.initialSuggestion), true, offsets[0], offsets[1]);
    }

    @Override
    public int[] modifyDocument(String response) {
        int[] offsets = this.getUpdatedStartAndEndOffsets();
        int[] insertedOffsets = this.completionInserter.replaceSelectionWithSuggestion(Objects.requireNonNullElse(response, this.initialSuggestion), true, offsets[0], offsets[1], false);
        this.initialSuggestion = null;
        return insertedOffsets;
    }

    @Override
    public String getActionChangeDescription() {
        return TRANSLATOR.getTranslation("Replace_action_tooltip");
    }

    @Override
    public String getPreviewChangeDescription() {
        return TRANSLATOR.getTranslation("Preview_replace_tooltip");
    }

    @Override
    protected AIFixActionInteractor clone() throws CloneNotSupportedException {
        return (AIFixActionInteractor)super.clone();
    }

    @Override
    public void setAiInitialSuggestion(String initialSuggestion, int startOffset, int endOffset) throws BadLocationException {
        if (this.previouslyUsedUsedContext == null) {
            this.overwriteAiSuggestion(initialSuggestion, startOffset, endOffset);
        }
    }

    @Override
    public void setAiInitialSuggestion(String initialSuggestion, Position startOffset, Position endOffset) {
        if (this.previouslyUsedUsedContext == null) {
            this.overwriteAiSuggestion(initialSuggestion, startOffset, endOffset);
        }
    }

    @Override
    public void setPreviouslyUsedContext(ContextInfo context) {
        this.previouslyUsedUsedContext = context;
        if (context != null) {
            try {
                this.overwriteAiSuggestion(context.getUsableContent(), context.getStartOffset(), context.getEndOffset());
            }
            catch (BadLocationException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
    }

    @Override
    public ContextInfo getPreviouslyUsedContext() {
        return this.previouslyUsedUsedContext;
    }

    @Override
    public void setOriginalContext(ContextInfo originalContext) {
        this.originalContext = originalContext;
    }

    @Override
    public ContextInfo getOriginalContext() {
        return this.originalContext;
    }
}

