/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions.types;

import com.oxygenxml.positron.core.util.TextUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.document.LineDocumentBase;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;

public final class AIAutocompletionUtil {
    private static final Logger log = LoggerFactory.getLogger(AIAutocompletionUtil.class);
    public static final Map<String, String> GENERIC_EDITOR_TYPES = AIAutocompletionUtil.createGenericEditorTypes();
    public static final Map<String, String> SPECIFIC_EDITOR_TYPES = AIAutocompletionUtil.createSpecificEditorTypes();
    public static final Map<String, String> ALL_EDITOR_TYPES;
    private static final List<String> CONTENT_TYPES_DISABLED_BY_DEFAULT;

    public static String extractSuggestion(String suggestion, WSTextEditorPage editorPage) {
        block2: {
            int caretPosition = editorPage.getCaretOffset();
            LineDocumentBase documentBase = (LineDocumentBase)editorPage.getDocument();
            try {
                int lineNumber = editorPage.getLineOfOffset(caretPosition);
                String currentLineText = documentBase.getLineText(lineNumber).toString();
                suggestion = TextUtils.trimMatchingPrefix(suggestion, currentLineText);
            }
            catch (BadLocationException e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)e, (Throwable)e);
            }
        }
        return suggestion;
    }

    public static String extractXmlSuggestion(String suggestion, WSTextEditorPage editorPage) {
        block5: {
            try {
                int caretPosition = editorPage.getCaretOffset();
                LineDocumentBase documentBase = (LineDocumentBase)editorPage.getDocument();
                int lineNumber = editorPage.getLineOfOffset(caretPosition);
                int caretToLineEndLength = documentBase.getOffsetOfLineEnd(lineNumber) - caretPosition;
                String currentLineText = documentBase.getLineText(lineNumber).toString();
                suggestion = TextUtils.trimMatchingPrefix((String)suggestion, currentLineText);
                if (suggestion != null && caretToLineEndLength > 0 && editorPage.getDocument().getText(caretPosition, caretToLineEndLength).isBlank() && !currentLineText.isBlank()) {
                    currentLineText = currentLineText.trim();
                    if (((String)suggestion).startsWith("<") && currentLineText.endsWith(">")) {
                        suggestion = "\n" + (String)suggestion;
                        if (!currentLineText.endsWith("/>") && !currentLineText.startsWith("</")) {
                            suggestion = ((String)suggestion).replace("\n", "\n\t");
                        }
                    }
                }
            }
            catch (BadLocationException e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)e, (Throwable)e);
            }
        }
        return suggestion;
    }

    private static Map<String, String> createGenericEditorTypes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("text/ant", "ANT Editor");
        map.put("text/batch", "Batch Editor");
        map.put("text/c", "C Editor");
        map.put("text/cc", "C++ Editor");
        map.put("text/css", "CSS Editor");
        map.put("text/dockerfile", "Dockerfile Editor");
        map.put("text/dtd", "DTD Editor");
        map.put("text/exf", "EXF Editor");
        map.put("text/html", "HTML Editor");
        map.put("text/java", "Java Editor");
        map.put("text/javascript", "JavaScript Editor");
        map.put("text/less", "LESS Editor");
        map.put("text/nvdl", "NVDL Editor");
        map.put("text/perl", "Perl Editor");
        map.put("text/php", "PHP Editor");
        map.put("text/powershell", "PowerShell Editor");
        map.put("text/properties", "Properties Editor");
        map.put("text/python", "Python Editor");
        map.put("text/shell", "Shell Editor");
        map.put("text/sql", "SQL Editor");
        map.put("text/wsdl", "WSDL Editor");
        map.put("text/xproc", "XProc Editor");
        map.put("text/xquery", "XQuery Editor");
        map.put("text/xspec", "XSPEC Editor");
        map.put("text/rnc", "RNC Editor");
        map.put("text/rng", "RNG Editor");
        map.put("application/xhtml+xml", "XHTML Editor");
        return Collections.unmodifiableMap(map);
    }

    private static Map<String, String> createSpecificEditorTypes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("text/xsl", "XSL Editor");
        map.put("text/xsd", "XSD Editor");
        map.put("text/sch", "Schematron Editor");
        map.put("text/json-schema", "JSON Schema Editor");
        return Collections.unmodifiableMap(map);
    }

    public static boolean isContentTypeActiveByDefault(String contentType) {
        return !CONTENT_TYPES_DISABLED_BY_DEFAULT.contains(contentType);
    }

    private AIAutocompletionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        HashMap<String, String> combined = new HashMap<String, String>(GENERIC_EDITOR_TYPES);
        combined.putAll(SPECIFIC_EDITOR_TYPES);
        ALL_EDITOR_TYPES = Map.copyOf(combined);
        CONTENT_TYPES_DISABLED_BY_DEFAULT = List.of("text/ant", "text/batch", "text/exf", "text/less", "text/properties", "text/nvdl", "text/rnc");
    }
}

