/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions.loader;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.oxygenxml.positron.core.util.AddonActionsUtil;
import com.oxygenxml.positron.core.util.TranslateActionsUtil;
import com.oxygenxml.positron.utilities.action.ActionsUtil;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.FileSystemUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;

public class AdditionalActionsProvider {
    private static final Logger log = LoggerFactory.getLogger(AdditionalActionsProvider.class);
    public static final String CONNECTOR_PROPERTIES_FILENAME = "ai-service-configuration.json";
    private final List<File> actionsFiles = new ArrayList<File>();
    private final ObjectMapper objectMapper = new ObjectMapper();

    private void loadActionsFiles(File actionsFolder) {
        this.actionsFiles.clear();
        if (actionsFolder != null) {
            if (actionsFolder.isDirectory()) {
                AdditionalActionsProvider.collectJsonFilesRecursive(actionsFolder, this.actionsFiles);
            } else if (AdditionalActionsProvider.isJsonFile(actionsFolder)) {
                this.actionsFiles.add(actionsFolder);
            }
        }
    }

    public static void collectJsonFilesRecursive(File folder, List<File> jsonFilesCollector) {
        if (folder.exists() && folder.isDirectory()) {
            Object[] files = folder.listFiles();
            Arrays.sort(files);
            if (files != null) {
                for (Object file : files) {
                    if (AdditionalActionsProvider.isJsonFile((File)file)) {
                        jsonFilesCollector.add((File)file);
                        continue;
                    }
                    if (!((File)file).isDirectory()) continue;
                    AdditionalActionsProvider.collectJsonFilesRecursive((File)file, jsonFilesCollector);
                }
            }
        }
    }

    private static boolean isJsonFile(File file) {
        String fileName = file.getName();
        return fileName.toLowerCase().endsWith(".json");
    }

    protected URL getAdditionalActionsFolder() {
        String actionsFolderPath;
        URL actionsFolder = null;
        PluginWorkspace pluginWS = PluginWorkspaceProvider.getPluginWorkspace();
        if (pluginWS != null && pluginWS.getOptionsStorage() != null && (actionsFolderPath = pluginWS.getOptionsStorage().getOption("oxygen.positron.plugin.actions.folder", "${pd}/positron-ai-actions")) != null && !actionsFolderPath.trim().isEmpty()) {
            actionsFolderPath = pluginWS.getUtilAccess().expandEditorVariables(actionsFolderPath, null);
            actionsFolder = URLUtil.convertToURL((String)actionsFolderPath);
        }
        return actionsFolder;
    }

    public List<AIActionDetails> getActions() {
        ArrayList<AIActionDetails> actions = new ArrayList<AIActionDetails>();
        URL actionsFolder = this.getAdditionalActionsFolder();
        if (actionsFolder != null) {
            if (URLUtil.isFromLocalDrive((URL)actionsFolder)) {
                this.collectActionDetailsFromLocalDir(actionsFolder, actions);
            } else if ("jar".equals(actionsFolder.getProtocol())) {
                this.collectActionDetailsFromJar(actionsFolder.toExternalForm(), actions);
            } else {
                log.error("Cannot load Positron actions for external connection.");
            }
        }
        this.loadAddonsProvidedExternalActions(actions);
        for (AIActionDetails aiActionDetails : actions) {
            TranslateActionsUtil.translate(aiActionDetails);
        }
        return actions;
    }

    private void loadAddonsProvidedExternalActions(List<AIActionDetails> actions) {
        List<URL> addonsAIActionsDefinitionLocations = AddonActionsUtil.getExternalAIActionsDefinitionLocations();
        if (addonsAIActionsDefinitionLocations != null && !addonsAIActionsDefinitionLocations.isEmpty()) {
            JavaType type = this.objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{AIActionDetails.class});
            for (URL actionsDefinitionURL : addonsAIActionsDefinitionLocations) {
                InputStream inputStream;
                if (actionsDefinitionURL.toExternalForm().endsWith("/ai-service-configuration.json")) continue;
                Exception loadException = null;
                ArrayList<AIActionDetails> newActions = new ArrayList<AIActionDetails>();
                try {
                    inputStream = actionsDefinitionURL.openStream();
                    try {
                        newActions.addAll((Collection)this.objectMapper.readValue(inputStream, type));
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                catch (Exception e) {
                    loadException = e;
                }
                if (loadException != null) {
                    try {
                        inputStream = actionsDefinitionURL.openStream();
                        try {
                            newActions.add((AIActionDetails)this.objectMapper.readValue(inputStream, AIActionDetails.class));
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        log.error(loadException.getMessage(), (Throwable)loadException);
                    }
                }
                ActionsUtil.expandPromptRef(newActions, (URL)actionsDefinitionURL);
                actions.addAll(newActions);
            }
        }
        actions.addAll(AddonActionsUtil.loadActionsUsingConfigOptionsProviderAPI(this.getApplicationContext()));
    }

    protected Map<String, Object> getApplicationContext() {
        return new HashMap<String, Object>();
    }

    public void collectActionDetailsFromLocalDir(URL actionsFolder, List<AIActionDetails> actionsCollector) {
        this.loadActionsFiles(URLUtil.getAbsoluteFileFromFileUrl((URL)actionsFolder));
        if (!this.actionsFiles.isEmpty()) {
            JavaType type = this.objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{AIActionDetails.class});
            for (File fileAction : this.actionsFiles) {
                FileInputStream inputStream;
                Exception loadException = null;
                ArrayList<AIActionDetails> newActions = new ArrayList<AIActionDetails>();
                try {
                    inputStream = new FileInputStream(fileAction);
                    try {
                        newActions.addAll((Collection)this.objectMapper.readValue((InputStream)inputStream, type));
                    }
                    finally {
                        ((InputStream)inputStream).close();
                    }
                }
                catch (Exception e) {
                    loadException = e;
                }
                if (loadException != null) {
                    try {
                        inputStream = new FileInputStream(fileAction);
                        try {
                            newActions.add((AIActionDetails)this.objectMapper.readValue((InputStream)inputStream, AIActionDetails.class));
                        }
                        finally {
                            ((InputStream)inputStream).close();
                        }
                    }
                    catch (Exception e) {
                        log.error(loadException.getMessage(), (Throwable)loadException);
                    }
                }
                try {
                    ActionsUtil.expandPromptRef(newActions, (URL)URLUtil.correct((File)fileAction));
                }
                catch (MalformedURLException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                actionsCollector.addAll(newActions);
            }
        }
    }

    private void collectActionDetailsFromJar(String jarLocation, List<AIActionDetails> actionsCollector) {
        String jarURL = jarLocation.substring(0, jarLocation.indexOf("!/") + 2);
        String basePath = jarLocation.substring(jarLocation.indexOf("!/") + 2);
        try {
            URL jarUrl = new URL(jarURL);
            JarURLConnection jarConnection = (JarURLConnection)jarUrl.openConnection();
            try (JarFile jarFile = jarConnection.getJarFile();){
                JavaType type = this.objectMapper.getTypeFactory().constructParametricType(List.class, new Class[]{AIActionDetails.class});
                Enumeration<JarEntry> entries = jarFile.entries();
                TreeMap<String, Collection<AIActionDetails>> sortedActions = new TreeMap<String, Collection<AIActionDetails>>();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.startsWith(basePath) || !entryName.endsWith(".json")) continue;
                    Exception loadException = null;
                    try (InputStream inputStream = jarFile.getInputStream(entry);){
                        sortedActions.put(entryName, (Collection)this.objectMapper.readValue(inputStream, type));
                    }
                    catch (Exception e) {
                        loadException = e;
                    }
                    if (loadException != null) {
                        this.tryLoadingAsSimpleAction(jarFile, sortedActions, entry, entryName, loadException);
                    }
                    if (!sortedActions.containsKey(entryName)) continue;
                    ActionsUtil.expandPromptRef((Collection)((Collection)sortedActions.get(entryName)), (URL)new URL(jarUrl, URLUtil.correct((String)entryName, (boolean)false)));
                }
                for (Map.Entry entry : sortedActions.entrySet()) {
                    actionsCollector.addAll((Collection)entry.getValue());
                }
            }
        }
        catch (IOException e) {
            log.debug((Object)e, (Throwable)e);
        }
    }

    private void tryLoadingAsSimpleAction(JarFile jarFile, SortedMap<String, Collection<AIActionDetails>> sortedActions, JarEntry entry, String entryName, Exception loadException) {
        try (InputStream inputStream = jarFile.getInputStream(entry);){
            ArrayList<AIActionDetails> actions = new ArrayList<AIActionDetails>(1);
            actions.add((AIActionDetails)this.objectMapper.readValue(inputStream, AIActionDetails.class));
            sortedActions.put(entryName, actions);
        }
        catch (Exception e) {
            log.error(loadException.getMessage(), (Throwable)loadException);
        }
    }

    public boolean isFileFromAdditionalActionsFolder(File file) throws IOException {
        File additionalActionsFolder = URLUtil.getCanonicalFileFromFileUrl((URL)this.getAdditionalActionsFolder());
        return additionalActionsFolder != null && FileSystemUtil.isAncestor((File)URLUtil.getCanonicalFile((File)additionalActionsFolder), (File)URLUtil.getCanonicalFile((File)file));
    }
}

