/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core.actions;

import com.oxygenxml.positron.core.SafeUIExecutor;
import com.oxygenxml.positron.core.actions.InstanceExpanderUtil;
import com.oxygenxml.positron.core.actions.PositronEditorVariables;
import com.oxygenxml.positron.core.interactions.DocumentDetailsProvider;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.util.OutlineComponentsUtil;
import com.oxygenxml.positron.core.util.OutlineNamespacesUtil;
import com.oxygenxml.positron.core.util.TextUtils;
import com.oxygenxml.positron.utilities.action.ActionsUtil;
import com.oxygenxml.positron.utilities.json.ActionParam;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.IOUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.application.ApplicationType;
import ro.sync.exml.workspace.api.editor.WSEditor;
import ro.sync.exml.workspace.api.editor.page.WSEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.editor.page.text.xml.WSXMLTextEditorPage;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.standalone.project.ProjectController;
import ro.sync.util.editorvars.EditorVariables;

public class ParamsExpander {
    private static final String DESKTOP_OXYGEN_PROJECT_EXTENSION = ".xpr";
    private static final Logger logger = LoggerFactory.getLogger((String)ParamsExpander.class.getName());
    public static final String VALS_SEPARATOR = "###---####";
    public static final String EXTRA_CONTEXT_INFO_PARAM = "extraContextInfo";
    public static final String TRANSLATION_LANGUAGE_PARAM_NAME = "translationLanguage";
    public static final String SINGLE_CHOICE_PARAM_TYPE = "single-choice";
    public static final String MULTI_CHOICE_PARAM_TYPE = "multi-choice";
    public static final String EDITABLE_COMBO_CHOICE_PARAM_TYPE = "editable-combo-choice";

    public static Map<String, String> expandParams(String actionID, List<ActionParam> paramsToExpand, DocumentDetailsProvider docDetailsProvider) {
        HashMap<String, String> params = new HashMap<String, String>();
        ParamsExpander.expandParams(actionID, paramsToExpand, docDetailsProvider, params);
        return params;
    }

    public static void expandParams(String actionID, List<ActionParam> paramsToExpand, DocumentDetailsProvider docDetailsProvider, Map<String, String> params) {
        if (paramsToExpand != null) {
            for (ActionParam actionParam : paramsToExpand) {
                ParamsExpander.expandParam(actionID, actionParam, params, docDetailsProvider);
            }
        }
    }

    public static void expandParam(String actionID, ActionParam actionParam, Map<String, String> params, DocumentDetailsProvider docDetailsProvider) {
        String paramValue = actionParam.getValue();
        Object expanded = paramValue;
        if (paramValue != null && !paramValue.isEmpty()) {
            WSOptionsStorage optionsStorage;
            PluginWorkspace pluginWS;
            if (paramValue.contains("${contextPrompt}") && (pluginWS = PluginWorkspaceProvider.getPluginWorkspace()) != null && (optionsStorage = pluginWS.getOptionsStorage()) != null) {
                Object expandValue = optionsStorage.getOption("oxygen.positron.plugin.context.info", "");
                if (params.containsKey(EXTRA_CONTEXT_INFO_PARAM)) {
                    expandValue = params.get(EXTRA_CONTEXT_INFO_PARAM) + "\n" + (String)expandValue;
                    params.remove(EXTRA_CONTEXT_INFO_PARAM);
                }
                expandValue = ParamsExpander.addAIContextFileContents(pluginWS, (String)expandValue);
                if ((expandValue = ParamsExpander.addPersistentMemoryToContext(optionsStorage, (String)expandValue)) == null) {
                    expandValue = "";
                }
                expanded = ((String)expanded).replace("${contextPrompt}", (CharSequence)expandValue);
            }
            if (((String)expanded).contains(PositronEditorVariables.CONTENT_TYPE_DESCRIPTION.getValue())) {
                expanded = ParamsExpander.expandContentTypeDescription(docDetailsProvider, (String)expanded, "valid XML elements ");
            }
            if (((String)expanded).contains(PositronEditorVariables.CONTEXT_XPATH.getValue())) {
                int lastIndexOfSlash;
                String contextXPath = ParamsExpander.expandContextXPath();
                if (contextXPath != null && !contextXPath.isEmpty() && (lastIndexOfSlash = contextXPath.lastIndexOf(47)) != -1 && contextXPath.substring(lastIndexOfSlash).contains("comment()")) {
                    contextXPath = contextXPath.substring(0, lastIndexOfSlash);
                }
                expanded = ((String)expanded).replace(PositronEditorVariables.CONTEXT_XPATH.getValue(), contextXPath == null ? "" : contextXPath);
            }
            if (((String)expanded).contains(PositronEditorVariables.ASSOCIATED_INSTANCE.getValue())) {
                WSOptionsStorage optionsStorage2;
                pluginWS = PluginWorkspaceProvider.getPluginWorkspace();
                boolean includeAssociatedInstance = true;
                if (pluginWS != null && (optionsStorage2 = pluginWS.getOptionsStorage()) != null) {
                    includeAssociatedInstance = Boolean.valueOf(optionsStorage2.getOption("oxygen.positron.plugin.include.associated.instance.in.autocompletion.prompt", "true"));
                }
                String associatedInstance = "";
                if (includeAssociatedInstance && ((associatedInstance = ParamsExpander.getCurrentFileAssociatedScenarioInstance(true)) == null || associatedInstance.isEmpty())) {
                    associatedInstance = ParamsExpander.getCurrentFileAssociatedScenarioInstance(false);
                }
                expanded = ((String)expanded).replace(PositronEditorVariables.ASSOCIATED_INSTANCE.getValue(), associatedInstance == null ? "" : associatedInstance);
            }
            if (((String)expanded).contains(PositronEditorVariables.CONTEXT_COMPONENT_OUTLINE.getValue())) {
                try {
                    expanded = ((String)expanded).replace(PositronEditorVariables.CONTEXT_COMPONENT_OUTLINE.getValue(), OutlineComponentsUtil.buildComponentOutline());
                }
                catch (Exception e) {
                    logger.debug((Throwable)e);
                }
            }
            if (((String)expanded).contains(PositronEditorVariables.CONTEXT_NAMESPACE_OUTLINE.getValue())) {
                try {
                    expanded = ((String)expanded).replace(PositronEditorVariables.CONTEXT_NAMESPACE_OUTLINE.getValue(), OutlineNamespacesUtil.buildNamespaceOutline());
                }
                catch (Exception e) {
                    logger.debug((Throwable)e);
                }
            }
            if (((String)expanded).contains(PositronEditorVariables.CONTEXT_WITH_CARET_MARKER_STRING.getValue())) {
                pluginWS = PluginWorkspaceProvider.getPluginWorkspace();
                if (pluginWS == null) {
                    return;
                }
                WSEditorPage currentPage = pluginWS.getCurrentEditorAccess(0).getCurrentPage();
                if (!(currentPage instanceof WSTextEditorPage)) {
                    return;
                }
                WSTextEditorPage textEditorPage = (WSTextEditorPage)currentPage;
                Document doc = textEditorPage.getDocument();
                int offset = textEditorPage.getCaretOffset();
                try {
                    expanded = ((String)expanded).replace(PositronEditorVariables.CONTEXT_WITH_CARET_MARKER_STRING.getValue(), TextUtils.getContentAroundCaretInternal(doc, offset, 6000, true));
                }
                catch (BadLocationException e) {
                    logger.debug((Throwable)e);
                }
            }
            expanded = ParamsExpander.expandAppContext(docDetailsProvider, (String)expanded);
            expanded = ParamsExpander.expandProjectURL(docDetailsProvider, (String)expanded);
            expanded = ParamsExpander.expandRootMapURL(docDetailsProvider, (String)expanded);
            expanded = ParamsExpander.expandCurrentEditorLocation(docDetailsProvider, (String)expanded);
            URL processedEditorLocation = null;
            if (docDetailsProvider != null) {
                processedEditorLocation = URLUtil.clearUserInfo((String)docDetailsProvider.getEditorLocation());
            }
            expanded = EditorVariables.expandEditorVariables((String)expanded, (String)(processedEditorLocation != null ? processedEditorLocation.toExternalForm() : null));
            String prefixValue = actionParam.getPrefix();
            if (prefixValue != null && !prefixValue.isEmpty() && expanded != null && !((String)expanded).isEmpty()) {
                expanded = prefixValue + (String)expanded;
            }
        }
        if (actionID != null && ParamsExpander.isChoiceParam(actionParam) && (!actionID.equals("action.translate.to.lang") || actionParam.getValue() == null || actionParam.getValue().isEmpty())) {
            expanded = ParamsExpander.getChoiceParamStoredConfigValue(actionID, actionParam, (String)expanded);
        }
        if (expanded != null) {
            params.put(actionParam.getName(), (String)expanded);
        }
    }

    private static String addPersistentMemoryToContext(WSOptionsStorage optionsStorage, String expandValue) {
        String memoryContext;
        if (Boolean.valueOf(optionsStorage.getOption("oxygen.positron.plugin.enable.memory", "true")).booleanValue() && (memoryContext = optionsStorage.getOption("oxygen.positron.plugin.memory", "")) != null && !memoryContext.isEmpty() && !"".equals(memoryContext)) {
            if (!((String)expandValue).isEmpty()) {
                expandValue = (String)expandValue + "\n\n";
            }
            expandValue = (String)expandValue + memoryContext;
        }
        return expandValue;
    }

    private static String addAIContextFileContents(PluginWorkspace pluginWS, String expandValue) {
        String aiContextFileContent = ParamsExpander.getProjectAIContextContents(pluginWS);
        if (aiContextFileContent != null) {
            if (expandValue == null) {
                expandValue = "";
            }
            if (!((String)expandValue).isEmpty()) {
                expandValue = (String)expandValue + "\n\n";
            }
            expandValue = (String)expandValue + aiContextFileContent;
        }
        return expandValue;
    }

    public static String getProjectAIContextContents(PluginWorkspace pluginWS) {
        WSOptionsStorage optionsStorage;
        String additionalContextFiles;
        String content = null;
        if (pluginWS != null && pluginWS.getUtilAccess() != null && pluginWS.getOptionsStorage() != null && (additionalContextFiles = (optionsStorage = pluginWS.getOptionsStorage()).getOption("oxygen.positron.plugin.additional.context.file", "${pd}/ai-context.md, ${pd}/positron-ai/ai-context.md, ${pd}/positron-ai-actions/ai-context.md")) != null && !additionalContextFiles.trim().isEmpty()) {
            content = ParamsExpander.expandAllAdditionalContextFiles(pluginWS, content, additionalContextFiles);
        }
        if (content != null && content.isEmpty()) {
            content = null;
        }
        return content;
    }

    private static String expandAllAdditionalContextFiles(PluginWorkspace pluginWS, String content, String additionalContextFiles) {
        block4: {
            try {
                String[] allFilePaths;
                for (String additionalContextFile : allFilePaths = additionalContextFiles.split(",")) {
                    File extraContextFile;
                    additionalContextFile = pluginWS.getUtilAccess().expandEditorVariables(additionalContextFile.trim(), null);
                    if (additionalContextFile == null || !(extraContextFile = new File(additionalContextFile)).exists()) continue;
                    String extraContent = ActionsUtil.unescapeEditorVariables((String)IOUtil.readFile((File)extraContextFile, (String)"UTF-8"));
                    content = content == null ? extraContent : (String)content + "\n\n" + extraContent;
                }
            }
            catch (IOException e) {
                logger.error("Could not obtain content of context file " + e.getMessage(), (Throwable)e);
            }
            catch (AccessControlException ex) {
                logger.info("Could not load context from actions folder, probably running in WebAuthor with limited access control " + ex.getMessage());
                if (!logger.isDebugEnabled()) break block4;
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
        }
        return content;
    }

    private static String expandCurrentEditorLocation(DocumentDetailsProvider docDetailsProvider, String toExpand) {
        if (docDetailsProvider != null && toExpand.contains(PositronEditorVariables.CURRENT_EDITOR_OXY_EDITOR_VARIABLE.getValue())) {
            URL processedEditorLocation = URLUtil.clearUserInfo((String)docDetailsProvider.getEditorLocation());
            if (processedEditorLocation != null) {
                String expandedInfo = processedEditorLocation.toExternalForm();
                toExpand = toExpand.replace(PositronEditorVariables.CURRENT_EDITOR_OXY_EDITOR_VARIABLE.getValue(), expandedInfo);
            } else {
                toExpand = toExpand.replace(PositronEditorVariables.CURRENT_EDITOR_OXY_EDITOR_VARIABLE.getValue(), "");
            }
        }
        return toExpand;
    }

    private static String expandProjectURL(DocumentDetailsProvider docDetailsProvider, String toExpand) {
        if (toExpand.contains(PositronEditorVariables.PROJECT_DIR_OXY_EDITOR_VARIABLE.getValue()) && docDetailsProvider != null) {
            URL projectURL = null;
            if (docDetailsProvider.getProjectRootURL() != null && (projectURL = URLUtil.clearUserInfo((URL)docDetailsProvider.getProjectRootURL())) != null && projectURL.toString().endsWith(DESKTOP_OXYGEN_PROJECT_EXTENSION)) {
                try {
                    projectURL = URLUtil.getParentURL((URL)projectURL);
                }
                catch (MalformedURLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            toExpand = toExpand.replace(PositronEditorVariables.PROJECT_DIR_OXY_EDITOR_VARIABLE.getValue(), projectURL != null ? projectURL.toExternalForm() : "");
        }
        return toExpand;
    }

    public static void updateDocumentLocationParams(List<ActionParam> actionParams, DocumentDetailsProvider docDetailsProvider, Map<String, String> expandedParamsToUpdate) {
        if (actionParams != null && expandedParamsToUpdate != null) {
            for (ActionParam actionParam : actionParams) {
                String paramValue = actionParam.getValue();
                if (paramValue == null || paramValue.isEmpty() || !paramValue.contains(PositronEditorVariables.APPLICATION_CONTEXT_EDITOR_VARIABLE.getValue()) && !paramValue.contains(PositronEditorVariables.CURRENT_EDITOR_OXY_EDITOR_VARIABLE.getValue()) && !paramValue.contains(PositronEditorVariables.PROJECT_DIR_OXY_EDITOR_VARIABLE.getValue()) && !paramValue.contains(PositronEditorVariables.CURRENT_DITA_MAP_EDITOR_VARIABLE.getValue()) && !paramValue.contains(PositronEditorVariables.CONTENT_TYPE_DESCRIPTION.getValue())) continue;
                Object expanded = ParamsExpander.expandAppContext(docDetailsProvider, paramValue);
                expanded = ParamsExpander.expandCurrentEditorLocation(docDetailsProvider, (String)expanded);
                expanded = ParamsExpander.expandProjectURL(docDetailsProvider, (String)expanded);
                expanded = ParamsExpander.expandRootMapURL(docDetailsProvider, (String)expanded);
                expanded = ParamsExpander.expandContentTypeDescription(docDetailsProvider, (String)expanded, "XML");
                String prefixValue = actionParam.getPrefix();
                if (prefixValue != null && !prefixValue.isEmpty() && expanded != null && !((String)expanded).isEmpty()) {
                    expanded = prefixValue + (String)expanded;
                }
                expandedParamsToUpdate.put(actionParam.getName(), (String)expanded);
            }
        }
    }

    private static String expandAppContext(DocumentDetailsProvider docDetailsProvider, String toExpand) {
        if (toExpand.contains(PositronEditorVariables.APPLICATION_CONTEXT_EDITOR_VARIABLE.getValue())) {
            String cp;
            PluginWorkspace pw = PluginWorkspaceProvider.getPluginWorkspace();
            Object expandedAppContext = "\n\nOptional application specific metadata details:";
            if (pw != null && pw.getApplicationName() != null) {
                expandedAppContext = (String)expandedAppContext + "\n- Name and version of the application in which the content is edited: " + pw.getApplicationName() + " " + pw.getVersion();
                if (pw.getApplicationType() != ApplicationType.XML_WEB_AUTHOR) {
                    expandedAppContext = (String)expandedAppContext + "\n- Operating system name and version: " + System.getProperty("os.name") + " " + System.getProperty("os.version");
                    Locale locale = Locale.getDefault();
                    expandedAppContext = (String)expandedAppContext + "\n- Locale country/language/code: " + locale.getDisplayCountry() + "/" + locale.getDisplayLanguage() + "/" + locale.getCountry();
                }
                ZonedDateTime now = ZonedDateTime.now();
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                expandedAppContext = (String)expandedAppContext + "\n- Current date: " + now.format(formatter);
            }
            if ((cp = ParamsExpander.expandProjectURL(docDetailsProvider, PositronEditorVariables.PROJECT_DIR_OXY_EDITOR_VARIABLE.getValue())) != null && !cp.isEmpty() && !PositronEditorVariables.PROJECT_DIR_OXY_EDITOR_VARIABLE.getValue().equals(cp)) {
                expandedAppContext = (String)expandedAppContext + "\n- The current project root directory URL: " + cp;
            }
            expandedAppContext = ParamsExpander.expandMainFilesInfo(pw, (String)expandedAppContext);
            String cmu = ParamsExpander.expandRootMapURL(docDetailsProvider, PositronEditorVariables.CURRENT_DITA_MAP_EDITOR_VARIABLE.getValue());
            if (cmu != null && !cmu.isEmpty() && !PositronEditorVariables.CURRENT_DITA_MAP_EDITOR_VARIABLE.getValue().equals(cmu)) {
                expandedAppContext = (String)expandedAppContext + "\n- The current DITA Map URL: " + cmu;
            }
            expandedAppContext = ParamsExpander.expandCurrentFileInfo(docDetailsProvider, (String)expandedAppContext);
            expandedAppContext = (String)expandedAppContext + "\n\n";
            toExpand = toExpand.replace(PositronEditorVariables.APPLICATION_CONTEXT_EDITOR_VARIABLE.getValue(), (CharSequence)expandedAppContext);
        }
        return toExpand;
    }

    private static String expandCurrentFileInfo(DocumentDetailsProvider docDetailsProvider, String expandedAppContext) {
        String edURL = ParamsExpander.expandCurrentEditorLocation(docDetailsProvider, PositronEditorVariables.CURRENT_EDITOR_OXY_EDITOR_VARIABLE.getValue());
        if (edURL != null && !edURL.isEmpty() && !PositronEditorVariables.CURRENT_EDITOR_OXY_EDITOR_VARIABLE.getValue().equals(edURL)) {
            String cd;
            String caretSelectionInfo;
            expandedAppContext = (String)expandedAppContext + "\n- The currently edited document URL: " + edURL;
            String string = caretSelectionInfo = docDetailsProvider != null ? docDetailsProvider.getCaretSelectionInfo() : null;
            if (caretSelectionInfo != null && !caretSelectionInfo.isEmpty()) {
                expandedAppContext = (String)expandedAppContext + "\n  - " + caretSelectionInfo;
            }
            if ((cd = ParamsExpander.expandContentTypeDescription(docDetailsProvider, PositronEditorVariables.CONTENT_TYPE_DESCRIPTION.getValue(), "XML")) != null && !cd.isEmpty() && !PositronEditorVariables.CONTENT_TYPE_DESCRIPTION.getValue().equals(cd)) {
                expandedAppContext = (String)expandedAppContext + "\n  - The type of the current edited document: " + cd;
            }
        }
        return expandedAppContext;
    }

    private static String expandMainFilesInfo(PluginWorkspace pw, String expandedAppContext) {
        Iterator mfIter;
        ProjectController projectManager;
        if (pw.getApplicationType() != ApplicationType.XML_WEB_AUTHOR && pw instanceof StandalonePluginWorkspace && (projectManager = ((StandalonePluginWorkspace)pw).getProjectManager()) != null && (mfIter = projectManager.getMainFileResourcesIterator()) != null && mfIter.hasNext()) {
            Object mainResources = "\n- Primary project files [Main project files on which publishing is usually performed]: ";
            while (mfIter.hasNext()) {
                mainResources = (String)mainResources + "\n  - " + mfIter.next();
            }
            expandedAppContext = (String)expandedAppContext + (String)mainResources;
        }
        return expandedAppContext;
    }

    public static String getConfigurableParamsTooltip(String actionID, List<ActionParam> params) {
        StringBuilder tt = new StringBuilder();
        if (params == null) {
            return "";
        }
        for (ActionParam actionParam : params) {
            String value;
            if (!ParamsExpander.isChoiceParam(actionParam)) continue;
            if (tt.length() == 0) {
                tt.append("\n");
            }
            String paramLabel = actionParam.getLabel() != null ? actionParam.getLabel() : actionParam.getName();
            tt.append("\n").append(paramLabel).append(": ");
            String string = value = actionParam.getValue() != null ? actionParam.getValue() : "";
            if (value.isBlank() || !actionID.equals("action.translate.to.lang")) {
                value = ParamsExpander.getChoiceParamStoredConfigLabel(actionID, actionParam, value);
            }
            tt.append(value.isEmpty() ? Translator.getInstance().getTranslation("Unspecified") : value);
        }
        return tt.toString();
    }

    private static String getChoiceParamStoredConfigValue(String actionID, ActionParam actionParam, String defaultValue) {
        String val = defaultValue;
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        String storedValue = optionsStorage.getOption("oxygen.positron.plugin." + actionID + VALS_SEPARATOR + actionParam.getName(), "");
        if (storedValue != null && !storedValue.isEmpty()) {
            val = storedValue.replace(VALS_SEPARATOR, " ");
        }
        return val;
    }

    public static String getChoiceParamStoredConfigLabel(String actionID, ActionParam actionParam, String defaultValue) {
        ArrayList<String> vals = new ArrayList<String>();
        vals.add(defaultValue);
        String storedValue = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption("oxygen.positron.plugin." + actionID + VALS_SEPARATOR + actionParam.getName(), "");
        if (storedValue != null && !storedValue.isEmpty()) {
            vals.clear();
            vals.addAll(Arrays.asList(storedValue.split(VALS_SEPARATOR)));
        }
        StringBuilder labels = new StringBuilder();
        for (String val : vals) {
            if (val.isEmpty()) continue;
            ParamsExpander.appendLabel(actionParam, labels, val);
        }
        return labels.toString();
    }

    public static void appendLabel(ActionParam actionParam, StringBuilder labels, String val) {
        String[] alts = actionParam.getAlternateValues();
        boolean identifiedLabel = false;
        if (alts != null) {
            for (int i = 0; i < alts.length; ++i) {
                if (!alts[i].equals(val)) continue;
                String label = val;
                String[] labelValues = actionParam.getAlternateValueLabels();
                if (labelValues != null && i < labelValues.length) {
                    label = labelValues[i];
                }
                labels.append(label).append(" ");
                identifiedLabel = true;
                break;
            }
        }
        if (!identifiedLabel) {
            labels.append(val).append(" ");
        }
    }

    public static void storeActionParams(String actionID, Map<String, Set<String>> params) {
        for (String paramName : params.keySet()) {
            Set<String> chosenVals = params.get(paramName);
            StringBuilder choice = new StringBuilder();
            Iterator<String> valsIter = chosenVals.iterator();
            while (valsIter.hasNext()) {
                choice.append(valsIter.next());
                if (!valsIter.hasNext()) continue;
                choice.append(VALS_SEPARATOR);
            }
            PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().setOption("oxygen.positron.plugin." + actionID + VALS_SEPARATOR + paramName, choice.toString());
        }
    }

    public static boolean isChoiceParam(ActionParam actionParam) {
        String choiceType = actionParam.getChoiceType();
        return SINGLE_CHOICE_PARAM_TYPE.equals(choiceType) || MULTI_CHOICE_PARAM_TYPE.equals(choiceType) || EDITABLE_COMBO_CHOICE_PARAM_TYPE.equals(choiceType);
    }

    public static String expandContentTypeDescription(DocumentDetailsProvider docDetailsProvider, String value, String xmlCTSuffix) {
        Object fileContentType = "";
        if (value.contains(PositronEditorVariables.CONTENT_TYPE_DESCRIPTION.getValue()) && docDetailsProvider != null) {
            Optional<String> contentType = docDetailsProvider.getContentType();
            Optional<String> documentTypeName = docDetailsProvider.getDocumentTypeName();
            if (contentType.isPresent()) {
                fileContentType = contentType.get();
                if ("text/sch".equals(contentType.get())) {
                    fileContentType = "ISO Schematron";
                } else if (documentTypeName.isPresent()) {
                    if ("text/xml".equals(contentType.get())) {
                        fileContentType = xmlCTSuffix;
                    }
                    fileContentType = documentTypeName.get() + " " + (String)fileContentType;
                }
            }
        }
        return value.replace(PositronEditorVariables.CONTENT_TYPE_DESCRIPTION.getValue(), (CharSequence)fileContentType);
    }

    private static String expandContextXPath() {
        String expandedValue;
        block6: {
            PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
            expandedValue = "";
            if (pluginWorkspace != null) {
                try {
                    WSEditorPage currentPage;
                    WSEditor editor = pluginWorkspace.getCurrentEditorAccess(0);
                    if (editor == null || !((currentPage = editor.getCurrentPage()) instanceof WSXMLTextEditorPage)) break block6;
                    WSXMLTextEditorPage wsxmlCurentPage = (WSXMLTextEditorPage)currentPage;
                    try {
                        Method getXPath = wsxmlCurentPage.getClass().getDeclaredMethod("getXPath", Integer.TYPE, Boolean.TYPE);
                        if (getXPath != null) {
                            int[] caretOffs = new int[1];
                            SafeUIExecutor.getInstance().syncExec(() -> {
                                caretOffs[0] = wsxmlCurentPage.getCaretOffset();
                            });
                            expandedValue = (String)getXPath.invoke((Object)wsxmlCurentPage, caretOffs[0], true);
                        }
                    }
                    catch (NoSuchMethodException e) {
                        logger.debug(e.getMessage());
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return expandedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCurrentFileAssociatedScenarioInstance(boolean isTransformation) {
        String expandedValue;
        block10: {
            PluginWorkspace pluginWorkspace = PluginWorkspaceProvider.getPluginWorkspace();
            if (pluginWorkspace == null) {
                return "";
            }
            WSEditor editor = pluginWorkspace.getCurrentEditorAccess(0);
            if (editor == null) {
                return "";
            }
            expandedValue = "";
            try {
                Reader reader;
                String contentType = editor.getContentType();
                URL associatedInput = null;
                if (isTransformation && ("text/xsl".equals(contentType) || "text/xquery".equals(contentType))) {
                    associatedInput = InstanceExpanderUtil.getAssociatedTransformationScenarioInputURL(pluginWorkspace.getXMLUtilAccess(), editor.getEditorLocation());
                } else if ("text/xsd".equals(contentType) || "text/sch".equals(contentType) || "text/dtd".equals(contentType) || "text/rnc".equals(contentType) || "text/rng".equals(contentType)) {
                    associatedInput = InstanceExpanderUtil.getAssociatedValidationScenarioInputURL(pluginWorkspace.getXMLUtilAccess(), editor.getEditorLocation());
                }
                if (associatedInput == null || !"file".equalsIgnoreCase(associatedInput.getProtocol()) || (reader = pluginWorkspace.getUtilAccess().createReader(associatedInput, StandardCharsets.UTF_8.name())) == null) break block10;
                try {
                    expandedValue = InstanceExpanderUtil.getXMLStructureAsDTD(pluginWorkspace.getXMLUtilAccess(), reader);
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                logger.error("Failed to read associated file: " + e.getMessage(), (Throwable)e);
            }
        }
        return expandedValue;
    }

    private static String expandRootMapURL(DocumentDetailsProvider docDetailsProvider, String toExpand) {
        if (toExpand.contains(PositronEditorVariables.CURRENT_DITA_MAP_EDITOR_VARIABLE.getValue()) && docDetailsProvider != null) {
            URL rootMapURL = null;
            if (docDetailsProvider.getCurrentDITAMapURL() != null) {
                rootMapURL = URLUtil.clearUserInfo((URL)docDetailsProvider.getCurrentDITAMapURL());
            }
            toExpand = toExpand.replace(PositronEditorVariables.CURRENT_DITA_MAP_EDITOR_VARIABLE.getValue(), rootMapURL != null ? rootMapURL.toExternalForm() : "");
        }
        return toExpand;
    }
}

