/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core;

import com.oxygenxml.positron.api.connector.AIConnector;
import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.connector.AIConnectorConfiguration;
import com.oxygenxml.positron.connector.OxyProxyProvider;
import com.oxygenxml.positron.core.AIConnectorConfigurationProvider;
import com.oxygenxml.positron.core.util.IModelsProvider;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyDetailsProvider;

public class SingleAIConnectorConfigurationProvider
implements AIConnectorConfigurationProvider {
    private Supplier<AIConnector> currentConnectorSupplier;
    private ProxyDetailsProvider proxyDetailsProvider;
    private IModelsProvider modelsProvider;

    public SingleAIConnectorConfigurationProvider(Supplier<AIConnector> currentConnectorSupplier, ProxyDetailsProvider proxyDetailsProvider, IModelsProvider modelsProvider) {
        this.currentConnectorSupplier = currentConnectorSupplier;
        this.proxyDetailsProvider = proxyDetailsProvider;
        this.modelsProvider = modelsProvider;
    }

    @Override
    public AIConnectorConfiguration getCurrentConfiguration() {
        AIConnector currentConnector = this.currentConnectorSupplier.get();
        AIConnectorConfiguration connectorConfiguration = new AIConnectorConfiguration(currentConnector.getConnectorName(), currentConnector);
        connectorConfiguration.setProxyProvider(new OxyProxyProvider(this.proxyDetailsProvider));
        return connectorConfiguration;
    }

    @Override
    public AIConnectorConfiguration getConfigurationById(String configurationId) {
        AIConnectorConfiguration currentConfiguration = this.getCurrentConfiguration();
        if (configurationId != null && configurationId.equals(currentConfiguration.getConfigurationId())) {
            return currentConfiguration;
        }
        return null;
    }

    @Override
    public AIConnectorConfiguration getFirstConfigurationWithModel(String modelId) {
        AIConnectorConfiguration currentConfig;
        Map<String, List<ModelDescriptor>> availableEngines;
        List<ModelDescriptor> models;
        AIConnectorConfiguration toRet = null;
        if (modelId != null && (models = (availableEngines = this.modelsProvider.getAvailableEngines()).get((currentConfig = this.getCurrentConfiguration()).getConnectorName())) != null) {
            boolean foundModel = false;
            for (ModelDescriptor modelDescriptor : models) {
                if (!modelId.equals(modelDescriptor.getId())) continue;
                foundModel = true;
                break;
            }
            if (foundModel) {
                toRet = currentConfig;
            }
        }
        return toRet;
    }
}

