/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core;

import com.oxygenxml.positron.api.connector.AIConnectionException;
import com.oxygenxml.positron.api.connector.dto.CompletionChunk;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.ModelDescriptor;
import com.oxygenxml.positron.api.connector.dto.ResponseFormatDTO;
import com.oxygenxml.positron.api.connector.dto.SpeechToTextRequest;
import com.oxygenxml.positron.core.AICompletionDetailsProvider;
import com.oxygenxml.positron.core.AICompletionStreamResponse;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.OxyHttpClientExtraConfigProvider;
import com.oxygenxml.positron.core.api.CreditsUsageInfo;
import com.oxygenxml.positron.core.api.ExecutableAction;
import com.oxygenxml.positron.core.api.PositronCompletionChunk;
import com.oxygenxml.positron.core.api.UsageReport;
import com.oxygenxml.positron.core.auth.requests.BearerTokenProvider;
import com.oxygenxml.positron.core.auth.requests.ServerUrlChangedListener;
import com.oxygenxml.positron.core.auth.requests.ServerUrlProvider;
import com.oxygenxml.positron.core.engines.EnginesManagerProvider;
import com.oxygenxml.positron.core.engines.IEnginesManager;
import com.oxygenxml.positron.core.interactions.CreditsUsageNotifier;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.responses.ResponseFormatsRepository;
import com.oxygenxml.positron.core.service.PositronService;
import com.oxygenxml.positron.core.service.config.UserAgentInfo;
import com.oxygenxml.positron.core.tools.ToolsExecutionHandler;
import com.oxygenxml.positron.core.util.attach.MessageAttachmentUtils;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import com.oxygenxml.positron.utilities.ModelIdentifierUtil;
import com.oxygenxml.positron.utilities.error.ApiErrorCodes;
import com.oxygenxml.positron.utilities.functions.IFunctionSignaturesRepository;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.Parameters;
import com.oxygenxml.positron.utilities.response.IResponseFormatsRepository;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.execution.StoppedByUserException;
import ro.sync.exml.workspace.api.standalone.proxy.ProxyDetailsProvider;

public class PositronAICompletionDetailsProvider
extends AICompletionDetailsProvider {
    static final Logger LOGGER = LoggerFactory.getLogger((String)PositronAICompletionDetailsProvider.class.getName());
    private PositronService positronService;
    private ServerUrlProvider serverUrlProvider;
    private final CreditsUsageNotifier creditsUsageNotifier;
    private IFunctionSignaturesRepository functionDefinitionsRepository;
    private ResponseFormatsRepository responseFormatsRepository;
    private static final List<String> ERROR_CODES = Arrays.asList(ApiErrorCodes.CREDITS_LIMIT_EXCEEDED.getCode(), ApiErrorCodes.NOT_ENOUGH_CREDITS.getCode(), ApiErrorCodes.PLAN_EXPIRED.getCode());

    public PositronAICompletionDetailsProvider(final ServerUrlProvider serverUrlProvider, final BearerTokenProvider tokenProvider, ProxyDetailsProvider proxyProvider, final UserAgentInfo userAgentInfo, CreditsUsageNotifier creditsUsageNotifier) {
        this.serverUrlProvider = serverUrlProvider;
        this.creditsUsageNotifier = creditsUsageNotifier;
        final OxyHttpClientExtraConfigProvider httpClientExtraConfigProvider = new OxyHttpClientExtraConfigProvider(proxyProvider);
        this.positronService = new PositronService(serverUrlProvider.getServerUrl(), tokenProvider, httpClientExtraConfigProvider, userAgentInfo);
        serverUrlProvider.addServerUrlChangedListener(new ServerUrlChangedListener(){

            @Override
            public void serverUrlChanged() {
                PositronAICompletionDetailsProvider.this.positronService = new PositronService(serverUrlProvider.getServerUrl(), tokenProvider, httpClientExtraConfigProvider, userAgentInfo);
            }
        });
    }

    @Override
    protected AICompletionStreamResponse executeActionIncrementalInternal(AIActionDetails actionDetails, List<Message> messages, Map<String, String> parameters) throws CannotComputeCompletionDetailsException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing local action '{}' from category '{}'...", (Object)actionDetails.getId(), (Object)actionDetails.getCategoryId());
        }
        PositronAICompletionDetailsProvider.expandPositronSpecificParams(parameters);
        actionDetails = ModelIdentifierUtil.stripConfigurationFromEngineIfPresent((AIActionDetails)actionDetails);
        ExecutableAction executableAction = new ExecutableAction(messages, parameters, actionDetails);
        executableAction.setFunctionsToUse(this.functionDefinitionsRepository, this.getDisabledToolsChecker());
        ResponseFormatDTO responseFormatDTO = AIRequestUtil.expandResponseFormat((Parameters)actionDetails.getParameters(), (IResponseFormatsRepository)this.responseFormatsRepository);
        executableAction.setResponseFormat(responseFormatDTO);
        Flowable<PositronCompletionChunk> completionFlux = this.positronService.executeActionIncremental(executableAction);
        ToolsExecutionHandler toolsExecutor = this.getToolsExecutionHandler();
        if (toolsExecutor != null) {
            completionFlux = toolsExecutor.handleToolCalls(executableAction.getMessages(), completionFlux, updatedMessages -> {
                updatedMessages = this.applyMessageFiltering(updatedMessages);
                executableAction.setMessages(updatedMessages);
                return this.positronService.executeActionIncremental(executableAction);
            });
        }
        completionFlux = this.updateCreditsUsageInfo(completionFlux);
        return new AICompletionStreamResponse((Flowable<CompletionChunk>)completionFlux.map(CompletionChunk.class::cast), responseFormatDTO != null);
    }

    private Flowable<PositronCompletionChunk> updateCreditsUsageInfo(Flowable<PositronCompletionChunk> streamChunks) {
        return streamChunks.map(chunk -> {
            CreditsUsageInfo creditsUsageInfo = chunk.getCreditsUsageInfo();
            if (creditsUsageInfo != null) {
                this.creditsUsageNotifier.checkCreditsAndNotifyIfNecessary(creditsUsageInfo.getUsedCredits(), creditsUsageInfo.getTotalCredits());
            }
            return chunk;
        });
    }

    public UsageReport getUsageReport() throws CannotComputeCompletionDetailsException, StoppedByUserException {
        return this.positronService.getUsageReport();
    }

    public String getServerUrl() {
        return this.serverUrlProvider.getServerUrl();
    }

    private static void expandPositronSpecificParams(Map<String, String> paramsToExpand) {
        String imposedEngine;
        IEnginesManager enginesManager = EnginesManagerProvider.getInstance().getEnginesManager();
        if (enginesManager != null) {
            String defaultEngineModel = null;
            ModelDescriptor currentEngineDescriptor = enginesManager.getCurrentEngineDescriptor();
            if (currentEngineDescriptor != null) {
                defaultEngineModel = currentEngineDescriptor.getId();
            }
            if (defaultEngineModel != null && defaultEngineModel.startsWith("aips")) {
                defaultEngineModel = ModelIdentifierUtil.extractModelId((String)defaultEngineModel);
            }
            paramsToExpand.put("default.engine.model", defaultEngineModel);
        }
        if ((imposedEngine = paramsToExpand.get("imposed.engine.model")) != null && imposedEngine.startsWith("aips")) {
            imposedEngine = ModelIdentifierUtil.extractModelId((String)imposedEngine);
            paramsToExpand.put("imposed.engine.model", imposedEngine);
        }
    }

    public void setPositronServiceForTC(PositronService positronService) {
        this.positronService = positronService;
    }

    @Override
    public Map<String, String> computeErrorLink(Throwable exception) {
        HashMap<String, String> links = new HashMap<String, String>();
        String errorCode = this.getErrorCode(exception);
        if (errorCode != null && ERROR_CODES.contains(errorCode)) {
            links.put(Translator.getInstance().getTranslation("Manage_subscription") + "...", this.getServerUrl() + "/subscriptions");
        }
        return links;
    }

    private String getErrorCode(Throwable exception) {
        while (exception != null) {
            if (exception instanceof CannotComputeCompletionDetailsException) {
                return ((CannotComputeCompletionDetailsException)exception).getPositronErrorCode();
            }
            exception = exception.getCause();
        }
        return null;
    }

    @Override
    public String getHumanReadableErrorMessageToPresent(Throwable t) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(t.getMessage(), t);
        }
        return super.getHumanReadableErrorMessageToPresent(t);
    }

    @Override
    public List<Message> expandEditorVariables(List<Message> messages, AIActionDetails action) throws CannotComputeCompletionDetailsException {
        return MessageAttachmentUtils.expandAttachments(messages, action);
    }

    public void setFunctionSignaturesRepository(IFunctionSignaturesRepository functionSignaturesRepository) {
        this.functionDefinitionsRepository = functionSignaturesRepository;
    }

    public void setResponseFormatsRepository(ResponseFormatsRepository responseFormatsRepository) {
        this.responseFormatsRepository = responseFormatsRepository;
    }

    @Override
    public boolean isEnabledSpeechToText() {
        return this.positronService != null;
    }

    @Override
    public String convertSpeechToText(SpeechToTextRequest speechRequest) throws AIConnectionException {
        try {
            return this.positronService.convertSpeechToText(speechRequest);
        }
        catch (CannotComputeCompletionDetailsException | StoppedByUserException e) {
            LOGGER.error(e.getMessage(), e);
            throw new AIConnectionException(e.getMessage());
        }
    }
}

