/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.core;

import com.google.common.collect.ImmutableSet;
import com.oxygenxml.positron.api.connector.AIConnectionException;
import com.oxygenxml.positron.api.connector.AIConnector;
import com.oxygenxml.positron.api.connector.AIService;
import com.oxygenxml.positron.api.connector.dto.CompletionChunk;
import com.oxygenxml.positron.api.connector.dto.CompletionRequest;
import com.oxygenxml.positron.api.connector.dto.CompletionResponse;
import com.oxygenxml.positron.api.connector.dto.Message;
import com.oxygenxml.positron.api.connector.dto.ModerationRequest;
import com.oxygenxml.positron.api.connector.dto.SpeechToTextRequest;
import com.oxygenxml.positron.connector.AIConnectorConfiguration;
import com.oxygenxml.positron.connector.api.BuiltInAIConnector;
import com.oxygenxml.positron.connector.grok.GrokConnector;
import com.oxygenxml.positron.connector.util.ReactiveUtil;
import com.oxygenxml.positron.core.AICompletionDetailsProvider;
import com.oxygenxml.positron.core.AICompletionStreamResponse;
import com.oxygenxml.positron.core.AIConnectorConfigurationProvider;
import com.oxygenxml.positron.core.CannotComputeCompletionDetailsException;
import com.oxygenxml.positron.core.InvalidUserConfigurationException;
import com.oxygenxml.positron.core.api.CompletionResponseUtil;
import com.oxygenxml.positron.core.plugin.Translator;
import com.oxygenxml.positron.core.responses.ResponseFormatsRepository;
import com.oxygenxml.positron.core.service.PositronServiceUtil;
import com.oxygenxml.positron.core.tools.ToolsExecutionHandler;
import com.oxygenxml.positron.core.util.attach.MessageAttachmentUtils;
import com.oxygenxml.positron.utilities.AIRequestUtil;
import com.oxygenxml.positron.utilities.ModelIdentifierUtil;
import com.oxygenxml.positron.utilities.action.ActionsUtil;
import com.oxygenxml.positron.utilities.exceptions.InvalidMessageException;
import com.oxygenxml.positron.utilities.exceptions.ModelTokensLimitExcededException;
import com.oxygenxml.positron.utilities.functions.IDisabledToolsChecker;
import com.oxygenxml.positron.utilities.functions.IFunctionSignaturesRepository;
import com.oxygenxml.positron.utilities.json.AIActionDetails;
import com.oxygenxml.positron.utilities.json.Engine;
import com.oxygenxml.positron.utilities.json.MessageUtil;
import com.oxygenxml.positron.utilities.response.IResponseFormatsRepository;
import io.reactivex.rxjava3.core.Flowable;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.HttpException;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.options.WSOptionsStorage;

public class ExternalAICompletionDetailsProvider
extends AICompletionDetailsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ExternalAICompletionDetailsProvider.class.getName());
    private static final String MS_AZURE_DEPLOYMENT_NOT_FOUND = "DeploymentNotFound";
    private static final String OPEN_AI_INVALID_ORGANIZATION = "invalid_organization";
    private static final String OPEN_AI_INVALID_API_KEY = "invalid_api_key";
    private static final String OPEN_AI_INVALID_MODEL = "model_not_found";
    private static final Set<String> INVALID_CONNECTION_ERROR_CODES = ImmutableSet.of((Object)String.valueOf(404), (Object)String.valueOf(405), (Object)String.valueOf(502), (Object)String.valueOf(500), (Object)String.valueOf(401), (Object)"DeploymentNotFound", (Object[])new String[]{"invalid_organization", "invalid_api_key", "model_not_found"});
    private AIConnectorConfigurationProvider connectorConfigurationProvider;
    private IFunctionSignaturesRepository functionDefitionsRepository;
    private ResponseFormatsRepository responseFormatsRepository;

    public ExternalAICompletionDetailsProvider(AIConnectorConfigurationProvider configurationProvider) {
        this.connectorConfigurationProvider = configurationProvider;
    }

    protected boolean shouldNotifyToolsListenerWhenHandlingCallsOnNonStreaming() {
        return false;
    }

    private CompletionRequest createCompletionRequest(AIConnectorConfiguration aiConnectorConfiguration, AIActionDetails actionDetails, List<Message> messages, Map<String, String> parameters) throws ModelTokensLimitExcededException, InvalidMessageException {
        boolean shouldEnableCache;
        AIRequestUtil.aggregateContextIfNeeded(messages, (AIActionDetails)actionDetails, parameters);
        CompletionRequest completionRequest = AIRequestUtil.getCompletionRequestPayload(messages, (AIActionDetails)actionDetails, (IFunctionSignaturesRepository)this.functionDefitionsRepository, (IResponseFormatsRepository)this.responseFormatsRepository, null, (boolean)true, (Integer)this.getMaxTokenLimitFromOptions(), (IDisabledToolsChecker)this.getDisabledToolsChecker());
        if ((completionRequest.getEnableCache() == null || !completionRequest.getEnableCache().booleanValue()) && (shouldEnableCache = AIRequestUtil.shouldEnableCache((AIActionDetails)actionDetails, messages))) {
            completionRequest.setEnableCache(Boolean.TRUE);
        }
        if (aiConnectorConfiguration != null) {
            AIConnector connector = aiConnectorConfiguration.getConnector();
            completionRequest = connector.configureCompletionRequest(completionRequest);
        }
        return completionRequest;
    }

    private void moderateInput(AIService aiService, List<Message> messages) throws AIConnectionException, CannotComputeCompletionDetailsException {
        String contentToModerate;
        boolean isFlaggedByModeration;
        if (aiService.isRequiringApplyingModeration() && (isFlaggedByModeration = aiService.applyModeration(new ModerationRequest(contentToModerate = AIRequestUtil.extractTextContentForModeration(messages))))) {
            throw new CannotComputeCompletionDetailsException("The content in the request is considered inappropriate.");
        }
    }

    @Override
    protected AICompletionStreamResponse executeActionIncrementalInternal(AIActionDetails actionDetails, List<Message> messages, Map<String, String> parameters) throws CannotComputeCompletionDetailsException, InvalidMessageException {
        try {
            boolean isImposedDisabledModeration;
            AIConnectorConfiguration connectorConfiguration = this.getConnectorConfigForAction(actionDetails, parameters);
            if (connectorConfiguration == null) {
                connectorConfiguration = this.connectorConfigurationProvider.getCurrentConfiguration();
                actionDetails = ActionsUtil.clearEngineFromActionDetails((AIActionDetails)actionDetails);
            }
            if (connectorConfiguration == null || connectorConfiguration.getAIService() == null) {
                throw new InvalidUserConfigurationException("No AI service connection configuration available", null);
            }
            AIService aiService = connectorConfiguration.getAIService();
            boolean bl = isImposedDisabledModeration = parameters != null && "true".equalsIgnoreCase(parameters.remove("imposed.disabled.moderation"));
            if (!isImposedDisabledModeration) {
                this.moderateInput(aiService, messages);
            }
            actionDetails = ActionsUtil.getActionDetailsWithNewEngine(parameters, (AIActionDetails)actionDetails);
            actionDetails = ModelIdentifierUtil.stripConfigurationFromEngineIfPresent((AIActionDetails)actionDetails);
            CompletionRequest completionRequest = this.createCompletionRequest(connectorConfiguration, actionDetails, messages, parameters);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Executing local action '{}' from category '{}'...", (Object)actionDetails.getId(), (Object)actionDetails.getCategoryId());
            }
            MessageUtil.removeResolutionFromImageMessages((List)completionRequest.getMessages());
            Flowable completionFlux = ReactiveUtil.translateFlowToFlowable(aiService.getCompletionFlux(completionRequest));
            AIActionDetails finalActionDetails = actionDetails;
            ToolsExecutionHandler handler = this.getToolsExecutionHandler();
            if (handler != null) {
                completionFlux = handler.handleToolCalls((List<Message>)completionRequest.getMessages(), completionFlux, updated -> {
                    boolean shouldEnableCache;
                    updated = this.applyMessageFiltering(updated);
                    completionRequest.setMessages(updated);
                    if ((completionRequest.getEnableCache() == null || !completionRequest.getEnableCache().booleanValue()) && (shouldEnableCache = AIRequestUtil.shouldEnableCache((AIActionDetails)finalActionDetails, (List)messages))) {
                        completionRequest.setEnableCache(Boolean.TRUE);
                    }
                    return ReactiveUtil.translateFlowToFlowable(aiService.getCompletionFlux(completionRequest));
                }, this.shouldTryMergeToolCallsForConnector(connectorConfiguration)).map(chunk -> chunk);
            }
            if (!isImposedDisabledModeration) {
                completionFlux = this.moderateFlowableCompletionResponse(aiService, completionFlux);
            }
            if (connectorConfiguration != null && connectorConfiguration.getConnector() instanceof BuiltInAIConnector) {
                BuiltInAIConnector buildInConnector = (BuiltInAIConnector)connectorConfiguration.getConnector();
                completionFlux = completionFlux.map(chunk -> {
                    buildInConnector.processCompletionResponse((CompletionResponse)chunk);
                    return chunk;
                });
            }
            completionFlux = PositronServiceUtil.handleFinalFlags(completionFlux);
            completionFlux = completionFlux.onErrorResumeNext(throwable -> {
                if (throwable instanceof IOException) {
                    return Flowable.error((Throwable)new InvalidUserConfigurationException(throwable.getMessage(), (Exception)throwable));
                }
                return Flowable.error((Throwable)throwable);
            });
            return new AICompletionStreamResponse((Flowable<CompletionChunk>)completionFlux, completionRequest.getResponseFormat() != null);
        }
        catch (ModelTokensLimitExcededException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            throw new CannotComputeCompletionDetailsException(e.getExcessInfoMessage());
        }
        catch (AIConnectionException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            String errorMessage = e.getMessage();
            if (e.getCause() instanceof HttpException) {
                HttpException httpException = (HttpException)e.getCause();
                if (ReactiveUtil.isInvalidOpenAiApiKey(e.getErrorCode(), httpException.code())) {
                    errorMessage = "Incorrect API key provided. You can find your API key at https://platform.openai.com/account/api-keys";
                }
            }
            throw new InvalidUserConfigurationException(errorMessage, (Exception)((Object)e));
        }
    }

    AIConnectorConfiguration getConnectorConfigForAction(AIActionDetails actionDetails, Map<String, String> parameters) throws InvalidUserConfigurationException {
        AIConnectorConfiguration toRet = null;
        AIActionDetails effective = ActionsUtil.getActionDetailsWithNewEngine(parameters, (AIActionDetails)actionDetails);
        if (effective != null && effective.getParameters() != null) {
            String modelIdentifier;
            Engine engine = effective.getParameters().getEngine();
            String string = modelIdentifier = engine != null ? engine.getId() : null;
            if (modelIdentifier != null) {
                String[] splitModelIdentifier = ModelIdentifierUtil.splitModelIdentifier((String)modelIdentifier);
                String connectionConfigId = splitModelIdentifier[0];
                String modelId = splitModelIdentifier[1];
                if ("aips".equals(connectionConfigId)) {
                    connectionConfigId = "";
                }
                if (connectionConfigId != null && !connectionConfigId.isEmpty() && (toRet = this.connectorConfigurationProvider.getConfigurationById(connectionConfigId)) == null) {
                    LOGGER.error("Cannot found connection configuration with id: " + connectionConfigId);
                }
                if (toRet == null && modelId != null && !modelId.isEmpty() && (toRet = this.connectorConfigurationProvider.getFirstConfigurationWithModel(modelId)) == null) {
                    LOGGER.error("Cannot found connection configuration that can handle the mode: " + modelId);
                }
            } else {
                toRet = this.connectorConfigurationProvider.getCurrentConfiguration();
            }
        } else {
            toRet = this.connectorConfigurationProvider.getCurrentConfiguration();
        }
        return toRet;
    }

    private Integer getMaxTokenLimitFromOptions() {
        WSOptionsStorage optionsStorage = PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage();
        String maxDefaultTokens = optionsStorage.getOption("oxygen.positron.plugin.default.max.tokens", "-1");
        Integer maxTokensValue = -1;
        try {
            maxTokensValue = NumberParserUtil.parseInt((String)maxDefaultTokens);
        }
        catch (NumberFormatException e) {
            LOGGER.debug((Throwable)e);
        }
        return maxTokensValue;
    }

    protected Flowable<CompletionChunk> moderateFlowableCompletionResponse(AIService aiService, Flowable<CompletionChunk> completionResponseFlux) {
        if (!aiService.isRequiringApplyingModeration()) {
            return completionResponseFlux;
        }
        StringBuilder allCompletion = new StringBuilder();
        return completionResponseFlux.doOnNext(chunk -> {
            String completion = CompletionResponseUtil.getCompletion((CompletionResponse)chunk);
            if (completion != null) {
                allCompletion.append(completion);
            }
        }).map(chunk -> {
            String finishReason = CompletionResponseUtil.getFinishReason((CompletionResponse)chunk);
            if (finishReason != null && !"content_filter".equals(finishReason)) {
                try {
                    boolean isFlaggedByModeration = aiService.applyModeration(new ModerationRequest(allCompletion.toString()));
                    if (isFlaggedByModeration) {
                        chunk.setFinishReason("moderationFlagged");
                    }
                }
                catch (Throwable e) {
                    LOGGER.error(e.getMessage(), e);
                }
            }
            return chunk;
        });
    }

    private boolean shouldTryMergeToolCallsForConnector(AIConnectorConfiguration aiConnectorConfiguration) {
        String model;
        String engineParam;
        Map connectorParams;
        Object modelParam;
        return aiConnectorConfiguration == null || !"grok-connector".equals(aiConnectorConfiguration.getConnectorId()) || !((modelParam = (connectorParams = aiConnectorConfiguration.getConnector().getResolvedParameters()).get(engineParam = ((GrokConnector)aiConnectorConfiguration.getConnector()).getModelParameterId())) instanceof String) || (model = (String)modelParam) == null || !model.startsWith("grok-3");
    }

    public String getCurentConnectorIdForTC() {
        AIConnectorConfiguration cfg = this.connectorConfigurationProvider.getCurrentConfiguration();
        return cfg != null ? cfg.getConnectorId() : "null";
    }

    @Override
    public Map<String, String> computeErrorLink(Throwable exception) {
        HashMap<String, String> links = new HashMap<String, String>();
        if (this.isConfigurationError(exception)) {
            links.put(Translator.getInstance().getTranslation("Review_configuration") + "...", "marker.open.config.page.action");
        }
        return links;
    }

    private String findErrorCode(Throwable exception) {
        while (exception != null) {
            if (exception instanceof AIConnectionException) {
                return ((AIConnectionException)exception).getErrorCode();
            }
            exception = exception.getCause();
        }
        return null;
    }

    @Override
    public String getHumanReadableErrorMessageToPresent(Throwable t) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(t.getMessage(), t);
        }
        if (this.isConfigurationError(t)) {
            return MessageFormat.format(Translator.getInstance().getTranslation(this.getConfigurationErrorMessageHintTag()), t.getMessage());
        }
        return super.getHumanReadableErrorMessageToPresent(t);
    }

    protected String getConfigurationErrorMessageHintTag() {
        return "Unable_to_connect_ai_service_reason_Check_config";
    }

    private boolean isConfigurationError(Throwable t) {
        if (t instanceof InvalidUserConfigurationException) {
            String errorCode = this.findErrorCode(t);
            return errorCode == null || INVALID_CONNECTION_ERROR_CODES.contains(errorCode);
        }
        return false;
    }

    @Override
    public List<Message> expandEditorVariables(List<Message> messages, AIActionDetails action) throws CannotComputeCompletionDetailsException {
        return MessageAttachmentUtils.expandAttachments(messages, action);
    }

    public void setResponseFormatsRepository(ResponseFormatsRepository responseFormatsRepository) {
        this.responseFormatsRepository = responseFormatsRepository;
    }

    public void setFunctionSignaturesRepository(IFunctionSignaturesRepository functionSignaturesRepository) {
        this.functionDefitionsRepository = functionSignaturesRepository;
    }

    @Override
    public boolean isEnabledSpeechToText() {
        try {
            AIConnectorConfiguration cfg = this.connectorConfigurationProvider.getCurrentConfiguration();
            return cfg != null && cfg.getAIService() != null && cfg.getAIService().isEnabledSpeechToText();
        }
        catch (CannotComputeCompletionDetailsException e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public String convertSpeechToText(SpeechToTextRequest speechRequest) throws AIConnectionException {
        try {
            AIConnectorConfiguration cfg = this.connectorConfigurationProvider.getCurrentConfiguration();
            if (cfg == null || cfg.getAIService() == null) {
                throw new AIConnectionException("No connector configuration available");
            }
            return cfg.getAIService().convertSpeechToText(speechRequest);
        }
        catch (AIConnectionException e) {
            throw e;
        }
        catch (CannotComputeCompletionDetailsException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new AIConnectionException(e.getMessage());
        }
    }
}

