/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.positron.connector.openai;

import com.oxygenxml.positron.utilities.debug.LoggerUtil;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.slf4j.Logger;

public class RequestLoggingInterceptor
implements Interceptor {
    Logger log;

    public RequestLoggingInterceptor(Logger logger) {
        this.log = logger;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (this.log.isDebugEnabled()) {
            try (Buffer requestBuffer = new Buffer();){
                if (request.body() != null) {
                    request.body().writeTo((BufferedSink)requestBuffer);
                }
                this.log.debug("--> Sending request to: {};\n\t Request body: {};\n\t Headers names: {} ", new Object[]{request.url(), LoggerUtil.filterMessagesFromRequestBody((String)requestBuffer.readUtf8()), request.headers().names()});
            }
        }
        return chain.proceed(request);
    }
}

